/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.user;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.user.UserCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationInfo
implements JsonSerializable {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationInfo.class);
    private static final Gson gson = new Gson();
    String user;
    List<String> roles;
    String ticket;
    UserCredentials userCredentials;
    public static final AuthenticationInfo ANONYMOUS = new AuthenticationInfo("anonymous", null, "anonymous");

    public AuthenticationInfo() {
    }

    public AuthenticationInfo(String user) {
        this.user = user;
    }

    public AuthenticationInfo(String user, String roles, String ticket) {
        this.user = user;
        this.ticket = ticket;
        this.roles = (List)gson.fromJson(roles, ArrayList.class);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setRoles(String roles) {
        this.roles = (List)gson.fromJson(roles, ArrayList.class);
    }

    public List<String> getUsersAndRoles() {
        ArrayList<String> usersAndRoles = new ArrayList<String>();
        if (this.roles != null) {
            usersAndRoles.addAll(this.roles);
        }
        if (this.user != null) {
            usersAndRoles.add(this.user);
        }
        return usersAndRoles;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public UserCredentials getUserCredentials() {
        return this.userCredentials;
    }

    public void setUserCredentials(UserCredentials userCredentials) {
        this.userCredentials = userCredentials;
    }

    public static boolean isAnonymous(AuthenticationInfo subject) {
        if (subject == null) {
            LOG.warn("Subject is null, assuming anonymous. Not recommended to use subject as null except in tests");
            return true;
        }
        return subject.isAnonymous();
    }

    public boolean isAnonymous() {
        return ANONYMOUS.equals(this) || "anonymous".equalsIgnoreCase(this.getUser()) || StringUtils.isEmpty((String)this.getUser());
    }

    @Override
    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static AuthenticationInfo fromJson(String json) {
        return (AuthenticationInfo)gson.fromJson(json, AuthenticationInfo.class);
    }
}

