/*
 * Decompiled with CFR 0.152.
 */
package oshi.json.hardware.impl;

import java.util.Properties;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import oshi.json.hardware.Baseboard;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.util.PropertiesUtil;

public class BaseboardImpl
extends AbstractOshiJsonObject
implements Baseboard {
    private static final long serialVersionUID = 1L;
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private oshi.hardware.Baseboard baseboard;

    public BaseboardImpl(oshi.hardware.Baseboard baseboard) {
        this.baseboard = baseboard;
    }

    @Override
    public String getManufacturer() {
        return this.baseboard.getManufacturer();
    }

    @Override
    public String getModel() {
        return this.baseboard.getModel();
    }

    @Override
    public String getVersion() {
        return this.baseboard.getVersion();
    }

    @Override
    public String getSerialNumber() {
        return this.baseboard.getSerialNumber();
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem.baseboard.manufacturer")) {
            json.add("manufacturer", this.getManufacturer());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem.baseboard.model")) {
            json.add("model", this.getModel());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem.baseboard.version")) {
            json.add("version", this.getVersion());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.computerSystem.baseboard.serialNumber")) {
            json.add("serialNumber", this.getSerialNumber());
        }
        return json.build();
    }

    @Override
    public String toString() {
        return this.baseboard.toString();
    }
}

