/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.bridge;

import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SLF4JBridgeHandler
extends Handler {
    private static final Logger metaLogger = Logger.getLogger("com.gigaspaces.log.SLF4JBridgeHandler");
    private static final Collection<Handler> handlers = Arrays.asList(SLF4JBridgeHandler.getRootLogger().getHandlers());

    public static void install() {
        SLF4JBridgeHandler.logSkipped("install");
    }

    private static Logger getRootLogger() {
        return LogManager.getLogManager().getLogger("");
    }

    public static void uninstall() throws SecurityException {
        SLF4JBridgeHandler.logSkipped("uninstall");
    }

    public static boolean isInstalled() throws SecurityException {
        SLF4JBridgeHandler.logSkipped("isInstalled");
        return false;
    }

    public static void removeHandlersForRootLogger() {
        SLF4JBridgeHandler.logSkipped("removeHandlersForRootLogger");
    }

    private static void logSkipped(String methodName) {
        if (metaLogger.isLoggable(Level.INFO)) {
            metaLogger.info(methodName + " is skipped - GigaSpaces SLF4JBridgeHandler is in use");
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
        handlers.forEach(Handler::flush);
    }

    @Override
    public void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        if (record.getMessage() == null) {
            record.setMessage("");
        }
        handlers.forEach(h -> h.publish(record));
    }

    static {
        metaLogger.info("GigaSpaces SLF4JBridgeHandler override is detected");
    }
}

