/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.pmem;

import com.gigaspaces.blobstore.pmem.PmemMemoryPool;
import com.gigaspaces.internal.license.LicenseManager;
import com.gigaspaces.internal.license.LicenseType;
import com.gigaspaces.server.blobstore.BlobStoreAddBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationType;
import com.gigaspaces.server.blobstore.BlobStoreConfig;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreObjectType;
import com.gigaspaces.server.blobstore.BlobStoreRemoveBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreReplaceBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreStorageHandler;
import com.j_spaces.core.cache.blobStore.IBlobStoreOffHeapInfo;
import com.j_spaces.core.cache.blobStore.memory_pool.AbstractMemoryPool;
import com.j_spaces.core.cache.blobStore.offheap.OffHeapStorageContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class PmemBlobStoreHandler
extends BlobStoreStorageHandler
implements OffHeapStorageContainer {
    private static Logger logger = Logger.getLogger("com.gigaspaces.cache");
    private AbstractMemoryPool memoryPool;

    public PmemBlobStoreHandler(long size, String fileName, boolean verbose) {
        this.memoryPool = new PmemMemoryPool(size, fileName, verbose);
    }

    public void initialize(BlobStoreConfig blobStoreConfig) {
        LicenseManager.getInstance().validate("MemoryXtend Pmem plug-in", LicenseType.ENTERPRISE);
        ((PmemMemoryPool)this.getMemoryPool()).initPool(blobStoreConfig.getSpaceName());
        logger.info("Pmem Storage Handler [ " + ((Object)((Object)this)).getClass().getName() + " ] initialized on space: " + blobStoreConfig.getSpaceName() + ", memory threshold = " + this.getMemoryPool().getThreshold() + "B, file = " + ((PmemMemoryPool)this.getMemoryPool()).getPmemDataFile());
    }

    public AbstractMemoryPool getMemoryPool() {
        return this.memoryPool;
    }

    public Object add(Serializable id, Serializable data, BlobStoreObjectType objectType) {
        this.memoryPool.write((IBlobStoreOffHeapInfo)id, (byte[])data);
        return id;
    }

    public Serializable get(Serializable id, Object position, BlobStoreObjectType objectType) {
        return this.memoryPool.get((IBlobStoreOffHeapInfo)id);
    }

    public Object replace(Serializable id, Serializable data, Object position, BlobStoreObjectType objectType) {
        this.memoryPool.update((IBlobStoreOffHeapInfo)id, (byte[])data);
        return position;
    }

    public Serializable remove(Serializable id, Object position, BlobStoreObjectType objectType) {
        this.memoryPool.delete((IBlobStoreOffHeapInfo)id);
        return null;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("blobstore.pmem.memory", String.valueOf(this.memoryPool.getThreshold()));
        return props;
    }

    public List<BlobStoreBulkOperationResult> executeBulk(List<BlobStoreBulkOperationRequest> operations, BlobStoreObjectType objectType, boolean transactional) {
        byte[] operationCodes = new byte[operations.size()];
        long[] positions = new long[operations.size()];
        Object[] dataForOps = new Object[operations.size()];
        short[] types = new short[operations.size()];
        for (int i = 0; i < operations.size(); ++i) {
            BlobStoreBulkOperationRequest operationRequest = operations.get(i);
            operationCodes[i] = this.convertOpTypeToByte(operationRequest.getOpType());
            positions[i] = operationRequest.getOffHeapInfo().getOffHeapAddress();
            dataForOps[i] = operationRequest.getData();
            types[i] = operationRequest.getOffHeapInfo().getServerTypeDescCode();
        }
        ((PmemMemoryPool)this.getMemoryPool()).executeBulk(operationCodes, positions, types, dataForOps);
        ArrayList<BlobStoreBulkOperationResult> result = new ArrayList<BlobStoreBulkOperationResult>(operations.size());
        for (int i = 0; i < operations.size(); ++i) {
            Serializable id = operations.get(i).getId();
            IBlobStoreOffHeapInfo offHeapInfo = operations.get(i).getOffHeapInfo();
            if (operationCodes[i] == 1) {
                try {
                    offHeapInfo.setOffHeapAddress(positions[i]);
                    result.add((BlobStoreBulkOperationResult)new BlobStoreAddBulkOperationResult(id, (Object)offHeapInfo));
                }
                catch (Exception ex) {
                    result.add((BlobStoreBulkOperationResult)new BlobStoreAddBulkOperationResult(id, (Throwable)ex));
                }
                continue;
            }
            if (operationCodes[i] == 4) {
                try {
                    offHeapInfo.setOffHeapAddress(-1L);
                    result.add((BlobStoreBulkOperationResult)new BlobStoreRemoveBulkOperationResult(id));
                }
                catch (Exception ex) {
                    result.add((BlobStoreBulkOperationResult)new BlobStoreRemoveBulkOperationResult(id, (Throwable)ex));
                }
                continue;
            }
            if (operationCodes[i] == 3) {
                try {
                    offHeapInfo.setOffHeapAddress(positions[i]);
                    result.add((BlobStoreBulkOperationResult)new BlobStoreReplaceBulkOperationResult(id, operations.get(i).getPosition(), offHeapInfo));
                }
                catch (Exception ex) {
                    result.add((BlobStoreBulkOperationResult)new BlobStoreReplaceBulkOperationResult(id, (Throwable)ex));
                }
                continue;
            }
            if (operationCodes[i] != 2) continue;
            try {
                result.add((BlobStoreBulkOperationResult)new BlobStoreGetBulkOperationResult(id, (Serializable)dataForOps[i], operations.get(i).getPosition(), offHeapInfo));
                continue;
            }
            catch (Exception ex) {
                result.add((BlobStoreBulkOperationResult)new BlobStoreGetBulkOperationResult(id, (Throwable)ex));
            }
        }
        return result;
    }

    public void close() {
        ((PmemMemoryPool)this.memoryPool).close();
    }

    private byte convertOpTypeToByte(BlobStoreBulkOperationType opType) {
        if (opType.equals((Object)BlobStoreBulkOperationType.ADD)) {
            return 1;
        }
        if (opType.equals((Object)BlobStoreBulkOperationType.GET)) {
            return 2;
        }
        if (opType.equals((Object)BlobStoreBulkOperationType.REMOVE)) {
            return 4;
        }
        if (opType.equals((Object)BlobStoreBulkOperationType.REPLACE)) {
            return 3;
        }
        throw new UnsupportedOperationException("opType " + opType + " did not match ADD/GET/REPLACE/DELETE");
    }
}

