/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.pmem;

import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.Metric;
import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.pmem.TempPmemDriverJNI;
import com.gigaspaces.pmem.TempPmemException;
import com.j_spaces.core.cache.blobStore.IBlobStoreOffHeapInfo;
import com.j_spaces.core.cache.blobStore.memory_pool.AbstractMemoryPool;
import java.io.File;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PmemMemoryPool
extends AbstractMemoryPool {
    private final boolean verbose;
    private final String pmemPath;
    private String pmemDataFile;
    private Logger logger = Logger.getLogger("com.gigaspaces.cache");
    private final TempPmemDriverJNI pmemDriver;
    private static volatile boolean active = false;
    private static ReentrantLock initCloseLock = new ReentrantLock();

    public PmemMemoryPool(long threshold, String pmemPath, boolean verbose) {
        super(threshold);
        this.pmemPath = pmemPath;
        this.verbose = verbose;
        this.pmemDriver = new TempPmemDriverJNI();
    }

    public void initPool(String spaceName) {
        block8: {
            if (initCloseLock.tryLock()) {
                try {
                    if (!active) {
                        if (this.pmemDataFile == null) {
                            this.pmemDataFile = this.pmemPath + (this.pmemPath.endsWith(File.separator) ? spaceName + ".data" : File.separator + spaceName + ".data");
                        }
                        this.pmemDriver.init(this.pmemDataFile, this.threshold, this.verbose);
                        active = true;
                        break block8;
                    }
                    throw new IllegalStateException("calling com.gigaspaces.blobstore.pmem.PmemMemoryPool.initPool when pool already initialized");
                }
                catch (TempPmemException e) {
                    this.logger.log(Level.SEVERE, "Failed to init pmem pool", e);
                    throw new RuntimeException("Failed to init pmem pool", e);
                }
                finally {
                    initCloseLock.unlock();
                }
            }
            throw new IllegalStateException("calling com.gigaspaces.blobstore.pmem.PmemMemoryPool.initPool when pool already initialized");
        }
    }

    public String getPmemPath() {
        return this.pmemPath;
    }

    public String getPmemDataFile() {
        return this.pmemDataFile;
    }

    public void executeBulk(byte[] operations, long[] offsets, short[] types, Object[] operationsData) {
        try {
            this.pmemDriver.executeBulk(operations, offsets, operationsData, types);
        }
        catch (TempPmemException e) {
            this.logger.log(Level.SEVERE, "Failed to execute bulk operation in pmem pool " + this.pmemDataFile, e);
            throw new RuntimeException("Failed to execute bulk operation in pmem pool " + this.pmemDataFile, e);
        }
    }

    public void initMetrics(MetricRegistrator metricRegistrator) {
        this.setMetricRegistrator(metricRegistrator);
        this.getMetricRegistrator().register(this.metricsPath("total"), (Metric)new Gauge<Long>(){

            public Long getValue() throws Exception {
                return PmemMemoryPool.this.pmemDriver.getByteCounter();
            }
        });
    }

    public void register(String typeName, final short typeCode) {
        this.pmemDriver.registerTypeByteCounter(typeCode);
        this.getMetricRegistrator().register(this.metricsPath(typeName), (Metric)new Gauge<Long>(){

            public Long getValue() throws Exception {
                return PmemMemoryPool.this.pmemDriver.getByteCounter(typeCode);
            }
        });
    }

    public void unregister(String typeName, short typeCode) {
        this.pmemDriver.unregisterTypeByteCounter(typeCode);
        this.getMetricRegistrator().unregisterByPrefix(this.metricsPath(typeName));
    }

    public long getUsedBytes() {
        return this.pmemDriver.getByteCounter();
    }

    public void write(IBlobStoreOffHeapInfo info, byte[] buf) {
        long offset = -1L;
        try {
            offset = this.pmemDriver.add(buf, info.getServerTypeDescCode());
        }
        catch (TempPmemException e) {
            this.logger.log(Level.SEVERE, "Failed to add object to pmem pool " + this.pmemDataFile, e);
            throw new RuntimeException("Failed to add object to pmem pool " + this.pmemDataFile, e);
        }
        finally {
            info.setOffHeapAddress(offset);
        }
    }

    public byte[] get(IBlobStoreOffHeapInfo info) {
        try {
            return this.pmemDriver.get(info.getOffHeapAddress());
        }
        catch (TempPmemException e) {
            this.logger.log(Level.SEVERE, "Failed to retrieve object at offset " + info.getOffHeapAddress() + " to pmem pool " + this.pmemDataFile, e);
            throw new RuntimeException("Failed to retrieve object at offset " + info.getOffHeapAddress() + " to pmem pool " + this.pmemDataFile, e);
        }
    }

    public void update(IBlobStoreOffHeapInfo info, byte[] buf) {
        try {
            info.setOffHeapAddress(this.pmemDriver.replace(buf, info.getOffHeapAddress(), info.getServerTypeDescCode()));
        }
        catch (TempPmemException e) {
            this.logger.log(Level.SEVERE, "Failed to update object at offset " + info.getOffHeapAddress() + " in pmem pool " + this.pmemDataFile, e);
            throw new RuntimeException("Failed to update object at offset " + info.getOffHeapAddress() + " in pmem pool " + this.pmemDataFile, e);
        }
    }

    public void delete(IBlobStoreOffHeapInfo info) {
        try {
            this.pmemDriver.delete(info.getOffHeapAddress(), info.getServerTypeDescCode());
        }
        catch (TempPmemException e) {
            this.logger.log(Level.SEVERE, "Failed to delete object at offset " + info.getOffHeapAddress() + " from pmem pool " + this.pmemDataFile, e);
            throw new RuntimeException("Failed to delete object at offset " + info.getOffHeapAddress() + " from pmem pool " + this.pmemDataFile, e);
        }
    }

    public boolean isPmem() {
        return true;
    }

    public boolean isOffHeap() {
        return false;
    }

    public void close() {
        initCloseLock.lock();
        if (active) {
            this.logger.info("Deleting " + this.pmemDataFile + " pmem pool");
            try {
                this.pmemDriver.close(this.pmemDataFile);
            }
            catch (TempPmemException e) {
                this.logger.log(Level.SEVERE, "Failed to close pmem pool " + this.pmemDataFile, e);
                throw new RuntimeException("Failed to close pmem pool " + this.pmemDataFile, e);
            }
            active = false;
        }
        initCloseLock.unlock();
    }
}

