/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.pmem.config;

import com.gigaspaces.blobstore.pmem.config.PmemBlobStoreDataPolicyFactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class PmemBlobStoreBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    private static final String MEMORY_POOL_SIZE = "memory-pool-size";
    private static final String PMEM_PATH = "pmem-path";
    private static final String VERBOSE = "verbose";

    protected Class<PmemBlobStoreDataPolicyFactoryBean> getBeanClass(Element element) {
        return PmemBlobStoreDataPolicyFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String memoryPoolSize = element.getAttribute(MEMORY_POOL_SIZE);
        if (!StringUtils.hasText((String)memoryPoolSize)) {
            throw new IllegalArgumentException("Please configure memory pool size. it's a required property.");
        }
        builder.addPropertyValue("memoryPoolSize", (Object)memoryPoolSize);
        String fileName = element.getAttribute(PMEM_PATH);
        if (!StringUtils.hasText((String)fileName)) {
            throw new IllegalArgumentException("Please configure pmem path. it's a required property.");
        }
        builder.addPropertyValue("pmemPath", (Object)fileName);
        String verbose = element.getAttribute(VERBOSE);
        if (StringUtils.hasText((String)verbose)) {
            builder.addPropertyValue(VERBOSE, (Object)verbose);
        } else {
            builder.addPropertyValue(VERBOSE, (Object)false);
        }
    }
}

