/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.pmem.config;

import com.gigaspaces.blobstore.pmem.PmemBlobStoreHandler;
import com.gigaspaces.internal.utils.StringUtils;

public class PmemBlobStoreConfigurer {
    private PmemBlobStoreHandler pmemBlobStoreHandler;
    private String memoryPoolSize;
    private String pmemPath;
    private boolean verbose = false;

    public PmemBlobStoreConfigurer setMemoryPoolSize(String memoryThreshold) {
        this.memoryPoolSize = memoryThreshold;
        return this;
    }

    public PmemBlobStoreConfigurer setPmemPath(String pmemPath) {
        this.pmemPath = pmemPath;
        return this;
    }

    public PmemBlobStoreConfigurer setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public PmemBlobStoreHandler create() {
        if (this.pmemBlobStoreHandler != null) {
            return this.pmemBlobStoreHandler;
        }
        System.setProperty("space-config.engine.blobstore_use_bulks", "true");
        if (this.memoryPoolSize == null) {
            throw new IllegalArgumentException("Please configure memoryPoolSize. it's a required property.");
        }
        Long size = StringUtils.parseStringAsBytes((String)this.memoryPoolSize);
        if (size == null) {
            throw new IllegalArgumentException("Please configure memoryPoolSize. it's a required property.");
        }
        if (this.pmemPath == null) {
            throw new IllegalArgumentException("Please configure pmemPath. it's a required property.");
        }
        this.pmemBlobStoreHandler = new PmemBlobStoreHandler(size, this.pmemPath, this.verbose);
        return this.pmemBlobStoreHandler;
    }

    public PmemBlobStoreHandler storageHandler() {
        return this.create();
    }
}

