/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;

public class DoubleColumnVector
extends ColumnVector {
    public double[] vector;
    private final DoubleWritable writableObj = new DoubleWritable();
    public static final double NULL_VALUE = Double.NaN;

    public DoubleColumnVector() {
        this(1024);
    }

    public DoubleColumnVector(int len) {
        super(len);
        this.vector = new double[len];
    }

    @Override
    public Writable getWritableObject(int index) {
        if (this.isRepeating) {
            index = 0;
        }
        if (!this.noNulls && this.isNull[index]) {
            return NullWritable.get();
        }
        this.writableObj.set(this.vector[index]);
        return this.writableObj;
    }

    public void copySelected(boolean selectedInUse, int[] sel, int size, DoubleColumnVector output) {
        int i;
        int j;
        output.noNulls = this.noNulls;
        output.isRepeating = false;
        if (this.isRepeating) {
            output.vector[0] = this.vector[0];
            output.isNull[0] = this.isNull[0];
            output.isRepeating = true;
            return;
        }
        if (selectedInUse) {
            for (j = 0; j < size; ++j) {
                i = sel[j];
                output.vector[i] = this.vector[i];
            }
        } else {
            System.arraycopy(this.vector, 0, output.vector, 0, size);
        }
        if (!this.noNulls) {
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = sel[j];
                    output.isNull[i] = this.isNull[i];
                }
            } else {
                System.arraycopy(this.isNull, 0, output.isNull, 0, size);
            }
        }
    }

    public void fill(double value) {
        this.noNulls = true;
        this.isRepeating = true;
        this.vector[0] = value;
    }

    @Override
    public void flatten(boolean selectedInUse, int[] sel, int size) {
        this.flattenPush();
        if (this.isRepeating) {
            this.isRepeating = false;
            double repeatVal = this.vector[0];
            if (selectedInUse) {
                for (int j = 0; j < size; ++j) {
                    int i = sel[j];
                    this.vector[i] = repeatVal;
                }
            } else {
                Arrays.fill(this.vector, 0, size, repeatVal);
            }
            this.flattenRepeatingNulls(selectedInUse, sel, size);
        }
        this.flattenNoNulls(selectedInUse, sel, size);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        this.vector[outElementNum] = ((DoubleColumnVector)inputVector).vector[inputElementNum];
    }
}

