/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.util.ReflectionUtils;

public class RCFileRecordReader<K extends LongWritable, V extends BytesRefArrayWritable>
implements RecordReader<LongWritable, BytesRefArrayWritable> {
    private final RCFile.Reader in;
    private final long start;
    private final long end;
    private boolean more = true;
    protected Configuration conf;
    private final FileSplit split;
    private final boolean useCache;
    private static RCFileSyncCache syncCache = new RCFileSyncCache();

    public RCFileRecordReader(Configuration conf, FileSplit split) throws IOException {
        Path path = split.getPath();
        FileSystem fs = path.getFileSystem(conf);
        this.in = new RCFile.Reader(fs, path, conf);
        this.end = split.getStart() + split.getLength();
        this.conf = conf;
        this.split = split;
        this.useCache = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVEUSERCFILESYNCCACHE);
        if (split.getStart() > this.in.getPosition()) {
            long oldSync;
            long l = oldSync = this.useCache ? syncCache.get(split) : -1L;
            if (oldSync == -1L) {
                this.in.sync(split.getStart());
            } else {
                this.in.seek(oldSync);
            }
        }
        this.start = this.in.getPosition();
        this.more = this.start < this.end;
    }

    public Class<?> getKeyClass() {
        return LongWritable.class;
    }

    public Class<?> getValueClass() {
        return BytesRefArrayWritable.class;
    }

    public LongWritable createKey() {
        return (LongWritable)ReflectionUtils.newInstance(this.getKeyClass(), (Configuration)this.conf);
    }

    public BytesRefArrayWritable createValue() {
        return (BytesRefArrayWritable)ReflectionUtils.newInstance(this.getValueClass(), (Configuration)this.conf);
    }

    public boolean nextBlock() throws IOException {
        return this.in.nextBlock();
    }

    public boolean next(LongWritable key, BytesRefArrayWritable value) throws IOException {
        this.more = this.next(key);
        if (this.more) {
            this.in.getCurrentRow(value);
        }
        return this.more;
    }

    protected boolean next(LongWritable key) throws IOException {
        if (!this.more) {
            return false;
        }
        this.more = this.in.next(key);
        long lastSeenSyncPos = this.in.lastSeenSyncPos();
        if (lastSeenSyncPos >= this.end) {
            if (this.useCache) {
                syncCache.put(this.split, lastSeenSyncPos);
            }
            this.more = false;
            return this.more;
        }
        return this.more;
    }

    public float getProgress() throws IOException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.in.getPosition() - this.start) / (float)(this.end - this.start));
    }

    public long getPos() throws IOException {
        return this.in.getPosition();
    }

    public RCFile.KeyBuffer getKeyBuffer() {
        return this.in.getCurrentKeyBufferObj();
    }

    protected void seek(long pos) throws IOException {
        this.in.seek(pos);
    }

    public void sync(long pos) throws IOException {
        this.in.sync(pos);
    }

    public void resetBuffer() {
        this.in.resetBuffer();
    }

    public long getStart() {
        return this.start;
    }

    public void close() throws IOException {
        this.in.close();
    }

    private static final class RCFileSyncCache {
        private final Map<String, RCFileSyncEntry> cache = Collections.synchronizedMap(new WeakHashMap());

        public void put(FileSplit split, long endSync) {
            Path path = split.getPath();
            long end = split.getStart() + split.getLength();
            String key = path.toString() + "+" + String.format("%d", end);
            RCFileSyncEntry entry = new RCFileSyncEntry();
            entry.end = end;
            entry.endSync = endSync;
            if (entry.endSync >= entry.end) {
                this.cache.put(key, entry);
            }
        }

        public long get(FileSplit split) {
            Path path = split.getPath();
            long start = split.getStart();
            String key = path.toString() + "+" + String.format("%d", start);
            RCFileSyncEntry entry = this.cache.get(key);
            if (entry != null) {
                return entry.endSync;
            }
            return -1L;
        }
    }

    private static final class RCFileSyncEntry {
        long end;
        long endSync;

        private RCFileSyncEntry() {
        }
    }
}

