/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import org.apache.hadoop.hive.metastore.api.Schema;

public class CommandProcessorResponse {
    private final int responseCode;
    private final String errorMessage;
    private final String SQLState;
    private final Schema resSchema;
    private final Throwable exception;

    public CommandProcessorResponse(int responseCode) {
        this(responseCode, null, null, null, null);
    }

    public CommandProcessorResponse(int responseCode, String errorMessage, String SQLState) {
        this(responseCode, errorMessage, SQLState, null, null);
    }

    public CommandProcessorResponse(int responseCode, String errorMessage, String SQLState, Throwable exception) {
        this(responseCode, errorMessage, SQLState, null, exception);
    }

    public CommandProcessorResponse(int responseCode, String errorMessage, String SQLState, Schema schema) {
        this(responseCode, errorMessage, SQLState, schema, null);
    }

    public static CommandProcessorResponse create(Exception e) {
        return new CommandProcessorResponse(1, e.getMessage(), null);
    }

    public CommandProcessorResponse(int responseCode, String errorMessage, String SQLState, Schema schema, Throwable exception) {
        this.responseCode = responseCode;
        this.errorMessage = errorMessage;
        this.SQLState = SQLState;
        this.resSchema = schema;
        this.exception = exception;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSQLState() {
        return this.SQLState;
    }

    public Schema getSchema() {
        return this.resSchema;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        return "(" + this.responseCode + "," + this.errorMessage + "," + this.SQLState + (this.resSchema == null ? "" : ",") + (this.exception == null ? "" : this.exception.getMessage()) + ")";
    }
}

