/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl.writer;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.writer.StringBaseTreeWriter;
import org.apache.orc.impl.writer.WriterContext;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;

public class CharTreeWriter
extends StringBaseTreeWriter {
    private final int itemLength;
    private final byte[] padding;

    CharTreeWriter(int columnId, TypeDescription schema, WriterContext writer, boolean nullable) throws IOException {
        super(columnId, schema, writer, nullable);
        this.itemLength = schema.getMaxLength();
        this.padding = new byte[this.itemLength];
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        block14: {
            BytesColumnVector vec;
            block13: {
                int ptrOffset;
                byte[] ptr;
                super.writeBatch(vector, offset, length);
                vec = (BytesColumnVector)vector;
                if (!vector.isRepeating) break block13;
                if (!vector.noNulls && vector.isNull[0]) break block14;
                if (vec.length[0] >= this.itemLength) {
                    ptr = vec.vector[0];
                    ptrOffset = vec.start[0];
                } else {
                    ptr = this.padding;
                    ptrOffset = 0;
                    System.arraycopy(vec.vector[0], vec.start[0], ptr, 0, vec.length[0]);
                    Arrays.fill(ptr, vec.length[0], this.itemLength, (byte)32);
                }
                if (this.useDictionaryEncoding) {
                    int id = this.dictionary.add(ptr, ptrOffset, this.itemLength);
                    for (int i = 0; i < length; ++i) {
                        this.rows.add(id);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        this.directStreamOutput.write(ptr, ptrOffset, this.itemLength);
                        this.lengthOutput.write(this.itemLength);
                    }
                }
                this.indexStatistics.updateString(ptr, ptrOffset, this.itemLength, length);
                if (!this.createBloomFilter) break block14;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addString(new String(vec.vector[0], vec.start[0], vec.length[0], StandardCharsets.UTF_8));
                }
                this.bloomFilterUtf8.addBytes(vec.vector[0], vec.start[0], vec.length[0]);
                break block14;
            }
            for (int i = 0; i < length; ++i) {
                int ptrOffset;
                byte[] ptr;
                if (!vec.noNulls && vec.isNull[i + offset]) continue;
                if (vec.length[offset + i] >= this.itemLength) {
                    ptr = vec.vector[offset + i];
                    ptrOffset = vec.start[offset + i];
                } else {
                    ptr = this.padding;
                    ptrOffset = 0;
                    System.arraycopy(vec.vector[offset + i], vec.start[offset + i], ptr, 0, vec.length[offset + i]);
                    Arrays.fill(ptr, vec.length[offset + i], this.itemLength, (byte)32);
                }
                if (this.useDictionaryEncoding) {
                    this.rows.add(this.dictionary.add(ptr, ptrOffset, this.itemLength));
                } else {
                    this.directStreamOutput.write(ptr, ptrOffset, this.itemLength);
                    this.lengthOutput.write(this.itemLength);
                }
                this.indexStatistics.updateString(ptr, ptrOffset, this.itemLength, 1);
                if (!this.createBloomFilter) continue;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addString(new String(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i], StandardCharsets.UTF_8));
                }
                this.bloomFilterUtf8.addBytes(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i]);
            }
        }
    }
}

