/*
 * Decompiled with CFR 0.152.
 */
package org.pegdown;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.parboiled.Parboiled;
import org.pegdown.LinkRenderer;
import org.pegdown.Parser;
import org.pegdown.ParsingTimeoutException;
import org.pegdown.ToHtmlSerializer;
import org.pegdown.VerbatimSerializer;
import org.pegdown.ast.RootNode;
import org.pegdown.plugins.PegDownPlugins;
import org.pegdown.plugins.ToHtmlSerializerPlugin;

public class PegDownProcessor {
    public static final long DEFAULT_MAX_PARSING_TIME = 2000L;
    public final Parser parser;

    public PegDownProcessor() {
        this(2000L);
    }

    public PegDownProcessor(long maxParsingTimeInMillis) {
        this(0, maxParsingTimeInMillis);
    }

    public PegDownProcessor(int options) {
        this(options, 2000L, PegDownPlugins.NONE);
    }

    public PegDownProcessor(int options, long maxParsingTimeInMillis) {
        this(options, maxParsingTimeInMillis, PegDownPlugins.NONE);
    }

    public PegDownProcessor(int options, PegDownPlugins plugins) {
        this(options, 2000L, plugins);
    }

    public PegDownProcessor(int options, long maxParsingTimeInMillis, PegDownPlugins plugins) {
        this((Parser)Parboiled.createParser(Parser.class, (Object[])new Object[]{options, maxParsingTimeInMillis, Parser.DefaultParseRunnerProvider, plugins}));
    }

    public PegDownProcessor(Parser parser) {
        this.parser = parser;
    }

    public String markdownToHtml(String markdownSource) {
        return this.markdownToHtml(markdownSource.toCharArray());
    }

    public String markdownToHtml(String markdownSource, LinkRenderer linkRenderer) {
        return this.markdownToHtml(markdownSource.toCharArray(), linkRenderer);
    }

    public String markdownToHtml(String markdownSource, LinkRenderer linkRenderer, Map<String, VerbatimSerializer> verbatimSerializerMap) {
        return this.markdownToHtml(markdownSource.toCharArray(), linkRenderer, verbatimSerializerMap);
    }

    public String markdownToHtml(char[] markdownSource) {
        return this.markdownToHtml(markdownSource, new LinkRenderer());
    }

    public String markdownToHtml(char[] markdownSource, LinkRenderer linkRenderer) {
        return this.markdownToHtml(markdownSource, linkRenderer, Collections.<String, VerbatimSerializer>emptyMap());
    }

    public String markdownToHtml(char[] markdownSource, LinkRenderer linkRenderer, Map<String, VerbatimSerializer> verbatimSerializerMap) {
        return this.markdownToHtml(markdownSource, linkRenderer, verbatimSerializerMap, this.parser.plugins.getHtmlSerializerPlugins());
    }

    public String markdownToHtml(char[] markdownSource, LinkRenderer linkRenderer, Map<String, VerbatimSerializer> verbatimSerializerMap, List<ToHtmlSerializerPlugin> plugins) {
        try {
            RootNode astRoot = this.parseMarkdown(markdownSource);
            return new ToHtmlSerializer(linkRenderer, verbatimSerializerMap, plugins).toHtml(astRoot);
        }
        catch (ParsingTimeoutException e) {
            return null;
        }
    }

    public RootNode parseMarkdown(char[] markdownSource) {
        return this.parser.parse(this.prepareSource(markdownSource));
    }

    public char[] prepareSource(char[] source) {
        char[] src = new char[source.length + 2];
        System.arraycopy(source, 0, src, 0, source.length);
        src[source.length] = 10;
        src[source.length + 1] = 10;
        return src;
    }
}

