/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.spatial;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.io.ShapeReader;
import org.locationtech.spatial4j.shape.impl.BufferedLineString;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;
import org.openspaces.spatial.ShapeFormat;
import org.openspaces.spatial.shapes.Circle;
import org.openspaces.spatial.shapes.LineString;
import org.openspaces.spatial.shapes.Point;
import org.openspaces.spatial.shapes.Polygon;
import org.openspaces.spatial.shapes.Rectangle;
import org.openspaces.spatial.shapes.Shape;
import org.openspaces.spatial.shapes.impl.CircleImpl;
import org.openspaces.spatial.shapes.impl.LineStringImpl;
import org.openspaces.spatial.shapes.impl.PointImpl;
import org.openspaces.spatial.shapes.impl.PolygonImpl;
import org.openspaces.spatial.shapes.impl.RectangleImpl;

public class ShapeFactory {
    private ShapeFactory() {
    }

    public static Point point(double x, double y) {
        return new PointImpl(x, y);
    }

    public static Circle circle(Point center, double radius) {
        return new CircleImpl(center.getX(), center.getY(), radius);
    }

    public static Rectangle rectangle(double minX, double maxX, double minY, double maxY) {
        return new RectangleImpl(minX, maxX, minY, maxY);
    }

    public static LineString lineString(Point first, Point second, Point ... morePoints) {
        Point[] points = new Point[2 + morePoints.length];
        points[0] = Objects.requireNonNull(first, "first");
        points[1] = Objects.requireNonNull(second, "second");
        for (int i = 0; i < morePoints.length; ++i) {
            points[i + 2] = morePoints[i];
        }
        return ShapeFactory.lineString(points);
    }

    public static LineString lineString(Collection<Point> points) {
        return ShapeFactory.lineString(points.toArray(new Point[points.size()]));
    }

    private static LineString lineString(Point[] points) {
        return new LineStringImpl(points);
    }

    public static Polygon polygon(Point first, Point second, Point third, Point ... morePoints) {
        Point[] points = new Point[3 + morePoints.length];
        points[0] = Objects.requireNonNull(first, "first");
        points[1] = Objects.requireNonNull(second, "second");
        points[2] = Objects.requireNonNull(third, "third");
        for (int i = 0; i < morePoints.length; ++i) {
            points[i + 3] = morePoints[i];
        }
        return ShapeFactory.polygon(points);
    }

    public static Polygon polygon(Collection<Point> points) {
        return ShapeFactory.polygon(points.toArray(new Point[points.size()]));
    }

    private static Polygon polygon(Point[] points) {
        return new PolygonImpl(points);
    }

    public static Shape parse(String s, ShapeFormat shapeFormat) {
        try {
            return ShapeFactory.fromSpatial4JShape(ShapeFactory.getReader(shapeFormat).read((Object)s));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse shape using " + (Object)((Object)shapeFormat), e);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse shape using " + (Object)((Object)shapeFormat), e);
        }
    }

    private static ShapeReader getReader(ShapeFormat shapeFormat) {
        ShapeReader result;
        switch (shapeFormat) {
            case WKT: {
                result = ShapeFactory.getDefaultSpatialContext().getFormats().getWktReader();
                break;
            }
            case GEOJSON: {
                result = ShapeFactory.getDefaultSpatialContext().getFormats().getGeoJsonReader();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Shape Format: " + (Object)((Object)shapeFormat));
            }
        }
        if (result == null) {
            throw new IllegalStateException("No Shape reader for format " + (Object)((Object)shapeFormat));
        }
        return result;
    }

    private static SpatialContext getDefaultSpatialContext() {
        return JtsSpatialContext.GEO;
    }

    private static Shape fromSpatial4JShape(org.locationtech.spatial4j.shape.Shape shape) {
        if (shape instanceof org.locationtech.spatial4j.shape.Point) {
            org.locationtech.spatial4j.shape.Point point = (org.locationtech.spatial4j.shape.Point)shape;
            return ShapeFactory.point(point.getX(), point.getY());
        }
        if (shape instanceof org.locationtech.spatial4j.shape.Circle) {
            org.locationtech.spatial4j.shape.Circle circle = (org.locationtech.spatial4j.shape.Circle)shape;
            return ShapeFactory.circle(ShapeFactory.point(circle.getCenter().getX(), circle.getCenter().getY()), circle.getRadius());
        }
        if (shape instanceof org.locationtech.spatial4j.shape.Rectangle) {
            org.locationtech.spatial4j.shape.Rectangle rectangle = (org.locationtech.spatial4j.shape.Rectangle)shape;
            return ShapeFactory.rectangle(rectangle.getMinX(), rectangle.getMaxX(), rectangle.getMinY(), rectangle.getMaxY());
        }
        if (shape instanceof BufferedLineString) {
            BufferedLineString spatialLineString = (BufferedLineString)shape;
            List spatialPoints = spatialLineString.getPoints();
            Point[] points = new Point[spatialPoints.size()];
            for (int i = 0; i < points.length; ++i) {
                points[i] = ShapeFactory.point(((org.locationtech.spatial4j.shape.Point)spatialPoints.get(i)).getX(), ((org.locationtech.spatial4j.shape.Point)spatialPoints.get(i)).getY());
            }
            return ShapeFactory.lineString(points);
        }
        if (shape instanceof JtsGeometry) {
            return ShapeFactory.fromJtsGeometry((JtsGeometry)shape);
        }
        throw new IllegalArgumentException("Unsupported shape type: " + shape.getClass().getName());
    }

    private static Shape fromJtsGeometry(JtsGeometry shape) {
        Coordinate[] coordinates = shape.getGeom().getCoordinates();
        Point[] points = new Point[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            points[i] = ShapeFactory.point(coordinates[i].getOrdinate(0), coordinates[i].getOrdinate(1));
        }
        String shapeType = shape.getGeom().getGeometryType();
        if (shapeType.equals("LineString")) {
            return ShapeFactory.lineString(points);
        }
        if (shapeType.equals("Polygon")) {
            return ShapeFactory.polygon(points);
        }
        throw new IllegalArgumentException("Unsupported shape type: " + shapeType);
    }
}

