/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.spatial.shapes.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;
import org.openspaces.spatial.ShapeFormat;
import org.openspaces.spatial.shapes.Circle;
import org.openspaces.spatial.spatial4j.Spatial4jShapeProvider;

public class CircleImpl
implements Circle,
Spatial4jShapeProvider,
Externalizable {
    private static final long serialVersionUID = 1L;
    private double centerX;
    private double centerY;
    private double radius;
    private volatile transient Shape spatial4jShape;

    public CircleImpl() {
    }

    public CircleImpl(double centerX, double centerY, double radius) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.radius = radius;
    }

    @Override
    public double getCenterX() {
        return this.centerX;
    }

    @Override
    public double getCenterY() {
        return this.centerY;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    public String toString() {
        return this.toString(ShapeFormat.WKT);
    }

    @Override
    public String toString(ShapeFormat shapeFormat) {
        return this.appendTo(new StringBuilder(), shapeFormat).toString();
    }

    @Override
    public StringBuilder appendTo(StringBuilder stringBuilder, ShapeFormat shapeFormat) {
        switch (shapeFormat) {
            case WKT: {
                return this.appendWkt(stringBuilder);
            }
            case GEOJSON: {
                return this.appendGeoJson(stringBuilder);
            }
        }
        throw new IllegalArgumentException("Unsupported shape type: " + (Object)((Object)shapeFormat));
    }

    private StringBuilder appendGeoJson(StringBuilder stringBuilder) {
        stringBuilder.append("{\"type\":\"Circle\",\"coordinates\":[");
        stringBuilder.append(this.centerX);
        stringBuilder.append(',');
        stringBuilder.append(this.centerY);
        stringBuilder.append("],\"radius\":");
        stringBuilder.append(this.radius);
        stringBuilder.append('}');
        return stringBuilder;
    }

    private StringBuilder appendWkt(StringBuilder stringBuilder) {
        stringBuilder.append("BUFFER (POINT (");
        stringBuilder.append(this.centerX);
        stringBuilder.append(' ');
        stringBuilder.append(this.centerY);
        stringBuilder.append("), ");
        stringBuilder.append(this.radius);
        stringBuilder.append(')');
        return stringBuilder;
    }

    @Override
    public Shape getSpatial4jShape(SpatialContext spatialContext) {
        Shape result = this.spatial4jShape;
        if (result == null) {
            this.spatial4jShape = result = spatialContext.makeCircle(this.centerX, this.centerY, this.radius);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Circle other = (Circle)o;
        if (this.centerX != other.getCenterX()) {
            return false;
        }
        if (this.centerY != other.getCenterY()) {
            return false;
        }
        return this.radius == other.getRadius();
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.centerX);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.centerY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.radius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.centerX);
        out.writeDouble(this.centerY);
        out.writeDouble(this.radius);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.centerX = in.readDouble();
        this.centerY = in.readDouble();
        this.radius = in.readDouble();
    }
}

