/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.spatial.shapes.impl;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.impl.BufferedLineString;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;
import org.openspaces.spatial.ShapeFormat;
import org.openspaces.spatial.shapes.LineString;
import org.openspaces.spatial.shapes.Point;
import org.openspaces.spatial.shapes.impl.PointImpl;
import org.openspaces.spatial.spatial4j.Spatial4jShapeProvider;

public class LineStringImpl
implements LineString,
Spatial4jShapeProvider,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Point[] points;
    private transient int hashcode;
    private volatile transient Shape spatial4jShape;

    public LineStringImpl() {
    }

    public LineStringImpl(Point[] points) {
        if (points.length < 2) {
            throw new IllegalArgumentException("LineString requires at least two points");
        }
        this.points = points;
        this.initialize();
    }

    private void initialize() {
        this.hashcode = Arrays.hashCode(this.points);
    }

    @Override
    public int getNumOfPoints() {
        if (this.points != null) {
            return this.points.length;
        }
        if (this.isJts()) {
            return this.getJtsCoordinates().length;
        }
        return this.getSpatialPoints().size();
    }

    @Override
    public double getX(int index) {
        if (this.points != null) {
            return this.points[index].getX();
        }
        if (this.isJts()) {
            return this.getJtsCoordinates()[index].getOrdinate(0);
        }
        return this.getSpatialPoints().get(index).getX();
    }

    @Override
    public double getY(int index) {
        if (this.points != null) {
            return this.points[index].getY();
        }
        if (this.isJts()) {
            return this.getJtsCoordinates()[index].getOrdinate(1);
        }
        return this.getSpatialPoints().get(index).getY();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineStringImpl other = (LineStringImpl)o;
        int length = this.getNumOfPoints();
        if (length != other.getNumOfPoints()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.getX(i) == other.getX(i) && this.getY(i) == other.getY(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        return this.toString(ShapeFormat.WKT);
    }

    @Override
    public String toString(ShapeFormat shapeFormat) {
        return this.appendTo(new StringBuilder(), shapeFormat).toString();
    }

    @Override
    public StringBuilder appendTo(StringBuilder stringBuilder, ShapeFormat shapeFormat) {
        switch (shapeFormat) {
            case WKT: {
                return this.appendWkt(stringBuilder);
            }
            case GEOJSON: {
                return this.appendGeoJson(stringBuilder);
            }
        }
        throw new IllegalArgumentException("Unsupported shape type: " + (Object)((Object)shapeFormat));
    }

    private StringBuilder appendWkt(StringBuilder stringBuilder) {
        int length = this.getNumOfPoints();
        stringBuilder.append("LINESTRING (");
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.getX(i));
            stringBuilder.append(' ');
            stringBuilder.append(this.getY(i));
        }
        stringBuilder.append(")");
        return stringBuilder;
    }

    private StringBuilder appendGeoJson(StringBuilder stringBuilder) {
        stringBuilder.append("{\"type\":\"LineString\",\"coordinates\":[");
        LineStringImpl.appendTuple(stringBuilder, this.getX(0), this.getY(0));
        int length = this.getNumOfPoints();
        for (int i = 1; i < length; ++i) {
            stringBuilder.append(',');
            LineStringImpl.appendTuple(stringBuilder, this.getX(i), this.getY(i));
        }
        stringBuilder.append("]}");
        return stringBuilder;
    }

    private static void appendTuple(StringBuilder stringBuilder, double x, double y) {
        stringBuilder.append('[');
        stringBuilder.append(x);
        stringBuilder.append(',');
        stringBuilder.append(y);
        stringBuilder.append(']');
    }

    @Override
    public Shape getSpatial4jShape(SpatialContext spatialContext) {
        Shape result = this.spatial4jShape;
        if (result == null) {
            ArrayList<org.locationtech.spatial4j.shape.Point> spatialPoints = new ArrayList<org.locationtech.spatial4j.shape.Point>(this.points.length);
            for (Point p : this.points) {
                spatialPoints.add(spatialContext.makePoint(p.getX(), p.getY()));
            }
            this.spatial4jShape = result = spatialContext.makeLineString(spatialPoints);
            this.points = null;
        }
        return result;
    }

    private boolean isJts() {
        return this.spatial4jShape instanceof JtsGeometry;
    }

    private Coordinate[] getJtsCoordinates() {
        return ((JtsGeometry)this.spatial4jShape).getGeom().getCoordinates();
    }

    private List<org.locationtech.spatial4j.shape.Point> getSpatialPoints() {
        return ((BufferedLineString)this.spatial4jShape).getPoints();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int length = this.getNumOfPoints();
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            out.writeDouble(this.getX(i));
            out.writeDouble(this.getY(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        this.points = new Point[length];
        for (int i = 0; i < length; ++i) {
            double x = in.readDouble();
            double y = in.readDouble();
            this.points[i] = new PointImpl(x, y);
        }
        this.initialize();
    }
}

