/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.spatial.shapes.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;
import org.openspaces.spatial.ShapeFormat;
import org.openspaces.spatial.shapes.Point;
import org.openspaces.spatial.spatial4j.Spatial4jShapeProvider;

public class PointImpl
implements Point,
Spatial4jShapeProvider,
Externalizable {
    private static final long serialVersionUID = 1L;
    private double x;
    private double y;
    private volatile transient Shape spatial4jShape;

    public PointImpl() {
    }

    public PointImpl(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public String toString(ShapeFormat shapeFormat) {
        return this.appendTo(new StringBuilder(), shapeFormat).toString();
    }

    @Override
    public StringBuilder appendTo(StringBuilder stringBuilder, ShapeFormat shapeFormat) {
        switch (shapeFormat) {
            case WKT: {
                return this.appendWkt(stringBuilder);
            }
            case GEOJSON: {
                return this.appendGeoJson(stringBuilder);
            }
        }
        throw new IllegalArgumentException("Unsupported shape type: " + (Object)((Object)shapeFormat));
    }

    private StringBuilder appendWkt(StringBuilder stringBuilder) {
        stringBuilder.append("POINT (");
        stringBuilder.append(this.x);
        stringBuilder.append(' ');
        stringBuilder.append(this.y);
        stringBuilder.append(')');
        return stringBuilder;
    }

    private StringBuilder appendGeoJson(StringBuilder stringBuilder) {
        stringBuilder.append("{\"type\":\"Point\",\"coordinates\":[");
        stringBuilder.append(this.x);
        stringBuilder.append(',');
        stringBuilder.append(this.y);
        stringBuilder.append("]}");
        return stringBuilder;
    }

    @Override
    public Shape getSpatial4jShape(SpatialContext spatialContext) {
        Shape result = this.spatial4jShape;
        if (result == null) {
            this.spatial4jShape = result = spatialContext.makePoint(this.x, this.y);
        }
        return result;
    }

    public String toString() {
        return this.toString(ShapeFormat.WKT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point other = (Point)o;
        if (Double.compare(this.x, other.getX()) != 0) {
            return false;
        }
        return Double.compare(this.y, other.getY()) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readDouble();
        this.y = in.readDouble();
    }
}

