/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.spatial.shapes.impl;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.ParseException;
import java.util.Arrays;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;
import org.openspaces.spatial.ShapeFormat;
import org.openspaces.spatial.shapes.Point;
import org.openspaces.spatial.shapes.Polygon;
import org.openspaces.spatial.shapes.impl.PointImpl;
import org.openspaces.spatial.spatial4j.Spatial4jShapeProvider;

public class PolygonImpl
implements Polygon,
Spatial4jShapeProvider,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Point[] points;
    private transient int hashcode;
    private volatile transient Shape spatial4jShape;

    public PolygonImpl() {
    }

    public PolygonImpl(Point[] points) {
        if (points.length < 3) {
            throw new IllegalArgumentException("Polygon requires at least three points");
        }
        if (points.length == 3 && points[0].equals(points[2])) {
            throw new IllegalArgumentException("Polygon requires at least three distinct points " + Arrays.asList(points));
        }
        this.points = points;
        this.initialize();
    }

    private void initialize() {
        if (!this.points[0].equals(this.points[this.points.length - 1])) {
            Point[] temp = new Point[this.points.length + 1];
            System.arraycopy(this.points, 0, temp, 0, this.points.length);
            temp[this.points.length] = temp[0];
            this.points = temp;
        }
        this.hashcode = Arrays.hashCode(this.points);
    }

    @Override
    public int getNumOfPoints() {
        if (this.points != null) {
            return this.points.length;
        }
        if (PolygonImpl.isRectangle(this.spatial4jShape)) {
            return 5;
        }
        return PolygonImpl.getCoordinates(this.spatial4jShape).length;
    }

    @Override
    public double getX(int index) {
        if (this.points != null) {
            return this.points[index].getX();
        }
        if (PolygonImpl.isRectangle(this.spatial4jShape)) {
            return PolygonImpl.getRectangleCoordinate(this.spatial4jShape, index, 0);
        }
        return PolygonImpl.getCoordinates(this.spatial4jShape)[index].getOrdinate(0);
    }

    @Override
    public double getY(int index) {
        if (this.points != null) {
            return this.points[index].getY();
        }
        if (PolygonImpl.isRectangle(this.spatial4jShape)) {
            return PolygonImpl.getRectangleCoordinate(this.spatial4jShape, index, 1);
        }
        return PolygonImpl.getCoordinates(this.spatial4jShape)[index].getOrdinate(1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolygonImpl other = (PolygonImpl)o;
        int length = this.getNumOfPoints();
        if (length != other.getNumOfPoints()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.getX(i) == other.getX(i) && this.getY(i) == other.getY(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        return this.toString(ShapeFormat.WKT);
    }

    @Override
    public String toString(ShapeFormat shapeFormat) {
        return this.appendTo(new StringBuilder(), shapeFormat).toString();
    }

    @Override
    public StringBuilder appendTo(StringBuilder stringBuilder, ShapeFormat shapeFormat) {
        switch (shapeFormat) {
            case WKT: {
                return this.appendWkt(stringBuilder);
            }
            case GEOJSON: {
                return this.appendGeoJson(stringBuilder);
            }
        }
        throw new IllegalArgumentException("Unsupported shape type: " + (Object)((Object)shapeFormat));
    }

    private StringBuilder appendGeoJson(StringBuilder stringBuilder) {
        stringBuilder.append("{\"type\":\"Polygon\",\"coordinates\":[[");
        PolygonImpl.appendTuple(stringBuilder, this.getX(0), this.getY(0));
        int length = this.getNumOfPoints();
        for (int i = 1; i < length; ++i) {
            stringBuilder.append(',');
            PolygonImpl.appendTuple(stringBuilder, this.getX(i), this.getY(i));
        }
        stringBuilder.append("]]}");
        return stringBuilder;
    }

    private static void appendTuple(StringBuilder stringBuilder, double x, double y) {
        stringBuilder.append('[');
        stringBuilder.append(x);
        stringBuilder.append(',');
        stringBuilder.append(y);
        stringBuilder.append(']');
    }

    private StringBuilder appendWkt(StringBuilder stringBuilder) {
        int length = this.getNumOfPoints();
        stringBuilder.append("POLYGON ((");
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.getX(i));
            stringBuilder.append(' ');
            stringBuilder.append(this.getY(i));
        }
        stringBuilder.append("))");
        return stringBuilder;
    }

    @Override
    public Shape getSpatial4jShape(SpatialContext spatialContext) {
        Shape result = this.spatial4jShape;
        if (result == null) {
            try {
                result = spatialContext.getFormats().getWktReader().read((Object)this.toString(ShapeFormat.WKT));
            }
            catch (ParseException e) {
                throw new IllegalStateException("Failed to convert polygon to Spatial4J", e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to convert polygon to Spatial4J", e);
            }
            this.spatial4jShape = result;
            this.points = null;
        }
        return result;
    }

    private static boolean isRectangle(Shape shape) {
        return shape instanceof Rectangle;
    }

    private static double getRectangleCoordinate(Shape shape, int index, int ordinate) {
        Rectangle rectangle = (Rectangle)shape;
        switch (index) {
            case 0: {
                return ordinate == 0 ? rectangle.getMinX() : rectangle.getMinY();
            }
            case 1: {
                return ordinate == 0 ? rectangle.getMaxX() : rectangle.getMinY();
            }
            case 2: {
                return ordinate == 0 ? rectangle.getMaxX() : rectangle.getMaxY();
            }
            case 3: {
                return ordinate == 0 ? rectangle.getMinX() : rectangle.getMaxY();
            }
            case 4: {
                return ordinate == 0 ? rectangle.getMinX() : rectangle.getMinY();
            }
        }
        throw new IllegalArgumentException("Illegal index " + index + " - a rectangle polygon has 4 points");
    }

    private static Coordinate[] getCoordinates(Shape shape) {
        return ((JtsGeometry)shape).getGeom().getCoordinates();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int length = this.getNumOfPoints();
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            out.writeDouble(this.getX(i));
            out.writeDouble(this.getY(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        this.points = new Point[length];
        for (int i = 0; i < length; ++i) {
            double x = in.readDouble();
            double y = in.readDouble();
            this.points[i] = new PointImpl(x, y);
        }
        this.initialize();
    }
}

