/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.spatial.shapes.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;
import org.openspaces.spatial.ShapeFormat;
import org.openspaces.spatial.shapes.Rectangle;
import org.openspaces.spatial.spatial4j.Spatial4jShapeProvider;

public class RectangleImpl
implements Rectangle,
Spatial4jShapeProvider,
Externalizable {
    private static final long serialVersionUID = 1L;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private volatile transient Shape spatial4jShape;

    public RectangleImpl() {
    }

    public RectangleImpl(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    public String toString() {
        return this.toString(ShapeFormat.WKT);
    }

    @Override
    public String toString(ShapeFormat shapeFormat) {
        return this.appendTo(new StringBuilder(), shapeFormat).toString();
    }

    @Override
    public StringBuilder appendTo(StringBuilder stringBuilder, ShapeFormat shapeFormat) {
        switch (shapeFormat) {
            case WKT: {
                return this.appendWkt(stringBuilder);
            }
            case GEOJSON: {
                return this.appendGeoJson(stringBuilder);
            }
        }
        throw new IllegalArgumentException("Unsupported shape type: " + (Object)((Object)shapeFormat));
    }

    private StringBuilder appendGeoJson(StringBuilder stringBuilder) {
        stringBuilder.append("{\"type\":\"Polygon\",\"coordinates\": [[");
        RectangleImpl.appendTuple(stringBuilder, this.minX, this.minY);
        stringBuilder.append(',');
        RectangleImpl.appendTuple(stringBuilder, this.minX, this.maxY);
        stringBuilder.append(',');
        RectangleImpl.appendTuple(stringBuilder, this.maxX, this.maxY);
        stringBuilder.append(',');
        RectangleImpl.appendTuple(stringBuilder, this.maxX, this.minY);
        stringBuilder.append(',');
        RectangleImpl.appendTuple(stringBuilder, this.minX, this.minY);
        stringBuilder.append("]]}");
        return stringBuilder;
    }

    private static void appendTuple(StringBuilder stringBuilder, double x, double y) {
        stringBuilder.append('[');
        stringBuilder.append(x);
        stringBuilder.append(',');
        stringBuilder.append(y);
        stringBuilder.append(']');
    }

    private StringBuilder appendWkt(StringBuilder stringBuilder) {
        stringBuilder.append("ENVELOPE (");
        stringBuilder.append(this.minX);
        stringBuilder.append(", ");
        stringBuilder.append(this.maxX);
        stringBuilder.append(", ");
        stringBuilder.append(this.maxY);
        stringBuilder.append(", ");
        stringBuilder.append(this.minY);
        stringBuilder.append(')');
        return stringBuilder;
    }

    @Override
    public Shape getSpatial4jShape(SpatialContext spatialContext) {
        Shape result = this.spatial4jShape;
        if (result == null) {
            this.spatial4jShape = result = spatialContext.makeRectangle(this.minX, this.maxX, this.minY, this.maxY);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle other = (Rectangle)o;
        if (this.minX != other.getMinX()) {
            return false;
        }
        if (this.maxX != other.getMaxX()) {
            return false;
        }
        if (this.minY != other.getMinY()) {
            return false;
        }
        return this.maxY == other.getMaxY();
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.minX);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.minX);
        out.writeDouble(this.maxX);
        out.writeDouble(this.minY);
        out.writeDouble(this.maxY);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.minX = in.readDouble();
        this.maxX = in.readDouble();
        this.minY = in.readDouble();
        this.maxY = in.readDouble();
    }
}

