/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.spatial.spi;

import com.gigaspaces.query.extension.QueryExtensionRuntimeInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.bbox.BBoxStrategy;
import org.apache.lucene.spatial.composite.CompositeSpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.serialized.SerializedDVStrategy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.shape.impl.RectangleImpl;
import org.openspaces.spatial.spi.LuceneSpatialQueryExtensionProvider;

public class LuceneSpatialConfiguration {
    public static final String FILE_SEPARATOR = File.separator;
    public static final String STRATEGY = "lucene.strategy";
    public static final String STRATEGY_DEFAULT = SupportedSpatialStrategy.RecursivePrefixTree.name();
    public static final String SPATIAL_PREFIX_TREE = "lucene.strategy.spatial-prefix-tree";
    public static final String SPATIAL_PREFIX_TREE_DEFAULT = SupportedSpatialPrefixTree.GeohashPrefixTree.name();
    public static final String SPATIAL_PREFIX_TREE_MAX_LEVELS = "lucene.strategy.spatial-prefix-tree.max-levels";
    public static final String SPATIAL_PREFIX_TREE_MAX_LEVELS_DEFAULT = "11";
    public static final String DIST_ERR_PCT = "lucene.strategy.distance-error-pct";
    public static final String DIST_ERR_PCT_DEFAULT = "0.025";
    public static final String STORAGE_DIRECTORYTYPE = "lucene.storage.directory-type";
    public static final String STORAGE_DIRECTORYTYPE_DEFAULT = SupportedDirectory.MMapDirectory.name();
    public static final String STORAGE_LOCATION = "lucene.storage.location";
    public static final String SPATIAL_CONTEXT = "context";
    public static final String SPATIAL_CONTEXT_DEFAULT = SupportedSpatialContext.JTS.name();
    public static final String SPATIAL_CONTEXT_GEO = "context.geo";
    public static final String SPATIAL_CONTEXT_GEO_DEFAULT = "true";
    public static final String SPATIAL_CONTEXT_WORLD_BOUNDS = "context.world-bounds";
    private final SpatialContext _spatialContext;
    private final StrategyFactory _strategyFactory;
    private final DirectoryFactory _directoryFactory;
    private final int _maxUncommittedChanges;
    private final String _location;

    public LuceneSpatialConfiguration(LuceneSpatialQueryExtensionProvider provider, QueryExtensionRuntimeInfo info) {
        this._spatialContext = LuceneSpatialConfiguration.createSpatialContext(provider);
        this._strategyFactory = this.createStrategyFactory(provider);
        this._directoryFactory = this.createDirectoryFactory(provider);
        this._location = LuceneSpatialConfiguration.initLocation(provider, info);
        this._maxUncommittedChanges = 1000;
    }

    private static RectangleImpl createSpatialContextWorldBounds(LuceneSpatialQueryExtensionProvider provider) {
        String spatialContextWorldBounds = provider.getCustomProperty(SPATIAL_CONTEXT_WORLD_BOUNDS, null);
        if (spatialContextWorldBounds == null) {
            return null;
        }
        String[] tokens = spatialContextWorldBounds.split(",");
        if (tokens.length != 4) {
            throw new IllegalArgumentException("World bounds [" + spatialContextWorldBounds + "] must be of format: minX, maxX, minY, maxY");
        }
        double[] worldBounds = new double[tokens.length];
        for (int i = 0; i < worldBounds.length; ++i) {
            try {
                worldBounds[i] = Double.parseDouble(tokens[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid world bounds [" + spatialContextWorldBounds + "] - token #" + (i + 1) + " is not a number");
            }
        }
        double minX = worldBounds[0];
        double maxX = worldBounds[1];
        double minY = worldBounds[2];
        double maxY = worldBounds[3];
        if (!(minX <= maxX) || !(minY <= maxY)) {
            throw new IllegalStateException("Values of world bounds [minX, maxX, minY, maxY]=[" + spatialContextWorldBounds + "] must meet: minX<=maxX, minY<=maxY");
        }
        return new RectangleImpl(minX, maxX, minY, maxY, null);
    }

    private static SpatialContext createSpatialContext(LuceneSpatialQueryExtensionProvider provider) {
        String spatialContextString = provider.getCustomProperty(SPATIAL_CONTEXT, SPATIAL_CONTEXT_DEFAULT);
        SupportedSpatialContext spatialContext = SupportedSpatialContext.byName(spatialContextString);
        boolean geo = Boolean.valueOf(provider.getCustomProperty(SPATIAL_CONTEXT_GEO, SPATIAL_CONTEXT_GEO_DEFAULT));
        RectangleImpl worldBounds = LuceneSpatialConfiguration.createSpatialContextWorldBounds(provider);
        switch (spatialContext) {
            case JTS: {
                JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
                factory.geo = geo;
                if (worldBounds != null) {
                    factory.worldBounds = worldBounds;
                }
                return new JtsSpatialContext(factory);
            }
            case Spatial4J: {
                SpatialContextFactory factory = new SpatialContextFactory();
                factory.geo = geo;
                if (worldBounds != null) {
                    factory.worldBounds = worldBounds;
                }
                return new SpatialContext(factory);
            }
        }
        throw new IllegalStateException("Unsupported spatial context type " + (Object)((Object)spatialContext));
    }

    protected StrategyFactory createStrategyFactory(LuceneSpatialQueryExtensionProvider provider) {
        String strategyString = provider.getCustomProperty(STRATEGY, STRATEGY_DEFAULT);
        SupportedSpatialStrategy spatialStrategy = SupportedSpatialStrategy.byName(strategyString);
        switch (spatialStrategy) {
            case RecursivePrefixTree: {
                final SpatialPrefixTree geohashPrefixTree = LuceneSpatialConfiguration.createSpatialPrefixTree(provider, this._spatialContext);
                String distErrPctValue = provider.getCustomProperty(DIST_ERR_PCT, DIST_ERR_PCT_DEFAULT);
                final double distErrPct = Double.valueOf(distErrPctValue);
                return new StrategyFactory(spatialStrategy){

                    @Override
                    public SpatialStrategy createStrategy(String fieldName) {
                        RecursivePrefixTreeStrategy strategy = new RecursivePrefixTreeStrategy(geohashPrefixTree, fieldName);
                        strategy.setDistErrPct(distErrPct);
                        return strategy;
                    }
                };
            }
            case BBox: {
                return new StrategyFactory(spatialStrategy){

                    @Override
                    public SpatialStrategy createStrategy(String fieldName) {
                        return BBoxStrategy.newInstance((SpatialContext)LuceneSpatialConfiguration.this._spatialContext, (String)fieldName);
                    }
                };
            }
            case Composite: {
                final SpatialPrefixTree geohashPrefixTree = LuceneSpatialConfiguration.createSpatialPrefixTree(provider, this._spatialContext);
                String distErrPctValue = provider.getCustomProperty(DIST_ERR_PCT, DIST_ERR_PCT_DEFAULT);
                final double distErrPct = Double.valueOf(distErrPctValue);
                return new StrategyFactory(spatialStrategy){

                    @Override
                    public SpatialStrategy createStrategy(String fieldName) {
                        RecursivePrefixTreeStrategy recursivePrefixTreeStrategy = new RecursivePrefixTreeStrategy(geohashPrefixTree, fieldName);
                        recursivePrefixTreeStrategy.setDistErrPct(distErrPct);
                        SerializedDVStrategy serializedDVStrategy = new SerializedDVStrategy(LuceneSpatialConfiguration.this._spatialContext, fieldName);
                        return new CompositeSpatialStrategy(fieldName, recursivePrefixTreeStrategy, serializedDVStrategy);
                    }
                };
            }
        }
        throw new IllegalStateException("Unsupported strategy: " + (Object)((Object)spatialStrategy));
    }

    private static SpatialPrefixTree createSpatialPrefixTree(LuceneSpatialQueryExtensionProvider provider, SpatialContext spatialContext) {
        String spatialPrefixTreeType = provider.getCustomProperty(SPATIAL_PREFIX_TREE, SPATIAL_PREFIX_TREE_DEFAULT);
        SupportedSpatialPrefixTree spatialPrefixTree = SupportedSpatialPrefixTree.byName(spatialPrefixTreeType);
        String maxLevelsStr = provider.getCustomProperty(SPATIAL_PREFIX_TREE_MAX_LEVELS, SPATIAL_PREFIX_TREE_MAX_LEVELS_DEFAULT);
        int maxLevels = Integer.valueOf(maxLevelsStr);
        switch (spatialPrefixTree) {
            case GeohashPrefixTree: {
                return new GeohashPrefixTree(spatialContext, maxLevels);
            }
            case QuadPrefixTree: {
                return new QuadPrefixTree(spatialContext, maxLevels);
            }
        }
        throw new RuntimeException("Unhandled spatial prefix tree type: " + (Object)((Object)spatialPrefixTree));
    }

    private static String initLocation(LuceneSpatialQueryExtensionProvider provider, QueryExtensionRuntimeInfo info) {
        String location = provider.getCustomProperty(STORAGE_LOCATION, null);
        if (location == null) {
            location = info.getSpaceInstanceWorkDirectory();
            if (location == null) {
                location = System.getProperty("user.dir") + FILE_SEPARATOR + "xap";
            }
            location = location + FILE_SEPARATOR + "spatial";
        }
        String spaceInstanceName = info.getSpaceInstanceName().replace(".", "-");
        return location + FILE_SEPARATOR + spaceInstanceName;
    }

    protected DirectoryFactory createDirectoryFactory(LuceneSpatialQueryExtensionProvider provider) {
        String directoryType = provider.getCustomProperty(STORAGE_DIRECTORYTYPE, STORAGE_DIRECTORYTYPE_DEFAULT);
        SupportedDirectory directory = SupportedDirectory.byName(directoryType);
        switch (directory) {
            case MMapDirectory: {
                return new DirectoryFactory(){

                    @Override
                    public Directory getDirectory(String relativePath) throws IOException {
                        return new MMapDirectory(Paths.get(LuceneSpatialConfiguration.this._location + FILE_SEPARATOR + relativePath, new String[0]));
                    }
                };
            }
            case RAMDirectory: {
                return new DirectoryFactory(){

                    @Override
                    public Directory getDirectory(String path) throws IOException {
                        return new RAMDirectory();
                    }
                };
            }
        }
        throw new RuntimeException("Unhandled directory type " + (Object)((Object)directory));
    }

    public SpatialStrategy getStrategy(String fieldName) {
        return this._strategyFactory.createStrategy(fieldName);
    }

    public Directory getDirectory(String relativePath) throws IOException {
        return this._directoryFactory.getDirectory(relativePath);
    }

    public SpatialContext getSpatialContext() {
        return this._spatialContext;
    }

    public int getMaxUncommittedChanges() {
        return this._maxUncommittedChanges;
    }

    public String getLocation() {
        return this._location;
    }

    public abstract class DirectoryFactory {
        public abstract Directory getDirectory(String var1) throws IOException;
    }

    public abstract class StrategyFactory {
        private SupportedSpatialStrategy _strategyName;

        public StrategyFactory(SupportedSpatialStrategy strategyName) {
            this._strategyName = strategyName;
        }

        public abstract SpatialStrategy createStrategy(String var1);

        public SupportedSpatialStrategy getStrategyName() {
            return this._strategyName;
        }
    }

    private static enum SupportedDirectory {
        MMapDirectory,
        RAMDirectory;


        public static SupportedDirectory byName(String key) {
            for (SupportedDirectory directory : SupportedDirectory.values()) {
                if (!directory.name().equalsIgnoreCase(key)) continue;
                return directory;
            }
            throw new IllegalArgumentException("Unsupported directory: " + key + " - supported values: " + Arrays.asList(SupportedDirectory.values()));
        }
    }

    private static enum SupportedSpatialContext {
        Spatial4J,
        JTS;


        public static SupportedSpatialContext byName(String key) {
            for (SupportedSpatialContext spatialContext : SupportedSpatialContext.values()) {
                if (!spatialContext.name().equalsIgnoreCase(key)) continue;
                return spatialContext;
            }
            throw new IllegalArgumentException("Unsupported spatial context: " + key + " - supported values: " + Arrays.asList(SupportedSpatialContext.values()));
        }
    }

    private static enum SupportedSpatialPrefixTree {
        GeohashPrefixTree,
        QuadPrefixTree;


        public static SupportedSpatialPrefixTree byName(String key) {
            for (SupportedSpatialPrefixTree spatialPrefixTree : SupportedSpatialPrefixTree.values()) {
                if (!spatialPrefixTree.name().equalsIgnoreCase(key)) continue;
                return spatialPrefixTree;
            }
            throw new IllegalArgumentException("Unsupported spatial prefix tree: " + key + " - supported values: " + Arrays.asList(SupportedSpatialPrefixTree.values()));
        }
    }

    private static enum SupportedSpatialStrategy {
        RecursivePrefixTree,
        BBox,
        Composite;


        public static SupportedSpatialStrategy byName(String key) {
            for (SupportedSpatialStrategy spatialStrategy : SupportedSpatialStrategy.values()) {
                if (!spatialStrategy.name().equalsIgnoreCase(key)) continue;
                return spatialStrategy;
            }
            throw new IllegalArgumentException("Unsupported Spatial strategy: " + key + " - supported values: " + Arrays.asList(SupportedSpatialStrategy.values()));
        }
    }
}

