/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.spatial.spi;

import com.gigaspaces.SpaceRuntimeException;
import com.gigaspaces.internal.io.FileUtils;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.query.extension.QueryExtensionEntryIterator;
import com.gigaspaces.query.extension.QueryExtensionManager;
import com.gigaspaces.query.extension.QueryExtensionRuntimeInfo;
import com.gigaspaces.server.SpaceServerEntry;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.store.Directory;
import org.locationtech.spatial4j.shape.Shape;
import org.openspaces.spatial.spatial4j.Spatial4jShapeProvider;
import org.openspaces.spatial.spi.LuceneSpatialConfiguration;
import org.openspaces.spatial.spi.LuceneSpatialQueryExtensionEntryIterator;
import org.openspaces.spatial.spi.LuceneSpatialQueryExtensionProvider;
import org.openspaces.spatial.spi.LuceneSpatialTypeIndex;

public class LuceneSpatialQueryExtensionManager
extends QueryExtensionManager {
    private static final Logger _logger = Logger.getLogger(LuceneSpatialQueryExtensionManager.class.getName());
    protected static final String XAP_ID = "XAP_ID";
    private static final FieldType XAP_ID_TYPE = LuceneSpatialQueryExtensionManager.toFieldType(Field.Store.YES, IndexOptions.NONE, true);
    private static final String XAP_ID_VERSION = "XAP_ID_VERSION";
    private static final FieldType XAP_ID_VERSION_TYPE = LuceneSpatialQueryExtensionManager.toFieldType(Field.Store.YES, IndexOptions.DOCS_AND_FREQS_AND_POSITIONS, false);
    private static final int MAX_RESULTS = Integer.MAX_VALUE;
    private static final Map<String, SpatialOperation> _spatialOperations = LuceneSpatialQueryExtensionManager.initSpatialOperations();
    private final Map<String, LuceneSpatialTypeIndex> _luceneHolderMap = new ConcurrentHashMap<String, LuceneSpatialTypeIndex>();
    private final String _namespace;
    private final LuceneSpatialConfiguration _luceneConfiguration;

    public LuceneSpatialQueryExtensionManager(LuceneSpatialQueryExtensionProvider provider, QueryExtensionRuntimeInfo info) {
        super(info);
        this._namespace = provider.getNamespace();
        this._luceneConfiguration = new LuceneSpatialConfiguration(provider, info);
        File location = new File(this._luceneConfiguration.getLocation());
        FileUtils.deleteFileOrDirectoryIfExists((File)location);
    }

    public void close() throws IOException {
        for (LuceneSpatialTypeIndex luceneHolder : this._luceneHolderMap.values()) {
            luceneHolder.close();
        }
        this._luceneHolderMap.clear();
        FileUtils.deleteFileOrDirectoryIfExists((File)new File(this._luceneConfiguration.getLocation()));
        super.close();
    }

    public void registerType(SpaceTypeDescriptor typeDescriptor) {
        super.registerType(typeDescriptor);
        String typeName = typeDescriptor.getTypeName();
        if (!this._luceneHolderMap.containsKey(typeName)) {
            try {
                this._luceneHolderMap.put(typeName, new LuceneSpatialTypeIndex(this._luceneConfiguration, this._namespace, typeDescriptor));
            }
            catch (IOException e) {
                throw new SpaceRuntimeException("Failed to register type " + typeName, (Throwable)e);
            }
        } else {
            _logger.log(Level.WARNING, "Type [" + typeName + "] is already registered");
        }
    }

    public boolean insertEntry(SpaceServerEntry entry, boolean hasPrevious) {
        String typeName = entry.getSpaceTypeDescriptor().getTypeName();
        LuceneSpatialTypeIndex luceneHolder = this._luceneHolderMap.get(typeName);
        try {
            Document doc = this.createDocumentIfNeeded(luceneHolder, entry);
            if (doc != null) {
                luceneHolder.getIndexWriter().addDocument((Iterable)doc);
            }
            if (hasPrevious) {
                luceneHolder.getIndexWriter().deleteDocuments(new Query[]{new TermQuery(new Term(XAP_ID_VERSION, this.concat(entry.getUid(), entry.getVersion() - 1)))});
            }
            if (doc != null || hasPrevious) {
                luceneHolder.commit(false);
            }
            return doc != null;
        }
        catch (Exception e) {
            String operation = hasPrevious ? "update" : "insert";
            throw new SpaceRuntimeException("Failed to " + operation + " entry of type " + typeName + " with id [" + entry.getUid() + "]", (Throwable)e);
        }
    }

    public void removeEntry(SpaceTypeDescriptor typeDescriptor, String uid, int version) {
        String typeName = typeDescriptor.getTypeName();
        LuceneSpatialTypeIndex luceneHolder = this._luceneHolderMap.get(typeName);
        try {
            luceneHolder.getIndexWriter().deleteDocuments(new Query[]{new TermQuery(new Term(XAP_ID_VERSION, this.concat(uid, version)))});
            luceneHolder.commit(false);
        }
        catch (IOException e) {
            throw new SpaceRuntimeException("Failed to remove entry of type " + typeName, (Throwable)e);
        }
    }

    public QueryExtensionEntryIterator queryByIndex(String typeName, String path, String operationName, Object operand) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "query [typeName=" + typeName + ", path=" + path + ", operation=" + operationName + ", operand=" + operand + "]");
        }
        SpatialStrategy spatialStrategy = this._luceneConfiguration.getStrategy(path);
        Query query = spatialStrategy.makeQuery(new SpatialArgs(this.toOperation(operationName), this.toShape(operand)));
        LuceneSpatialTypeIndex luceneHolder = this._luceneHolderMap.get(typeName);
        try {
            luceneHolder.commit(true);
            DirectoryReader dr = DirectoryReader.open((Directory)luceneHolder.getDirectory());
            IndexSearcher is = new IndexSearcher((IndexReader)dr);
            ScoreDoc[] scores = is.search((Query)query, (int)Integer.MAX_VALUE).scoreDocs;
            return new LuceneSpatialQueryExtensionEntryIterator(scores, is, dr);
        }
        catch (IOException e) {
            throw new SpaceRuntimeException("Failed to scan index", (Throwable)e);
        }
    }

    public boolean accept(String typeName, String path, String operation, Object leftOperand, Object rightOperand) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "filter [operation=" + operation + ", leftOperand=" + leftOperand + ", rightOperand=" + rightOperand + "]");
        }
        return this.toOperation(operation).evaluate(this.toShape(leftOperand), this.toShape(rightOperand));
    }

    protected Document createDocumentIfNeeded(LuceneSpatialTypeIndex luceneHolder, SpaceServerEntry entry) {
        Document doc = null;
        for (String path : luceneHolder.getQueryExtensionInfo().getPaths()) {
            Object fieldValue = entry.getPathValue(path);
            if (!(fieldValue instanceof org.openspaces.spatial.shapes.Shape)) continue;
            SpatialStrategy strategy = this._luceneConfiguration.getStrategy(path);
            Field[] fields = strategy.createIndexableFields(this.toShape(fieldValue));
            if (doc == null) {
                doc = new Document();
            }
            for (Field field : fields) {
                doc.add((IndexableField)field);
            }
        }
        if (doc != null) {
            doc.add((IndexableField)new Field(XAP_ID, entry.getUid(), (IndexableFieldType)XAP_ID_TYPE));
            doc.add((IndexableField)new Field(XAP_ID_VERSION, this.concat(entry.getUid(), entry.getVersion()), (IndexableFieldType)XAP_ID_VERSION_TYPE));
        }
        return doc;
    }

    public Shape toShape(Object obj) {
        if (obj instanceof Spatial4jShapeProvider) {
            return ((Spatial4jShapeProvider)obj).getSpatial4jShape(this._luceneConfiguration.getSpatialContext());
        }
        throw new IllegalArgumentException("Unsupported shape [" + obj.getClass().getName() + "]");
    }

    protected SpatialOperation toOperation(String operationName) {
        SpatialOperation result = _spatialOperations.get(operationName.toUpperCase());
        if (result == null) {
            throw new IllegalArgumentException("Operation " + operationName + " not found - supported operations: " + _spatialOperations.keySet());
        }
        return result;
    }

    protected String concat(String uid, int version) {
        return uid + "_" + version;
    }

    private static Map<String, SpatialOperation> initSpatialOperations() {
        HashMap<String, SpatialOperation> result = new HashMap<String, SpatialOperation>();
        result.put("WITHIN", SpatialOperation.IsWithin);
        result.put("CONTAINS", SpatialOperation.Contains);
        result.put("INTERSECTS", SpatialOperation.Intersects);
        return result;
    }

    private static FieldType toFieldType(Field.Store store, IndexOptions index, boolean analyzed) {
        FieldType ft = new FieldType();
        ft.setStored(store == Field.Store.YES);
        ft.setIndexOptions(index);
        ft.setTokenized(analyzed);
        ft.freeze();
        return ft;
    }
}

