/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.spatial.spi;

import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.query.extension.metadata.TypeQueryExtension;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.openspaces.spatial.spi.LuceneSpatialConfiguration;

public class LuceneSpatialTypeIndex
implements Closeable {
    private final Directory directory;
    private final IndexWriter indexWriter;
    private final TypeQueryExtension queryExtensionInfo;
    private final int maxUncommittedChanges;
    private final AtomicInteger uncommittedChanges = new AtomicInteger(0);

    public LuceneSpatialTypeIndex(LuceneSpatialConfiguration luceneConfig, String namespace, SpaceTypeDescriptor typeDescriptor) throws IOException {
        this.directory = luceneConfig.getDirectory(typeDescriptor.getTypeName() + File.separator + "entries");
        this.indexWriter = new IndexWriter(this.directory, new IndexWriterConfig((Analyzer)new StandardAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        this.queryExtensionInfo = typeDescriptor.getQueryExtensions().getByNamespace(namespace);
        this.maxUncommittedChanges = luceneConfig.getMaxUncommittedChanges();
    }

    @Override
    public void close() throws IOException {
        this.indexWriter.close();
    }

    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public TypeQueryExtension getQueryExtensionInfo() {
        return this.queryExtensionInfo;
    }

    public void commit(boolean force) throws IOException {
        if (force || this.uncommittedChanges.incrementAndGet() == this.maxUncommittedChanges) {
            this.uncommittedChanges.set(0);
            this.indexWriter.commit();
        }
    }
}

