/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee.lb.apache;

import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.service.ServiceConfigLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lookup.BackwardsServiceDiscoveryManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.jini.rio.boot.BootUtil;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.pu.container.jee.JeeServiceDetails;
import org.openspaces.pu.container.jee.lb.apache.LoadBalancerInfo;
import org.openspaces.pu.container.jee.lb.apache.LoadBalancerNodeInfo;
import org.openspaces.pu.container.servicegrid.PUServiceBean;
import org.openspaces.pu.container.support.CommandLineParser;
import org.springframework.util.FileCopyUtils;

public class ApacheLoadBalancerAgent
implements DiscoveryListener,
ServiceDiscoveryListener,
Runnable {
    private String[] groups;
    private String locators;
    private String apachectlLocation;
    private String configLocation;
    private String restartCommand;
    private LookupDiscoveryManager ldm;
    private BackwardsServiceDiscoveryManager sdm;
    private LookupCache cache;
    private final Map<String, LoadBalancerInfo> loadBalancersInfoMap = new ConcurrentHashMap<String, LoadBalancerInfo>();
    private final Map<ServiceID, ClusterInfo> clusterInfoMap = new ConcurrentHashMap<ServiceID, ClusterInfo>();
    private final Map<ServiceID, JeeServiceDetails> jeeServiceDetailsMap = new ConcurrentHashMap<ServiceID, JeeServiceDetails>();
    private volatile boolean running = false;
    private Thread configThread;
    private int updateInterval = 10000;

    public String[] getGroups() {
        if (this.groups == null) {
            String groupsProperty = SystemInfo.singleton().lookup().groups();
            if (groupsProperty != null) {
                StringTokenizer tokenizer = new StringTokenizer(groupsProperty);
                int count = tokenizer.countTokens();
                this.groups = new String[count];
                for (int i = 0; i < count; ++i) {
                    this.groups[i] = tokenizer.nextToken();
                }
            } else {
                this.groups = new String[]{SystemInfo.singleton().lookup().defaultGroups()};
            }
        }
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public String getLocators() {
        String locatorsProperty;
        if (this.locators == null && (locatorsProperty = SystemInfo.singleton().lookup().locators()) != null) {
            this.locators = locatorsProperty;
        }
        return this.locators;
    }

    public void setLocators(String locators) {
        this.locators = locators;
    }

    public String getApachectlLocation() {
        return this.apachectlLocation;
    }

    public void setApachectlLocation(String apachectlLocation) {
        this.apachectlLocation = apachectlLocation;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    public String getRestartCommand() {
        return this.restartCommand;
    }

    public void setRestartCommand(String restartCommand) {
        this.restartCommand = restartCommand;
    }

    public void start() throws Exception {
        System.out.println("Starting Apache Load Balancer Agent...");
        System.out.println("");
        System.out.println("groups " + Arrays.toString(this.getGroups()) + ", locators [" + this.locators + "]");
        if (this.restartCommand == null && this.apachectlLocation == null) {
            throw new IllegalStateException("Must provide either apachectl location or direct restart command");
        }
        if (this.apachectlLocation != null && !new File(this.apachectlLocation).exists()) {
            throw new IllegalArgumentException("apacheclt Location [" + this.apachectlLocation + "] does not exists");
        }
        if (this.configLocation == null) {
            throw new IllegalArgumentException("config directory location must be provided");
        }
        new File(this.configLocation).mkdirs();
        if (this.restartCommand == null) {
            this.restartCommand = ApacheLoadBalancerAgent.isWindows() ? "\"" + this.apachectlLocation + "\" -k restart" : this.apachectlLocation + " graceful";
        }
        System.out.println("apachectl Location [" + this.apachectlLocation + "]");
        System.out.println("config directory [" + this.configLocation + "]");
        System.out.println("update config interval [" + this.updateInterval + "ms]");
        System.out.println("");
        this.loadBalancersInfoMap.clear();
        System.out.println("Detecting existing config files...");
        new File(this.configLocation).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.endsWith(".conf")) {
                    String clusterName = name.substring(0, name.length() - ".conf".length());
                    System.out.println("[" + clusterName + "]: existing config detected");
                    ApacheLoadBalancerAgent.this.loadBalancersInfoMap.put(clusterName, new LoadBalancerInfo(clusterName));
                }
                return false;
            }
        });
        System.out.println("Done detecting existing config files");
        System.out.println("");
        this.ldm = new LookupDiscoveryManager(this.getGroups(), BootUtil.toLookupLocators((String)this.getLocators()), (DiscoveryListener)this, ServiceConfigLoader.getConfiguration());
        this.sdm = new BackwardsServiceDiscoveryManager((DiscoveryManagement)this.ldm, null, ServiceConfigLoader.getConfiguration());
        ServiceTemplate template = new ServiceTemplate(null, new Class[]{PUServiceBean.class}, null);
        this.cache = this.sdm.createLookupCache(template, null, (ServiceDiscoveryListener)this);
        this.running = true;
        this.configThread = new Thread((Runnable)this, "Config Writer Thread");
        this.configThread.setDaemon(false);
        this.configThread.start();
        System.out.println("");
        System.out.println("Started Apache Load Balancer Agent successfully");
        System.out.println("Make sure Apache is configured with [Include " + new File(this.configLocation).getAbsolutePath() + "/*.conf]");
        System.out.println("");
    }

    public void stop() {
        this.running = false;
        System.out.println("Stopping Apached Load Balancer Agent...");
        this.cache.terminate();
        this.sdm.terminate();
        this.ldm.terminate();
        System.out.println("Stopped Apached Load Balancer Agent");
    }

    public void discovered(DiscoveryEvent event) {
        System.out.println("LUS Discovered " + Arrays.toString(event.getRegistrars()));
    }

    public void discarded(DiscoveryEvent event) {
        System.out.println("LUS Discarded " + Arrays.toString(event.getRegistrars()));
    }

    public synchronized void serviceAdded(ServiceDiscoveryEvent event) {
        PUServiceBean service = (PUServiceBean)event.getPostEventServiceItem().service;
        try {
            Object[] details = service.listServiceDetails();
            ClusterInfo clusterInfo = service.getClusterInfo();
            for (Object detail : details) {
                if (!(detail instanceof JeeServiceDetails)) continue;
                JeeServiceDetails jeeDetails = (JeeServiceDetails)detail;
                LoadBalancerInfo loadBalancersInfo = this.loadBalancersInfoMap.get(clusterInfo.getName());
                if (loadBalancersInfo == null) {
                    loadBalancersInfo = new LoadBalancerInfo(clusterInfo.getName());
                    this.loadBalancersInfoMap.put(clusterInfo.getName(), loadBalancersInfo);
                }
                this.clusterInfoMap.put(event.getPostEventServiceItem().serviceID, clusterInfo);
                this.jeeServiceDetailsMap.put(event.getPostEventServiceItem().serviceID, jeeDetails);
                loadBalancersInfo.putNode(new LoadBalancerNodeInfo(event.getPostEventServiceItem().serviceID, clusterInfo, (JeeServiceDetails)detail));
                loadBalancersInfo.setDirty(true);
                System.out.println("[" + clusterInfo.getName() + "]: Adding [" + event.getPostEventServiceItem().serviceID + "] [" + jeeDetails.getHost() + ":" + jeeDetails.getPort() + jeeDetails.getContextPath() + "]");
            }
        }
        catch (Exception e) {
            System.out.println("Failed to add service");
            e.printStackTrace(System.out);
        }
    }

    public synchronized void serviceRemoved(ServiceDiscoveryEvent event) {
        try {
            LoadBalancerInfo loadBalancersInfo;
            ClusterInfo clusterInfo = this.clusterInfoMap.remove(event.getPreEventServiceItem().serviceID);
            JeeServiceDetails jeeServiceDetails = this.jeeServiceDetailsMap.remove(event.getPreEventServiceItem().serviceID);
            if (clusterInfo != null && (loadBalancersInfo = this.loadBalancersInfoMap.get(clusterInfo.getName())) != null) {
                loadBalancersInfo.removeNode(new LoadBalancerNodeInfo(event.getPreEventServiceItem().serviceID, clusterInfo, jeeServiceDetails));
                loadBalancersInfo.setDirty(true);
                System.out.println("[" + clusterInfo.getName() + "]: Removing [" + event.getPreEventServiceItem().serviceID + "] [" + jeeServiceDetails.getHost() + ":" + jeeServiceDetails.getPort() + jeeServiceDetails.getContextPath() + "]");
            }
        }
        catch (Exception e) {
            System.out.println("Failed to remove service");
            e.printStackTrace(System.out);
        }
    }

    public synchronized void serviceChanged(ServiceDiscoveryEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(this.updateInterval);
            }
            catch (InterruptedException e) {
                break;
            }
            boolean dirty = false;
            for (Map.Entry<String, LoadBalancerInfo> entry : this.loadBalancersInfoMap.entrySet()) {
                LoadBalancerNodeInfo[] infos = null;
                ApacheLoadBalancerAgent apacheLoadBalancerAgent = this;
                synchronized (apacheLoadBalancerAgent) {
                    if (entry.getValue().isDirty()) {
                        infos = entry.getValue().getNodes();
                        entry.getValue().setDirty(false);
                    }
                }
                if (infos == null) continue;
                dirty = true;
                System.out.println("[" + entry.getKey() + "]: Detected as dirty, updating config file...");
                File confFile = new File(this.configLocation + "/" + entry.getKey() + ".conf");
                try {
                    File velocityFile = new File(System.getProperty("lb.vmDir") + "/" + entry.getKey() + ".vm");
                    if (!velocityFile.exists() && !(velocityFile = new File(System.getProperty("lb.vmDir") + "/balancer-template.vm")).exists()) {
                        System.out.println("Failed to find velocity template from dir [" + System.getProperty("lb.vmDir"));
                    }
                    System.out.println("[" + entry.getKey() + "]: Using balancer template [" + velocityFile.getAbsolutePath() + "]");
                    Velocity.init();
                    PrintWriter writer = new PrintWriter(new FileOutputStream(confFile));
                    BufferedReader templateReader = new BufferedReader(new InputStreamReader(new FileInputStream(velocityFile)));
                    VelocityContext context = new VelocityContext();
                    context.put("loadBalancerInfo", (Object)entry.getValue());
                    Velocity.evaluate((Context)context, (Writer)writer, (String)"", (Reader)templateReader);
                    writer.flush();
                    writer.close();
                    ((Reader)templateReader).close();
                    System.out.println("[" + entry.getKey() + "]: Updated config file");
                }
                catch (Exception e) {
                    System.out.println("Failed to write config file, will try again later");
                    e.printStackTrace(System.out);
                    entry.getValue().setDirty(true);
                }
            }
            if (!dirty) continue;
            System.out.println("Executing [" + this.restartCommand + "]...");
            Process process = null;
            try {
                process = Runtime.getRuntime().exec(this.restartCommand);
                boolean exited = this.waitFor(process, 60000L);
                int exitValue = -999;
                if (exited) {
                    exitValue = process.exitValue();
                }
                System.out.println("Executed [" + this.restartCommand + "], exit code [" + exitValue + "]");
                if (exitValue == 0) continue;
                String output = FileCopyUtils.copyToString((Reader)new InputStreamReader(process.getErrorStream()));
                System.out.println(output);
            }
            catch (IOException e) {
                System.out.println("Failed to run [" + this.restartCommand + "]");
                e.printStackTrace(System.out);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                if (process == null) continue;
                try {
                    process.getErrorStream().close();
                }
                catch (Exception e) {}
                try {
                    process.getInputStream().close();
                }
                catch (Exception e) {}
                try {
                    process.getOutputStream().close();
                }
                catch (Exception e) {}
                try {
                    process.destroy();
                }
                catch (Exception e) {}
            }
        }
    }

    private boolean waitFor(Process process, long timeout) throws InterruptedException {
        int interval = 200;
        for (long timeWaiting = 0L; timeWaiting < timeout; timeWaiting += 200L) {
            if (!this.isProcessAlive(process)) {
                return true;
            }
            Thread.sleep(200L);
        }
        return false;
    }

    private boolean isProcessAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.startsWith("Windows");
    }

    public static void main(String[] args) throws Exception {
        GSLogConfigLoader.getLoader();
        final ApacheLoadBalancerAgent agent = new ApacheLoadBalancerAgent();
        CommandLineParser.Parameter[] params = CommandLineParser.parse((String[])args, (int)args.length);
        String apachectlLocation = null;
        String apcaheLocation = null;
        String configLocation = null;
        String restartCommand = null;
        for (CommandLineParser.Parameter param : params) {
            if (param.getName().equalsIgnoreCase("groups")) {
                agent.setGroups(param.getArguments());
            }
            if (param.getName().equalsIgnoreCase("locators")) {
                StringBuilder sb = new StringBuilder();
                for (String arg : param.getArguments()) {
                    sb.append(arg).append(',');
                }
                agent.setLocators(sb.toString());
            }
            if (param.getName().equalsIgnoreCase("apache")) {
                apcaheLocation = param.getArguments()[0];
            }
            if (param.getName().equalsIgnoreCase("restart-command")) {
                restartCommand = param.getArguments()[0];
            }
            if (param.getName().equalsIgnoreCase("apachectl")) {
                apachectlLocation = param.getArguments()[0];
            }
            if (param.getName().equalsIgnoreCase("conf-dir")) {
                configLocation = param.getArguments()[0];
            }
            if (!param.getName().equalsIgnoreCase("update-interval")) continue;
            agent.setUpdateInterval(Integer.parseInt(param.getArguments()[0]));
        }
        File tempalteDir = new File(System.getProperty("lb.vmDir"));
        if (!tempalteDir.exists()) {
            throw new IllegalArgumentException("Balancer template directory [" + tempalteDir.getAbsolutePath() + "] does not exists");
        }
        if (restartCommand != null) {
            agent.setRestartCommand(restartCommand);
        }
        if (apcaheLocation == null) {
            if (ApacheLoadBalancerAgent.isWindows()) {
                String location;
                String programFiles = System.getenv("ProgramFiles");
                if (programFiles != null && new File((location = programFiles + "/Apache Software Foundation/Apache2.2") + "/bin/httpd.exe").exists()) {
                    apcaheLocation = location;
                }
            } else {
                String location = "/opt/local/apache2";
                if (new File(location + "/bin/apachectl").exists()) {
                    apcaheLocation = location;
                } else {
                    location = "/opt/apache2";
                    if (new File(location + "/bin/apachectl").exists()) {
                        apcaheLocation = location;
                    }
                }
            }
        }
        if (apachectlLocation != null) {
            agent.setApachectlLocation(apachectlLocation);
        } else if (apcaheLocation != null) {
            if (ApacheLoadBalancerAgent.isWindows()) {
                agent.setApachectlLocation(apcaheLocation + "/bin/httpd.exe");
            } else {
                agent.setApachectlLocation(apcaheLocation + "/bin/apachectl");
            }
        } else {
            throw new IllegalArgumentException("Either apache location or apachectl location must be provided");
        }
        if (configLocation != null) {
            agent.setConfigLocation(configLocation);
        } else if (apcaheLocation != null) {
            agent.setConfigLocation(apcaheLocation + "/conf/gigaspaces");
        } else {
            throw new IllegalArgumentException("Either config directory location or apache location must be provided");
        }
        try {
            agent.start();
            final Thread mainThread = Thread.currentThread();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        agent.stop();
                    }
                    finally {
                        mainThread.interrupt();
                    }
                }
            });
            while (!mainThread.isInterrupted()) {
                try {
                    Thread.sleep(Long.MAX_VALUE);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            ApacheLoadBalancerAgent.printUsage();
            System.exit(1);
        }
    }

    public static void printUsage() {
        System.out.println("Usage: [-apache location] [-conf-dir location] [-update-interval value] [-restart-command command]");
        System.out.println("    -apache [location]       : The installation location of apache. Defaults to windows/unix common locations");
        System.out.println("    -conf-dir [location]     : The directory where the load balancer config files will be created. Defaults to [apache]/conf/gigaspaces");
        System.out.println("    -update-interval [value] : The interval (in milliseconds) when the load balancer conf files will be updated");
        System.out.println("    -restart-command [value] : The direct restart command for apache. Defaults to installation default locations for Windows and Unix systems");
        System.out.println("");
    }
}

