/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.gigaspaces.client.transaction.DistributedTransactionManagerProvider;
import com.gigaspaces.internal.client.spaceproxy.AbstractSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.lookup.SpaceUrlUtils;
import com.gigaspaces.internal.version.PlatformVersion;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.LookupFinder;
import com.j_spaces.core.client.LookupRequest;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.examples.benchmark.BenchmarkCommandException;
import com.j_spaces.examples.benchmark.BenchmarkCommandReport;
import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.BenchmarkListener;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.BenchmarkTestResult;
import com.j_spaces.examples.benchmark.Get;
import com.j_spaces.examples.benchmark.GetUpdate;
import com.j_spaces.examples.benchmark.HashtableGet;
import com.j_spaces.examples.benchmark.HashtablePut;
import com.j_spaces.examples.benchmark.HashtableRemove;
import com.j_spaces.examples.benchmark.ICommand;
import com.j_spaces.examples.benchmark.JMSNotify;
import com.j_spaces.examples.benchmark.JMSTake;
import com.j_spaces.examples.benchmark.JMSWrite;
import com.j_spaces.examples.benchmark.MessageAdaptor;
import com.j_spaces.examples.benchmark.MessageAdaptors;
import com.j_spaces.examples.benchmark.Notify;
import com.j_spaces.examples.benchmark.ObjectLock;
import com.j_spaces.examples.benchmark.Operation;
import com.j_spaces.examples.benchmark.Put;
import com.j_spaces.examples.benchmark.PutPutGetRemove;
import com.j_spaces.examples.benchmark.Read;
import com.j_spaces.examples.benchmark.ReadMultiple;
import com.j_spaces.examples.benchmark.ReadUpdate;
import com.j_spaces.examples.benchmark.Remove;
import com.j_spaces.examples.benchmark.Take;
import com.j_spaces.examples.benchmark.TakeMultiple;
import com.j_spaces.examples.benchmark.Write;
import com.j_spaces.examples.benchmark.WriteMultiple;
import com.j_spaces.examples.benchmark.WriteReadUpdateTake;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.map.CacheFinder;
import com.j_spaces.map.GSMapImpl;
import com.j_spaces.map.IMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.sql.Time;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.TransactionManager;

public class BenchmarkCommand
implements ICommand {
    private static final String KEY_HELP = "h";
    private static final String KEY_CLEAN = "clean";
    private static final String KEY_SIZE = "s";
    private static final String KEY_CONTENT = "content";
    private static final String KEY_TIMEOUT = "t";
    public static final String KEY_LEASE_TIME = "lease";
    private static final String KEY_TAKE = "take";
    private static final String KEY_TX = "tx";
    private static final String KEY_READ_TIMES = "repeatsecond";
    private static final String KEY_WRITE_TIMES = "repeatfirst";
    private static final String KEY_DCACHE = "cache";
    private static final String KEY_THREADS = "tr";
    private static final String KEY_REP_SPACE = "target";
    private static final String KEY_MULTIPLE = "m";
    private static final String KEY_RANDOM = "rand";
    private static final String KEY_WRITE_DELAY = "delaywrite";
    private static final String KEY_WRITE_RATE = "writerate";
    private static final String KEY_NUMBER_OF_ITERATION = "i";
    private static final String KEY_FRST_RANGE = "rangefirst";
    private static final String KEY_SCND_RANGE = "rangesecond";
    private static final String KEY_READ_TAKE_DELAY = "delayreadtake";
    private static final String KEY_MAP = "map";
    private static final String KEY_PARALLEL = "parallel";
    private static final String KEY_NOTIFY = "notify";
    private static final String KEY_ONLY = "execute";
    private static final String KEY_GLOBAL_TP = "showrate";
    private static final String KEY_THREAD_TP = "showthreadrate";
    private static final String KEY_EXIT = "exit";
    private static final String KEY_HASHTABLE = "hashtable";
    private static final String KEY_EXT_ENTRY = "externalentry";
    private static final String KEY_ALL = "all";
    private static final String KEY_PAUSE = "pause";
    private static final String KEY_STRESS = "stress";
    private static final String KEY_FILE = "f";
    private static final String KEY_URL = "url";
    private static final String KEY_UPDATE = "update";
    private static final String KEY_BENCH = "bench";
    public static final String KEY_MESSAGE_TYPE = "objecttype";
    public static final String KEY_USE_SINGLE_SPACE_PROXY = "usesinglespace";
    public static final String KEY_IS_RETURN_LEASE = "returnlease";
    private BenchmarkConfiguration parameters;
    private static final int ONLY_FIRST = 1;
    private static final int ONLY_SECOND = 2;
    private boolean useReplicationSpace;
    private String firstOperation;
    private String secondOperation;
    private String thirdOperation;
    private String mode;
    private boolean isMap;
    private boolean isHashtable;
    private boolean isExtEntry;
    private boolean isRead;
    private boolean isUseDCache;
    private boolean isAll;
    private int theOnlyOperation;
    private boolean isWriteDelay;
    private boolean isReadTakeDelay;
    private String resultFileName = null;
    private LinkedHashMap<Thread, Operation> threads;
    private ObjectLock objLock;
    private ArrayList<Long> firstOperationTimeOfEachTread;
    private ArrayList<Long> secondOperationTimeOfEachThread;
    private ArrayList<Long> thirdOperationTimeOfEachThread;
    private ArrayList<Long> firstOperationTimeOfEachThreadWFCycle;
    private ArrayList<Long> secondOperationTimeOfEachThreadWFCycle;
    private long initialTestTime;
    private long finalTestTime;
    private Hashtable m_hashtable = new Hashtable();
    private boolean doneFirstCycle;
    private int stressCycle;
    private BenchmarkOutput benchmarkOutput;
    private PrintStream outWriter;
    public static boolean START_STOP_FLAG = true;
    private static final String KEY_GUI = "gui";
    private static final String KEY_DTX = "dtx";
    public static final String KEY_DTX_MANAGER_URL = "dtx-manager-url";
    private BenchmarkListener uiExceptionHandler;
    private boolean _isFirstOperationInitialized = false;
    private boolean _isSecondOperationInitialized = false;
    private boolean _isThirdOperationInitialized = false;
    private double _firstOperationAverageTotalTime = 0.0;
    private double _secondOperationAverageTotalTime = 0.0;
    private double _thirdOperationAverageTotalTime = 0.0;
    private double _firstAverageThroughput = 0.0;
    private double _secondAverageThroughput = 0.0;
    private double _thirdAverageThroughput = 0.0;
    private double _firstTotalThroughput = 0.0;
    private double _secondTotalThroughput = 0.0;
    private double _thirdTotalThroughput = 0.0;
    private final BenchmarkTestResult benchTestResult;
    private DistributedTransactionManagerProvider distributedTransactionManagerProvider;
    int _maxKeyLength = 0;
    private ArrayList<String> usageKey = new ArrayList();
    private ArrayList<String> usageDef = new ArrayList();
    private static final String PADD = " ";
    private static final String TAB = "\t";
    int _maxExKeyLength;
    private ArrayList<String> examplesKey = new ArrayList();
    private ArrayList<String> examplesEg = new ArrayList();
    private ArrayList<String> exampleEx = new ArrayList();

    public double getFirstOperationAverageTotalTime() {
        return this._firstOperationAverageTotalTime;
    }

    public double getSecondOperationAverageTotalTime() {
        return this._secondOperationAverageTotalTime;
    }

    public double getThirdOperationAverageTotalTime() {
        return this._thirdOperationAverageTotalTime;
    }

    public double getFirstAverageThroughput() {
        return this._firstAverageThroughput;
    }

    public double getSecondAverageThroughput() {
        return this._secondAverageThroughput;
    }

    public double getThirdAverageThroughput() {
        return this._thirdAverageThroughput;
    }

    public double getFirstTotalThroughput() {
        return this._firstTotalThroughput;
    }

    public double getSecondTotalThroughput() {
        return this._secondTotalThroughput;
    }

    public double getThirdTotalThroughput() {
        return this._thirdTotalThroughput;
    }

    public BenchmarkCommand(BenchmarkOutput benchmarkOutput, BenchmarkTestResult benchTestResult, BenchmarkListener uiExceptionHandler) {
        this.benchmarkOutput = benchmarkOutput;
        this.benchTestResult = benchTestResult;
        this.uiExceptionHandler = uiExceptionHandler;
    }

    public BenchmarkCommand(String spaceUrl, int cycle, PrintStream pw, BenchmarkOutput benchmarkOutput, BenchmarkTestResult benchTestResult, BenchmarkListener uiExceptionHandler) {
        this(benchmarkOutput, benchTestResult, uiExceptionHandler);
        this.parameters = new BenchmarkConfiguration(spaceUrl);
        this.isRead = true;
        this.outWriter = pw;
        this.useReplicationSpace = false;
        this.isUseDCache = false;
        this.firstOperation = "WRITE";
        this.secondOperation = "READ";
        this.theOnlyOperation = 0;
        this.mode = "";
        this.threads = new LinkedHashMap();
        this.isMap = false;
        this.isWriteDelay = false;
        this.isReadTakeDelay = false;
        this.objLock = new ObjectLock(this.parameters.threadCount);
        this.firstOperationTimeOfEachTread = null;
        this.secondOperationTimeOfEachThread = null;
        this.secondOperationTimeOfEachThreadWFCycle = null;
        this.isAll = false;
        this.doneFirstCycle = cycle > 0;
        this.stressCycle = cycle;
    }

    public void countEntries() {
        block14: {
            long total = 0L;
            String output_space = null;
            String output_repSpace = null;
            int length = 0;
            try {
                if (this.parameters.space instanceof IJSpace) {
                    SpaceRuntimeInfo spaceRuntimeInfo;
                    GSMapImpl map;
                    IJSpace _space = this.parameters.space;
                    IRemoteJSpaceAdmin admin = (IRemoteJSpaceAdmin)_space.getAdmin();
                    if (Boolean.valueOf(admin.getConfig().isClustered()).booleanValue()) {
                        return;
                    }
                    if (this.isMap) {
                        map = new GSMapImpl(this.parameters.space);
                        total = map.size();
                    } else {
                        spaceRuntimeInfo = admin.getRuntimeInfo();
                        total = JSpaceUtilities.countSpaceObjects((SpaceRuntimeInfo)spaceRuntimeInfo);
                    }
                    output_space = "**** " + this.parameters.space.getName() + " Space stores " + total + " Entries ****";
                    length = output_space.length();
                    if (this.parameters.repSpace != null) {
                        _space = this.parameters.repSpace;
                        admin = (IRemoteJSpaceAdmin)_space.getAdmin();
                        if (Boolean.valueOf(admin.getConfig().isClustered()).booleanValue()) {
                            return;
                        }
                        if (this.isMap) {
                            map = new GSMapImpl(this.parameters.repSpace);
                            total = map.size();
                        } else {
                            spaceRuntimeInfo = admin.getRuntimeInfo();
                            total = JSpaceUtilities.countSpaceObjects((SpaceRuntimeInfo)spaceRuntimeInfo);
                        }
                        output_repSpace = "**** " + this.parameters.repSpace.getName() + " Space stores " + total + " Entries ****";
                        if (length < output_repSpace.length()) {
                            length = output_repSpace.length();
                        }
                    }
                }
                StringBuilder line = new StringBuilder();
                for (int i = 0; i < length; ++i) {
                    line.append('*');
                }
                String finalLine = line.toString();
                this.say(finalLine);
                this.say(output_space);
                if (output_repSpace != null) {
                    this.say(output_repSpace);
                }
                this.say(finalLine);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.parameters.isGUI && this.parameters.isExit) {
                    System.exit(-1);
                }
                if (!this.parameters.isGUI) break block14;
                this.uiExceptionHandler.onError("Count entries", e);
            }
        }
    }

    public void createFirstOperationThreads() {
        Thread firstOperationThread = null;
        Operation operation = null;
        String operationName = "Read";
        for (int threadNumber = 0; threadNumber < this.parameters.threadCount; ++threadNumber) {
            MessageAdaptor adaptor = MessageAdaptors.getByCode(this.parameters.messageType);
            if (this.parameters.isNotify) {
                if (adaptor.isJMS()) {
                    operation = new JMSNotify(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "JMSNotify";
                } else {
                    operation = new Notify(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "Notify";
                }
            } else if (this.isAll) {
                if (this.isMap) {
                    operation = new Put(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "Put";
                } else if (this.parameters.isMultiple) {
                    if (adaptor.isJMS()) {
                        this.say(JSpaceUtilities.LINE_SEPARATOR + "Multiple Write operation is not supported for JMS message type." + JSpaceUtilities.LINE_SEPARATOR);
                    } else {
                        operation = new WriteMultiple(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                        operationName = "WriteMultiple";
                    }
                } else if (adaptor.isJMS()) {
                    operation = new JMSWrite(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "JMSWrite";
                } else {
                    operation = new Write(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "Write";
                }
            } else if (this.parameters.isBench) {
                if (this.isMap) {
                    operation = new PutPutGetRemove(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "PutPutGetRemove";
                } else {
                    operation = new WriteReadUpdateTake(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                }
                operationName = "WriteReadUpdateTake";
            } else if (this.isMap) {
                operation = new Put(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                operationName = "Put";
            } else if (this.isHashtable) {
                operation = new HashtablePut(this.parameters, threadNumber, this.objLock, this.m_hashtable, this.benchmarkOutput);
                operationName = "HashtablePut";
            } else if (this.parameters.isMultiple) {
                if (adaptor.isJMS()) {
                    this.say(JSpaceUtilities.LINE_SEPARATOR + "Multiple Write operation is not supported for JMS message type." + JSpaceUtilities.LINE_SEPARATOR);
                } else {
                    operation = new WriteMultiple(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "WriteMultiple";
                }
            } else if (adaptor.isJMS()) {
                operation = new JMSWrite(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                operationName = "JMSWrite";
            } else {
                operation = new Write(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                operationName = "Write";
            }
            operationName = operationName + "_" + threadNumber;
            firstOperationThread = new Thread((Runnable)operation, operationName);
            this.threads.put(firstOperationThread, operation);
            this._isFirstOperationInitialized = operation != null;
        }
    }

    public void createSecondOperationThreads(boolean isSetSecondOperation) {
        Thread secondOperationThread = null;
        Operation operation = null;
        String operationName = "Read";
        for (int threadNumber = 0; threadNumber < this.parameters.threadCount; ++threadNumber) {
            MessageAdaptor adaptor = MessageAdaptors.getByCode(this.parameters.messageType);
            if (this.parameters.isNotify) {
                if (this.parameters.isMultiple) {
                    operation = new WriteMultiple(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "WriteMultiple";
                } else if (adaptor.isJMS()) {
                    operation = new JMSWrite(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "JMSWrite";
                } else {
                    operation = new Write(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "Write";
                }
            } else if (this.isAll) {
                if (this.isMap) {
                    operation = new Get(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "Get";
                } else if (adaptor.isJMS()) {
                    this.say(JSpaceUtilities.LINE_SEPARATOR + "Read operation is not supported for JMS message type." + JSpaceUtilities.LINE_SEPARATOR);
                } else if (this.parameters.isMultiple) {
                    operation = new ReadMultiple(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "ReadMultiple";
                } else {
                    operation = new Read(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "Read";
                }
            } else if (this.isMap) {
                if (this.isRead) {
                    operation = new Get(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "Get";
                } else {
                    operation = new Remove(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "Remove";
                }
            } else if (this.isHashtable) {
                operation = this.isRead ? new HashtableGet(this.parameters, threadNumber, this.objLock, this.m_hashtable, this.benchmarkOutput) : new HashtableRemove(this.parameters, threadNumber, this.objLock, this.m_hashtable, this.benchmarkOutput);
            } else if (this.parameters.isMultiple) {
                if (this.isRead) {
                    if (adaptor.isJMS()) {
                        this.say(JSpaceUtilities.LINE_SEPARATOR + "Multiple Read operation is not supported for JMS message type." + JSpaceUtilities.LINE_SEPARATOR);
                    } else {
                        operation = new ReadMultiple(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                        operationName = "ReadMultiple";
                    }
                } else if (adaptor.isJMS()) {
                    this.say(JSpaceUtilities.LINE_SEPARATOR + "Multiple Take operation is not supported for JMS message type." + JSpaceUtilities.LINE_SEPARATOR);
                } else {
                    operation = new TakeMultiple(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "TakeMultiple";
                }
            } else if (this.parameters.isUpdate) {
                if (this.isMap) {
                    operation = new GetUpdate(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "GetUpdate";
                } else {
                    operation = new ReadUpdate(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "ReadUpdate";
                }
            } else if (this.isRead) {
                if (adaptor.isJMS()) {
                    this.say(JSpaceUtilities.LINE_SEPARATOR + "Read operation is not supported for JMS message type." + JSpaceUtilities.LINE_SEPARATOR);
                } else {
                    operation = new Read(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                    operationName = "Read";
                }
            } else if (adaptor.isJMS()) {
                operation = new JMSTake(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                operationName = "JMSTake";
            } else {
                operation = new Take(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                operationName = "Take";
            }
            if (isSetSecondOperation) {
                operation.setSecondOperation(true);
            }
            operationName = operationName + "_" + threadNumber;
            secondOperationThread = new Thread((Runnable)operation, operationName);
            this._isSecondOperationInitialized = operation != null;
            this.threads.put(secondOperationThread, operation);
        }
    }

    public void createThirdOperationThreads() {
        Operation operation = null;
        for (int threadNumber = 0; threadNumber < this.parameters.threadCount; ++threadNumber) {
            String operationName;
            MessageAdaptor adaptor = MessageAdaptors.getByCode(this.parameters.messageType);
            if (this.isMap) {
                operation = new Remove(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                operationName = "Remove";
            } else if (adaptor.isJMS()) {
                operationName = "JMSTake";
                if (this.parameters.isMultiple) {
                    this.say(JSpaceUtilities.LINE_SEPARATOR + "Multiple Take operation is not supported for JMS message type." + JSpaceUtilities.LINE_SEPARATOR);
                } else {
                    operation = new JMSTake(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                }
            } else if (this.parameters.isMultiple) {
                operation = new TakeMultiple(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                operationName = "TakeMultiple";
            } else {
                operation = new Take(this.parameters, threadNumber, this.objLock, this.benchmarkOutput);
                operationName = "Take";
            }
            operationName = operationName + "_" + threadNumber;
            this.threads.put(new Thread((Runnable)operation, operationName), operation);
            this._isThirdOperationInitialized = operation != null;
        }
    }

    public void stopAllThreads() {
        START_STOP_FLAG = false;
        this.threads.clear();
        System.gc();
    }

    public void startThreads(int firstIndex, int lastIndex) {
        int i;
        START_STOP_FLAG = true;
        Iterator<Thread> iter = this.threads.keySet().iterator();
        if (firstIndex != 0) {
            for (i = 0; i < firstIndex && iter.hasNext(); ++i) {
                iter.next();
            }
        }
        for (i = firstIndex; i < lastIndex; ++i) {
            if (!START_STOP_FLAG || !iter.hasNext()) continue;
            Thread aThread = iter.next();
            aThread.start();
        }
    }

    public void joinThreads(int firstIndex, int lastIndex) throws InterruptedException {
        int i;
        Iterator<Thread> iter = this.threads.keySet().iterator();
        for (i = 0; i < firstIndex && iter.hasNext(); ++i) {
            iter.next();
        }
        while (i < lastIndex && iter.hasNext()) {
            Thread aThread = iter.next();
            aThread.join();
            ++i;
        }
    }

    public void say(String mes) {
        System.out.println(Thread.currentThread().getName() + " - " + mes);
        if (this.outWriter != null) {
            this.outWriter.println(mes);
        }
    }

    public boolean initInputConfigurationParameters(Map args, PrintWriter out, IJSpace theSpace, IMap theCache, BenchmarkOutput benchmarkOutput) {
        block143: {
            try {
                StringTokenizer st;
                if (args.containsKey(KEY_HELP)) {
                    if (out != null) {
                        this.usage(out);
                    }
                    if (!this.parameters.isGUI) {
                        System.exit(1);
                    }
                }
                this.parameters.isGUI = args.containsKey(KEY_GUI);
                if (args.containsKey(KEY_URL)) {
                    String newUrl;
                    this.parameters.spaceURL = newUrl = (String)args.get(KEY_URL);
                }
                if (args.containsKey(KEY_FILE)) {
                    this.resultFileName = (String)args.get(KEY_FILE);
                    if (this.resultFileName == null || this.resultFileName.length() == 0) {
                        this.resultFileName = "BenchMarkResult_" + new Date(System.currentTimeMillis()) + "_" + new Time(System.currentTimeMillis());
                        this.resultFileName = this.resultFileName.replaceAll(":", "_");
                        this.resultFileName = this.resultFileName.replaceAll(PADD, "_") + ".xls";
                    }
                }
                if (args.containsKey(KEY_ALL)) {
                    this.isAll = true;
                    this.parameters.isAll = true;
                    if (this.isMap) {
                        this.firstOperation = "PUT";
                        this.secondOperation = "GET";
                        this.thirdOperation = "REMOVE";
                    } else {
                        this.firstOperation = "WRITE";
                        this.secondOperation = "READ";
                        this.thirdOperation = "TAKE";
                    }
                }
                if (args.containsKey(KEY_ONLY)) {
                    this.parameters.isOnly = true;
                    if (args.get(KEY_ONLY).equals("first")) {
                        this.theOnlyOperation = 1;
                    }
                    if (args.get(KEY_ONLY).equals("second")) {
                        this.theOnlyOperation = 2;
                    }
                }
                if (args.containsKey(KEY_TAKE)) {
                    this.isRead = false;
                    this.secondOperation = "TAKE";
                }
                if (args.containsKey(KEY_EXIT)) {
                    this.parameters.isExit = true;
                }
                if (args.containsKey(KEY_SIZE)) {
                    this.parameters.messageLength = Integer.parseInt((String)args.get(KEY_SIZE));
                    this.parameters.messageBuf = new byte[this.parameters.messageLength];
                }
                if (args.containsKey(KEY_CONTENT)) {
                    this.parameters.changeContent = true;
                }
                if (args.containsKey(KEY_NUMBER_OF_ITERATION)) {
                    this.parameters.numberOfIterations = Integer.parseInt((String)args.get(KEY_NUMBER_OF_ITERATION));
                    if (this.parameters.numberOfIterations % 2 != 0) {
                        if (!this.parameters.isGUI) {
                            this.say("The ITERATIONS number should be even.Benchmark test stopped.");
                            System.exit(-1);
                        } else {
                            if (benchmarkOutput != null) {
                                benchmarkOutput.alert("The number of iterations must be even number.");
                            }
                            return false;
                        }
                    }
                }
                this.parameters.firstOpRange = args.containsKey(KEY_FRST_RANGE);
                this.parameters.secondOpRange = args.containsKey(KEY_SCND_RANGE);
                if (this.parameters.firstOpRange || this.parameters.secondOpRange) {
                    String range;
                    boolean inrange = false;
                    if (this.parameters.firstOpRange) {
                        range = (String)args.get(KEY_FRST_RANGE);
                        st = new StringTokenizer(range, "-");
                        if (st.countTokens() == 2) {
                            this.parameters.firstOpRangeFrom = Integer.parseInt(st.nextToken());
                            this.parameters.firstOpRangeTo = Integer.parseInt(st.nextToken());
                        }
                        if (this.parameters.firstOpRangeFrom > this.parameters.firstOpRangeTo || this.parameters.firstOpRangeTo == 0) {
                            this.say("first operation range parameters are invalid.");
                            if (!this.parameters.isGUI) {
                                System.exit(-1);
                            }
                        }
                        inrange = true;
                    }
                    if (this.parameters.secondOpRange) {
                        range = (String)args.get(KEY_SCND_RANGE);
                        st = new StringTokenizer(range, "-");
                        if (st.countTokens() == 2) {
                            this.parameters.secondOpRangeFrom = Integer.parseInt(st.nextToken());
                            this.parameters.secondOpRangeTo = Integer.parseInt(st.nextToken());
                        }
                        if (this.parameters.secondOpRangeFrom > this.parameters.secondOpRangeTo || this.parameters.secondOpRangeTo == 0) {
                            this.say("second operation range parameters are invalid.");
                            if (!this.parameters.isGUI) {
                                System.exit(-1);
                            }
                        }
                        inrange = true;
                    }
                    if (!inrange) {
                        this.say("range parameter is invalid. Specify each range per operation.");
                        this.say("-range 1stfrom 1000 1stto 2000");
                        if (!this.parameters.isGUI) {
                            System.exit(-1);
                        }
                    }
                } else {
                    this.parameters.firstOpRangeFrom = 0;
                    this.parameters.firstOpRangeTo = this.parameters.numberOfIterations;
                    this.parameters.secondOpRangeFrom = 0;
                    this.parameters.secondOpRangeTo = this.parameters.numberOfIterations;
                }
                if (args.containsKey(KEY_WRITE_DELAY)) {
                    this.isWriteDelay = true;
                    this.parameters.delayWrite = Integer.parseInt((String)args.get(KEY_WRITE_DELAY));
                }
                if (args.containsKey(KEY_READ_TAKE_DELAY)) {
                    this.isReadTakeDelay = true;
                    this.parameters.delayReadTake = Integer.parseInt((String)args.get(KEY_READ_TAKE_DELAY));
                }
                if (args.containsKey(KEY_WRITE_RATE)) {
                    this.parameters.isWriteRate = true;
                    this.parameters.writeRate = Integer.parseInt((String)args.get(KEY_WRITE_RATE));
                    this.parameters.globalRateIter = new AtomicInteger(0);
                }
                if (args.containsKey(KEY_RANDOM)) {
                    this.parameters.isRandom = true;
                    String randValue = (String)args.get(KEY_RANDOM);
                    this.parameters.numberOfRandomIterations = randValue.length() > 0 ? Integer.parseInt(randValue) : this.parameters.numberOfIterations;
                }
                if (args.containsKey(KEY_READ_TIMES)) {
                    if (!this.isRead) {
                        if (!this.parameters.isGUI) {
                            this.say("Setting READ TIMES and TAKE options is impossible .Benchmark test stopped.");
                            System.exit(-1);
                        } else {
                            if (benchmarkOutput != null) {
                                benchmarkOutput.alert("Number of Reads parameter cannot be used with Take operation.");
                            }
                            return false;
                        }
                    }
                    this.parameters.readRepeatTimes = Integer.parseInt((String)args.get(KEY_READ_TIMES));
                    if (this.parameters.readRepeatTimes <= 0L) {
                        if (!this.parameters.isGUI) {
                            this.say("The READ TIMES should not be negative.Benchmark test stopped.");
                            System.exit(-1);
                        } else {
                            if (benchmarkOutput != null) {
                                benchmarkOutput.alert("Number of Reads cannot be negative number.");
                            }
                            return false;
                        }
                    }
                }
                if (args.containsKey(KEY_WRITE_TIMES)) {
                    this.parameters.writeRepeatTimes = Integer.parseInt((String)args.get(KEY_WRITE_TIMES));
                    if (this.parameters.writeRepeatTimes <= 0L) {
                        this.say("The WRITE TIMES should not be negative.Benchmark test stopped.");
                        if (!this.parameters.isGUI) {
                            System.exit(-1);
                        }
                    }
                }
                if (args.containsKey(KEY_THREADS)) {
                    this.parameters.threadCount = Integer.parseInt((String)args.get(KEY_THREADS));
                    this.objLock = new ObjectLock(this.parameters.threadCount);
                }
                if (args.containsKey(KEY_TIMEOUT)) {
                    this.parameters.timeout = Long.parseLong((String)args.get(KEY_TIMEOUT));
                }
                this.parameters.isReturnLease = args.containsKey(KEY_IS_RETURN_LEASE);
                this.parameters.isUseSingleSpaceProxy = args.containsKey(KEY_USE_SINGLE_SPACE_PROXY);
                if (args.containsKey(KEY_PARALLEL)) {
                    this.parameters.isParallel = true;
                    if (this.parameters.timeout <= 0L && !this.parameters.isGUI) {
                        this.parameters.timeout = 60000L;
                    }
                    this.objLock = !this.isAll || this.parameters.isGUI ? new ObjectLock(this.parameters.threadCount * 2) : new ObjectLock(this.parameters.threadCount * 3);
                }
                if (args.containsKey(KEY_MESSAGE_TYPE)) {
                    this.parameters.messageType = MessageAdaptors.getMessageType((String)args.get(KEY_MESSAGE_TYPE));
                }
                if (args.containsKey(KEY_THREAD_TP)) {
                    this.parameters.isThreadThroughput = true;
                    if (!args.get(KEY_THREAD_TP).equals("")) {
                        this.parameters.threadThroughputIterations = Integer.parseInt((String)args.get(KEY_THREAD_TP));
                    }
                }
                if (args.containsKey(KEY_GLOBAL_TP)) {
                    this.parameters.isGlobalThroughput = true;
                    this.parameters.globalThroughputFirstList = new LinkedList();
                    this.parameters.globalThroughputSecondList = new LinkedList();
                    if (this.isAll) {
                        this.parameters.globalThroughputThirdList = new LinkedList();
                    }
                    if (!args.get(KEY_GLOBAL_TP).equals("")) {
                        this.parameters.globalThroughputIterations = Integer.parseInt((String)args.get(KEY_GLOBAL_TP));
                    }
                    this.parameters.globalThroughputFirstOperationCounter = new AtomicInteger(0);
                    this.parameters.globalThroughputSecondOperationCounter = new AtomicInteger(0);
                    this.parameters.globalThroughputThirdOperationCounter = new AtomicInteger(0);
                }
                if (args.containsKey(KEY_LEASE_TIME)) {
                    this.parameters.lease = Long.parseLong((String)args.get(KEY_LEASE_TIME));
                }
                if (args.containsKey(KEY_NOTIFY)) {
                    this.parameters.isNotify = true;
                    this.isRead = false;
                    this.firstOperation = "NOTIFY";
                    this.secondOperation = "WRITE";
                }
                if (args.containsKey(KEY_MULTIPLE)) {
                    if (this.parameters.isRandom) {
                        if (!this.parameters.isGUI) {
                            this.say("Setting MULTIPLE and RANDOM options is impossible. Benchmark test stopped.");
                            System.exit(-1);
                        } else {
                            if (benchmarkOutput != null) {
                                benchmarkOutput.alert("Random option cannot be used with batch operations.");
                            }
                            return false;
                        }
                    }
                    this.parameters.isMultiple = true;
                    this.mode = "MULTIPLE";
                    this.parameters.numOfBatches = Integer.parseInt((String)args.get(KEY_MULTIPLE));
                    if (this.parameters.numberOfIterations % this.parameters.numOfBatches != 0) {
                        if (!this.parameters.isGUI) {
                            this.say("The BATCH SIZE must be integer and not " + (double)this.parameters.numberOfIterations / (double)this.parameters.numOfBatches + ". Benchmark test stopped.");
                            System.exit(-1);
                        } else {
                            if (benchmarkOutput != null) {
                                benchmarkOutput.alert("The number of batches value must be Modulo of " + this.parameters.numberOfIterations);
                            }
                            return false;
                        }
                    }
                    this.parameters.batchAmount = this.parameters.numberOfIterations / this.parameters.numOfBatches;
                }
                boolean useLocalCacheFALSE = false;
                String urlParams = null;
                st = new StringTokenizer(this.parameters.spaceURL, "?");
                while (st.hasMoreTokens()) {
                    urlParams = st.nextToken();
                }
                st = new StringTokenizer(urlParams, "&");
                while (st.hasMoreTokens()) {
                    urlParams = st.nextToken();
                    if (urlParams.equals("useLocalCache") || urlParams.equals("useLocalCache=true")) {
                        this.isUseDCache = true;
                        break;
                    }
                    if (!urlParams.equals("useLocalCache=false")) continue;
                    useLocalCacheFALSE = true;
                    break;
                }
                if (!this.isUseDCache && !useLocalCacheFALSE && args.containsKey(KEY_DCACHE)) {
                    this.isUseDCache = true;
                    this.parameters.spaceURL = SpaceUrlUtils.setPropertyInUrl((String)this.parameters.spaceURL, (String)"useLocalCache", null, (boolean)false);
                }
                try {
                    if (args.containsKey(KEY_MAP)) {
                        if (this.parameters.isGUI) {
                            this.isMap = true;
                            this.firstOperation = "PUT";
                            this.secondOperation = "GET";
                        } else {
                            this.parameters.cache = (IMap)CacheFinder.find((String)this.parameters.spaceURL);
                            this.parameters.space = this.parameters.cache.getMasterSpace();
                        }
                    } else if (!this.parameters.isGUI) {
                        Object foundObj = SpaceFinder.find((String)this.parameters.spaceURL);
                        this.parameters.space = foundObj instanceof IJSpace ? (IJSpace)foundObj : (IJSpace)foundObj;
                    }
                    if (!this.parameters.isGUI) {
                        IJSpace spaceProxy = this.parameters.space;
                        if (this.parameters.isUseSingleSpaceProxy && ((ISpaceProxy)spaceProxy).isClustered()) {
                            this.parameters.space = spaceProxy.getDirectProxy().getNonClusteredProxy();
                            if (args.containsKey(KEY_MAP)) {
                                this.parameters.cache = (IMap)CacheFinder.find((String)this.parameters.space.getFinderURL().getURL());
                            }
                        }
                    }
                }
                catch (FinderException ex) {
                    ex.printStackTrace();
                    if (!this.parameters.isGUI) {
                        this.say(this.parameters.spaceURL + " space was not found. Benchmark test stopped.");
                        System.exit(-1);
                    }
                    if (benchmarkOutput != null) {
                        benchmarkOutput.alert("Space not found: " + this.parameters.spaceURL);
                    }
                    return false;
                }
                if (this.parameters.isGUI) {
                    this.parameters.cache = theCache;
                    this.parameters.space = theSpace;
                }
                int updateModifier = this.parameters.isReturnLease ? 0 : 4096;
                this.parameters.space.setUpdateModifiers(updateModifier);
                try {
                    if (args.containsKey(KEY_REP_SPACE)) {
                        this.useReplicationSpace = true;
                        this.parameters.repSpaceURL = (String)args.get(KEY_REP_SPACE);
                        if (this.isUseDCache) {
                            this.parameters.repSpaceURL = this.parameters.repSpaceURL + "?" + "useLocalCache" + "=" + this.parameters.dCacheMode;
                        }
                        if (args.containsKey(KEY_MAP)) {
                            this.parameters.repCache = (IMap)CacheFinder.find((String)this.parameters.repSpaceURL);
                            this.parameters.repSpace = this.parameters.repCache.getMasterSpace();
                        } else {
                            Object foundRepSpace = SpaceFinder.find((String)this.parameters.repSpaceURL);
                            this.parameters.repSpace = foundRepSpace instanceof IJSpace ? (IJSpace)foundRepSpace : (IJSpace)foundRepSpace;
                        }
                    }
                }
                catch (FinderException ex) {
                    ex.printStackTrace();
                    if (!this.parameters.isGUI) {
                        this.say(this.parameters.repSpace + " space was not found. Benchmark test stoped.");
                        System.exit(-1);
                    }
                    if (benchmarkOutput != null) {
                        benchmarkOutput.alert("Space not found: " + this.parameters.spaceURL);
                    }
                    return false;
                }
                if (args.containsKey(KEY_MAP)) {
                    this.isMap = true;
                    if (!args.containsKey(KEY_UPDATE) && !args.containsKey(KEY_BENCH)) {
                        this.firstOperation = "PUT";
                        this.secondOperation = this.isRead ? "GET" : "REMOVE";
                        if (this.isAll) {
                            this.firstOperation = "PUT";
                            this.secondOperation = "GET";
                            this.thirdOperation = "REMOVE";
                        }
                    }
                }
                if (args.containsKey(KEY_HASHTABLE)) {
                    this.isHashtable = true;
                    this.firstOperation = "HASHTABLE_PUT";
                    this.secondOperation = this.isRead ? "HASHTABLE_GET" : "HASHTABLE_REMOVE";
                    if (this.isAll) {
                        this.firstOperation = "HASHTABLE_PUT";
                        this.secondOperation = "HASHTABLE_GET";
                        this.thirdOperation = "HASHTABLE_REMOVE";
                    }
                }
                if (args.containsKey(KEY_EXT_ENTRY)) {
                    this.isExtEntry = true;
                }
                if (args.containsKey(KEY_CLEAN)) {
                    this.parameters.isCleanSpace = true;
                    if (this.parameters.isGUI) {
                        if (!this.isUseDCache) {
                            this.say("Cleaning " + this.parameters.space.getName() + " Space before test...");
                            this.parameters.space.clear(null, null);
                            if (this.parameters.space.isEmbedded()) {
                                System.gc();
                            }
                            if (this.useReplicationSpace) {
                                this.say("Cleaning " + this.parameters.repSpace.getName() + " Space before test...");
                                this.parameters.repSpace.clear(null, null);
                            }
                        } else {
                            if (this.isMap) {
                                this.parameters.cache.clear(true);
                            } else {
                                ((AbstractSpaceProxy)this.parameters.space).getRemoteSpace().clear(null, null);
                                ((AbstractSpaceProxy)this.parameters.space).getLocalSpace().clear(null, null);
                            }
                            if (this.useReplicationSpace) {
                                if (this.isMap) {
                                    this.parameters.repCache.clear(true);
                                } else {
                                    ((AbstractSpaceProxy)this.parameters.repSpace).getRemoteSpace().clear(null, null);
                                    ((AbstractSpaceProxy)this.parameters.repSpace).getLocalSpace().clear(null, null);
                                }
                            }
                        }
                    } else if (!this.isUseDCache) {
                        this.say("Cleaning Space before test...");
                        if (this.parameters.space instanceof IJSpace) {
                            this.parameters.space.clear(null, null);
                        } else {
                            this.cleanJavaSpace(this.parameters.space);
                        }
                        if (this.useReplicationSpace) {
                            if (this.parameters.repSpace instanceof IJSpace) {
                                this.say("Cleaning " + this.parameters.repSpace.getName() + " Space before test...");
                                this.parameters.repSpace.clear(null, null);
                            } else {
                                this.cleanJavaSpace(this.parameters.repSpace);
                            }
                        }
                    } else {
                        this.say("Cleaning remote Space and local Cache before test...");
                        if (this.isMap) {
                            this.parameters.cache.clear(true);
                        } else {
                            ((AbstractSpaceProxy)this.parameters.space).getRemoteSpace().clear(null, null);
                            ((AbstractSpaceProxy)this.parameters.space).getLocalSpace().clear(null, null);
                        }
                        if (this.useReplicationSpace) {
                            if (this.isMap) {
                                this.parameters.repCache.clear(true);
                            } else {
                                ((AbstractSpaceProxy)this.parameters.repSpace).getRemoteSpace().clear(null, null);
                                ((AbstractSpaceProxy)this.parameters.repSpace).getLocalSpace().clear(null, null);
                            }
                        }
                    }
                }
                if (args.containsKey(KEY_TX)) {
                    if (args.get(KEY_TX).equals("")) {
                        this.parameters.isSingleTransaction = true;
                        this.parameters.txIterations = this.parameters.numberOfIterations;
                    } else {
                        this.parameters.txIterations = Integer.parseInt((String)args.get(KEY_TX));
                    }
                    this.parameters.transactionType = 1;
                    if (this.distributedTransactionManagerProvider == null) {
                        this.distributedTransactionManagerProvider = new DistributedTransactionManagerProvider();
                    }
                    this.parameters.spaceTransactionManager = this.distributedTransactionManagerProvider.getTransactionManager();
                    if (this.parameters.repSpace != null) {
                        this.parameters.repSpaceTransactionManager = this.distributedTransactionManagerProvider.getTransactionManager();
                    }
                }
                if (args.containsKey(KEY_STRESS)) {
                    this.parameters.stressRepeatTimes = Integer.parseInt((String)args.get(KEY_STRESS));
                    this.parameters.isStress = true;
                }
                if (args.containsKey(KEY_PAUSE) && !this.doneFirstCycle) {
                    System.out.println("\n[ Benchmark Paused ] - Connection with space established, press any key to continue...\n");
                    System.in.read();
                }
                if (!args.containsKey(KEY_DTX)) break block143;
                if (args.get(KEY_DTX).equals("")) {
                    this.parameters.isSingleTransaction = true;
                    this.parameters.txIterations = this.parameters.numberOfIterations;
                } else {
                    this.parameters.txIterations = Integer.parseInt((String)args.get(KEY_DTX));
                }
                String dtxManagerHostName = null;
                if (args.containsKey(KEY_DTX_MANAGER_URL)) {
                    dtxManagerHostName = (String)args.get(KEY_DTX_MANAGER_URL);
                }
                try {
                    this.parameters.spaceTransactionManager = this.findTransactionManager(dtxManagerHostName);
                    this.parameters.transactionType = (short)2;
                    if (this.parameters.repSpace != null) {
                        this.parameters.repSpaceTransactionManager = this.parameters.spaceTransactionManager;
                    }
                }
                catch (Throwable e) {
                    String message = "Distributed Transaction Manager (Mahalo) can not be found.\nCheck if Distributed Transaction Manager is running on <" + dtxManagerHostName + "> or use Local Transaction instead.";
                    this.say(message);
                    if (benchmarkOutput != null) {
                        benchmarkOutput.showException(message + "\n", e.toString(), e);
                    }
                    if (!this.parameters.isGUI) {
                        System.exit(-1);
                    }
                    return false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.parameters.isGUI) break block143;
                System.exit(-1);
            }
        }
        if (this.parameters.space != null) {
            this.parameters.space.setOptimisticLocking(false);
        }
        return true;
    }

    private TransactionManager findTransactionManager(String hostName) throws FinderException {
        LookupRequest request = LookupRequest.TransactionManager().setLocators(hostName).setTimeout(15000L);
        TransactionManager transactionManager = (TransactionManager)LookupFinder.find((LookupRequest)request);
        return transactionManager;
    }

    public byte[] getObjectByteSize() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(outStream);
        MessageAdaptor adaptor = MessageAdaptors.getByCode(this.parameters.messageType);
        Object entry = adaptor.create(25000L, this.parameters.messageBuf);
        out.writeObject(entry);
        byte[] byteObj = outStream.toByteArray();
        out.close();
        outStream.close();
        return byteObj;
    }

    public void printConfigurationMessages(Map args) throws Exception {
        this.say("|");
        this.say("|\t" + PlatformVersion.getOfficialVersion());
        this.say("|\t@version: 0.2");
        this.say("|\n");
        this.say("benchmark parameters: " + args);
        this.say("use -h for more benchmark parameters.\n");
        if (this.isAll) {
            this.say("This Test will perform " + this.firstOperation + ", " + this.secondOperation + " and " + this.thirdOperation);
        } else if (this.parameters.isOnly) {
            if (this.theOnlyOperation == 1) {
                this.say("This Test will perform " + this.mode + PADD + this.firstOperation);
            } else {
                this.say("This Test will perform " + this.mode + PADD + this.secondOperation);
            }
        } else {
            this.say("This Test will perform " + this.mode + PADD + this.firstOperation + " and " + this.secondOperation);
        }
        this.say("MASTER SPACE URL: " + this.parameters.spaceURL);
        if (this.isUseDCache) {
            this.say("USING Master-Local Cache WITH " + this.parameters.space.getName() + " Space");
        }
        if (this.useReplicationSpace) {
            this.say("REPLICA SPACE URL: " + this.parameters.repSpaceURL);
            if (this.isUseDCache) {
                this.say("USING Master-Local Cache WITH " + this.parameters.repCache.getMasterSpace().getName() + " Space");
            }
        }
        String timeout = String.valueOf(this.parameters.timeout) + " milliseconds";
        String lease = "FOREVER";
        if (this.parameters.lease != Long.MAX_VALUE) {
            lease = String.valueOf(this.parameters.lease) + " milliseconds";
        }
        if (!this.parameters.isParallel) {
            this.say("SEQUENTIAL EXECUTION");
        } else {
            this.say("PARALLEL EXECUTION");
        }
        MessageAdaptor adaptor = MessageAdaptors.getByCode(this.parameters.messageType);
        if (adaptor.isFifo()) {
            this.say("FIFO mode");
        }
        if (this.theOnlyOperation == 1) {
            if (this.parameters.isBench) {
                this.say("EXECUTING BENCH OPERATIONS");
            } else {
                this.say("EXECUTING ONLY FIRST OPERATION");
            }
        } else if (this.theOnlyOperation == 2) {
            this.say("EXECUTING ONLY SECOND OPERATION");
        } else {
            this.say("EXECUTING BOTH OPERATIONS");
        }
        this.say("TIMEOUT: " + timeout);
        this.say("LEASE: " + lease);
        this.say("BUFFERSIZE: " + this.parameters.messageLength + " bytes");
        byte[] entry = this.getObjectByteSize();
        this.say("APPROXIMATE ENTRY SIZE: " + entry.length + " bytes");
        if (this.parameters.firstOpRange || this.parameters.secondOpRange) {
            if (this.parameters.firstOpRange) {
                this.say("RANGE:\tFIRST OPERATION - FROM: " + this.parameters.firstOpRangeFrom + " TO: " + this.parameters.firstOpRangeTo + " , ITERATIONS: " + (this.parameters.firstOpRangeTo - this.parameters.firstOpRangeFrom));
            }
            if (this.parameters.secondOpRange) {
                this.say("RANGE:\tSECONDS OPERATION - FROM: " + this.parameters.secondOpRangeFrom + " TO: " + this.parameters.secondOpRangeTo + " , ITERATIONS: " + (this.parameters.secondOpRangeTo - this.parameters.secondOpRangeFrom));
            }
        } else {
            this.say("ITERATIONS: " + this.parameters.numberOfIterations);
        }
        if (this.parameters.writeRepeatTimes > 1L) {
            this.say("FIRST OPERTATION REPEATS: " + this.parameters.writeRepeatTimes + " TIMES");
        }
        if (this.parameters.readRepeatTimes > 1L) {
            this.say("SECOND OPERTATION REPEATS: " + this.parameters.readRepeatTimes + " TIMES");
        }
        if (this.parameters.isRandom) {
            this.say("RANDOM ITERATIONS: " + this.parameters.numberOfRandomIterations);
        }
        if (this.parameters.isSingleTransaction) {
            this.say("SINGLE TRANSACTION");
        }
        if (this.parameters.txIterations != 0) {
            this.say("TRANSACTION COMMIT EVERY " + this.parameters.txIterations + " ITERATIONS");
        }
        this.say("NUMBER OF THREADS: " + this.parameters.threadCount + " for each operation");
        if ((String)args.get(KEY_MESSAGE_TYPE) != null) {
            this.say("USING: " + (String)args.get(KEY_MESSAGE_TYPE));
        }
        if (this.parameters.isGlobalThroughput) {
            this.say("DISPLAY TP EVERY " + this.parameters.globalThroughputIterations + " ITERATIONS");
        }
        if (this.parameters.isMultiple) {
            this.say("NUMBER OF BATCHES: " + this.parameters.numOfBatches);
            this.say("BATCH SIZE: " + this.parameters.batchAmount);
        }
        if (this.isWriteDelay) {
            this.say(this.firstOperation + " DELAY: " + this.parameters.delayWrite + " milliseconds");
        }
        if (this.isReadTakeDelay) {
            this.say(this.secondOperation + "  DELAY: " + this.parameters.delayReadTake + " milliseconds");
        }
        if (this.parameters.isWriteRate) {
            this.say(this.firstOperation + " RATE: " + this.parameters.writeRate + " msg/sec");
        }
        if (this.isMap) {
            this.say("USING MAP API");
            if (this.isExtEntry) {
                this.say("USING MAP API with ExternalEntry");
            }
        }
        if (this.parameters.isStress) {
            this.say("STRESS REPEATS : " + (this.stressCycle + 1) + " out of " + this.parameters.stressRepeatTimes + " TIMES");
        }
        if (args.containsKey(KEY_FILE)) {
            this.say("RESULT FILE: " + this.resultFileName);
        }
        this.say("");
    }

    public void printTotalTestTime() {
        long totalTestTime = this.finalTestTime - this.initialTestTime;
        this.say("TOTAL TEST TIME = " + totalTestTime + " milliseconds");
    }

    private ThroughputWrapper printAllOutput(String operation, ArrayList operationTimes, long iterations) {
        double operationAverageTotalTime = 0.0;
        long threadOperationTime = 0L;
        DecimalFormat benchFormat = new DecimalFormat("0.000");
        double totalThroughput = 0.0;
        double totalThroughput_MB = 0.0;
        double averageThroughput = 0.0;
        BenchmarkTestResult.Result result = this.benchTestResult.buildResult(operation);
        for (int threadNumber = 0; threadNumber < this.parameters.threadCount; ++threadNumber) {
            threadOperationTime = (Long)operationTimes.get(threadNumber);
            double threadThroughput = 1000.0 * (double)iterations / (double)threadOperationTime;
            totalThroughput += threadThroughput;
            this.say(operation + PADD + this.mode + " for thread " + threadNumber + ": TP = " + benchFormat.format(threadThroughput) + " msg/sec , TEST TIME = " + threadOperationTime + " ms");
            operationAverageTotalTime += (double)threadOperationTime;
            result.addThreadResult(threadThroughput, threadOperationTime);
        }
        this.say("----------------- " + operation + PADD + this.mode + " SUMMARY ---------------------");
        String operationAverageTotalTimeStr = benchFormat.format(operationAverageTotalTime /= (double)this.parameters.threadCount);
        this.say(operation + PADD + this.mode + " AVG   TEST TIME  for all threads = " + operationAverageTotalTimeStr + " ms");
        result.setAverageDuration(operationAverageTotalTime);
        averageThroughput = totalThroughput / (double)this.parameters.threadCount;
        String averageThroughputStr = benchFormat.format(averageThroughput);
        this.say(operation + PADD + this.mode + " AVG   TP for all threads = " + averageThroughputStr + " msg/sec");
        result.setAverageThroughput(averageThroughput);
        totalThroughput_MB = totalThroughput * (double)this.parameters.messageBuf.length / 1048576.0;
        String totalThroughputStr = benchFormat.format(totalThroughput);
        this.say(operation + PADD + this.mode + " TOTAL TP for all threads = " + totalThroughputStr + " msg/sec , " + benchFormat.format(totalThroughput_MB) + " MB/sec");
        result.setTotalThroughput(totalThroughput);
        this.say("-------------------------------------------------------------\n");
        return new ThroughputWrapper(operationAverageTotalTime, averageThroughput, totalThroughput);
    }

    public void computeAveragePerformanceTime() throws IOException {
        this._firstOperationAverageTotalTime = 0.0;
        this._secondOperationAverageTotalTime = 0.0;
        this._thirdOperationAverageTotalTime = 0.0;
        this._firstAverageThroughput = 0.0;
        this._secondAverageThroughput = 0.0;
        this._thirdAverageThroughput = 0.0;
        this._firstTotalThroughput = 0.0;
        this._secondTotalThroughput = 0.0;
        this._thirdTotalThroughput = 0.0;
        long threadFirstOperationTime = 0L;
        long threadSecondOperationTime = 0L;
        DecimalFormat benchFormat = new DecimalFormat("0.000");
        double firstTotalThroughput_MB = 0.0;
        double secondTotalThroughput_MB = 0.0;
        double threadThroughput = 0.0;
        double threadThroughputWFCycle = 0.0;
        double threadFirstOperationTimeWFCycle = 0.0;
        double threadSecondOperationTimeWFCycle = 0.0;
        double firstTotalThroughputWFCycle = 0.0;
        double firstAverageThroughputWFCycle = 0.0;
        double firstTotalThroughputWFCycle_MB = 0.0;
        double secondTotalThroughputWFCycle = 0.0;
        double secondAverageThroughputWFCycle = 0.0;
        double secondTotalThroughputWFCycle_MB = 0.0;
        long iterations = this.parameters.numberOfIterations;
        if (this.isAll) {
            ThroughputWrapper throughputWrapper;
            if (this._isFirstOperationInitialized) {
                throughputWrapper = this.printAllOutput(this.firstOperation, this.firstOperationTimeOfEachTread, this.parameters.firstOpRangeTo - this.parameters.firstOpRangeFrom);
                this._firstOperationAverageTotalTime = throughputWrapper.getOperationAverageTotalTime();
                this._firstAverageThroughput = throughputWrapper.getAverageThroughput();
                this._firstTotalThroughput = throughputWrapper.getTotalThroughput();
            }
            if (this._isSecondOperationInitialized) {
                throughputWrapper = this.printAllOutput(this.secondOperation, this.secondOperationTimeOfEachThread, this.parameters.secondOpRangeTo - this.parameters.secondOpRangeFrom);
                this._secondOperationAverageTotalTime = throughputWrapper.getOperationAverageTotalTime();
                this._secondAverageThroughput = throughputWrapper.getAverageThroughput();
                this._secondTotalThroughput = throughputWrapper.getTotalThroughput();
            }
            if (this._isThirdOperationInitialized) {
                throughputWrapper = this.printAllOutput(this.thirdOperation, this.thirdOperationTimeOfEachThread, this.parameters.secondOpRangeTo - this.parameters.secondOpRangeFrom);
                this._thirdOperationAverageTotalTime = throughputWrapper.getOperationAverageTotalTime();
                this._thirdAverageThroughput = throughputWrapper.getAverageThroughput();
                this._thirdTotalThroughput = throughputWrapper.getTotalThroughput();
            }
        } else {
            BenchmarkTestResult.Result result;
            if (this.theOnlyOperation != 2) {
                result = this.benchTestResult.buildResult(this.firstOperation);
                iterations = this.parameters.firstOpRangeTo - this.parameters.firstOpRangeFrom;
                for (int threadNumber = 0; threadNumber < this.parameters.threadCount; ++threadNumber) {
                    if (this.parameters.writeRepeatTimes > 1L) {
                        threadFirstOperationTimeWFCycle = this.firstOperationTimeOfEachThreadWFCycle.get(threadNumber).longValue();
                        threadThroughputWFCycle = (double)(1000L * iterations * (this.parameters.writeRepeatTimes - 1L)) / threadFirstOperationTimeWFCycle;
                        firstTotalThroughputWFCycle += threadThroughputWFCycle;
                    }
                    if (threadNumber >= this.firstOperationTimeOfEachTread.size() || (threadFirstOperationTime = this.firstOperationTimeOfEachTread.get(threadNumber).longValue()) == 0L) continue;
                    threadThroughput = 1000.0 * (double)iterations / (double)threadFirstOperationTime;
                    this._firstTotalThroughput += threadThroughput;
                    this.say(this.firstOperation + PADD + this.mode + " for thread " + threadNumber + ": TP = " + benchFormat.format(threadThroughput) + " msg/sec , TEST TIME = " + threadFirstOperationTime + " ms");
                    result.addThreadResult(threadThroughput, threadFirstOperationTime);
                    this._firstOperationAverageTotalTime += (double)threadFirstOperationTime;
                }
                this._firstOperationAverageTotalTime /= (double)this.parameters.threadCount;
                this.say("----------------- " + this.firstOperation + PADD + this.mode + " SUMMARY ---------------------");
                this.say(this.firstOperation + PADD + this.mode + " AVG   TEST TIME  for all threads = " + benchFormat.format(this._firstOperationAverageTotalTime) + " ms");
                result.setAverageDuration(this._firstOperationAverageTotalTime);
                this._firstAverageThroughput = this._firstTotalThroughput / (double)this.parameters.threadCount;
                this.say(this.firstOperation + PADD + this.mode + " AVG   TP for all threads = " + benchFormat.format(this._firstAverageThroughput) + " msg/sec");
                result.setAverageThroughput(this._firstAverageThroughput);
                if (this.parameters.writeRepeatTimes > 1L) {
                    firstAverageThroughputWFCycle = firstTotalThroughputWFCycle / (double)this.parameters.threadCount;
                    this.say(this.firstOperation + PADD + this.mode + " AVG   TP WITHOUT FIRST CYCLE for all threads = " + benchFormat.format(firstAverageThroughputWFCycle) + " msg/sec");
                }
                firstTotalThroughput_MB = this._firstTotalThroughput * (double)this.parameters.messageBuf.length / 1048576.0;
                this.say(this.firstOperation + PADD + this.mode + " TOTAL TP for all threads = " + benchFormat.format(this._firstTotalThroughput) + " msg/sec , " + benchFormat.format(firstTotalThroughput_MB) + " MB/sec");
                result.setTotalThroughput(this._firstTotalThroughput);
                if (this.parameters.writeRepeatTimes > 1L) {
                    firstTotalThroughputWFCycle_MB = firstTotalThroughputWFCycle * (double)this.parameters.messageBuf.length / 1048576.0;
                    this.say(this.firstOperation + PADD + this.mode + " TOTAL TP WITHOUT FIRST CYCLE for all threads = " + benchFormat.format(firstTotalThroughputWFCycle) + " msg/sec , " + benchFormat.format(firstTotalThroughputWFCycle_MB) + " MB/sec");
                }
                this.say("-------------------------------------------------------------\n");
            }
            if (this.parameters.isRandom) {
                iterations = this.parameters.numberOfRandomIterations;
            }
            iterations = this.parameters.secondOpRangeTo - this.parameters.secondOpRangeFrom;
            if (this.theOnlyOperation != 1) {
                result = this.benchTestResult.buildResult(this.secondOperation);
                int secondOperationListSize = this.secondOperationTimeOfEachThreadWFCycle.size();
                for (int threadNumber = 0; threadNumber < this.parameters.threadCount; ++threadNumber) {
                    if (this.parameters.readRepeatTimes > 1L && threadNumber < secondOperationListSize) {
                        threadSecondOperationTimeWFCycle = this.secondOperationTimeOfEachThreadWFCycle.get(threadNumber).longValue();
                        threadThroughputWFCycle = (double)(1000L * iterations * (this.parameters.readRepeatTimes - 1L)) / threadSecondOperationTimeWFCycle;
                        secondTotalThroughputWFCycle += threadThroughputWFCycle;
                    }
                    if (threadNumber >= this.secondOperationTimeOfEachThread.size()) continue;
                    threadSecondOperationTime = this.secondOperationTimeOfEachThread.get(threadNumber);
                    if (threadSecondOperationTime != 0L) {
                        threadThroughput = 1000.0 * (double)iterations * (double)this.parameters.readRepeatTimes / (double)threadSecondOperationTime;
                    }
                    this._secondTotalThroughput += threadThroughput;
                    this.say(this.secondOperation + PADD + this.mode + " for thread " + threadNumber + ": TP = " + benchFormat.format(threadThroughput) + " msg/sec , TEST TIME = " + threadSecondOperationTime + " ms");
                    result.addThreadResult(threadThroughput, threadSecondOperationTime);
                    this._secondOperationAverageTotalTime += (double)threadSecondOperationTime;
                }
                this._secondOperationAverageTotalTime /= (double)this.parameters.threadCount;
                this.say("----------------- " + this.secondOperation + PADD + this.mode + " SUMMARY ---------------------");
                this.say(this.secondOperation + PADD + this.mode + " AVG   TEST TIME  for all threads = " + benchFormat.format(this._secondOperationAverageTotalTime) + " ms");
                result.setAverageDuration(this._secondOperationAverageTotalTime);
                this._secondAverageThroughput = this._secondTotalThroughput / (double)this.parameters.threadCount;
                this.say(this.secondOperation + PADD + this.mode + " AVG   TP for all threads = " + benchFormat.format(this._secondAverageThroughput) + " msg/sec");
                result.setAverageThroughput(this._secondAverageThroughput);
                if (this.parameters.readRepeatTimes > 1L) {
                    secondAverageThroughputWFCycle = secondTotalThroughputWFCycle / (double)this.parameters.threadCount;
                    this.say(this.secondOperation + PADD + this.mode + " AVG   TP WITHOUT FIRST CYCLE for all threads = " + benchFormat.format(secondAverageThroughputWFCycle) + " msg/sec");
                }
                secondTotalThroughput_MB = this._secondTotalThroughput * (double)this.parameters.messageBuf.length / 1048576.0;
                this.say(this.secondOperation + PADD + this.mode + " TOTAL TP for all threads = " + benchFormat.format(this._secondTotalThroughput) + " msg/sec , " + benchFormat.format(secondTotalThroughput_MB) + " MB/sec");
                result.setTotalThroughput(this._secondTotalThroughput);
                if (this.parameters.readRepeatTimes > 1L) {
                    secondTotalThroughputWFCycle_MB = secondTotalThroughputWFCycle * (double)this.parameters.messageBuf.length / 1048576.0;
                    this.say(this.secondOperation + PADD + this.mode + " TOTAL TP WITHOUT FIRST CYCLE for all threads = " + benchFormat.format(secondTotalThroughputWFCycle) + " msg/sec , " + benchFormat.format(secondTotalThroughputWFCycle_MB) + " MB/sec");
                }
                this.say("-------------------------------------------------------------\n");
            }
        }
    }

    public void retrieveOperationTimeOfEachTread() {
        this.firstOperationTimeOfEachTread = new ArrayList();
        this.firstOperationTimeOfEachThreadWFCycle = new ArrayList();
        this.secondOperationTimeOfEachThread = new ArrayList();
        this.secondOperationTimeOfEachThreadWFCycle = new ArrayList();
        this.thirdOperationTimeOfEachThread = new ArrayList();
        int i = 1;
        for (Operation op : this.threads.values()) {
            if (op != null) {
                long valueWFCycle;
                long value = op.getResultTime();
                if (i <= this.parameters.threadCount && this.theOnlyOperation != 2) {
                    this.firstOperationTimeOfEachTread.add(value);
                    if (this.parameters.writeRepeatTimes > 1L) {
                        valueWFCycle = op.getResultTimeWFCycle();
                        this.firstOperationTimeOfEachThreadWFCycle.add(valueWFCycle);
                    }
                } else if (i <= this.parameters.threadCount * 2) {
                    this.secondOperationTimeOfEachThread.add(value);
                    if (this.parameters.readRepeatTimes > 1L) {
                        valueWFCycle = op.getResultTimeWFCycle();
                        this.secondOperationTimeOfEachThreadWFCycle.add(valueWFCycle);
                    }
                } else {
                    this.thirdOperationTimeOfEachThread.add(value);
                }
            }
            ++i;
        }
    }

    public void doPerformanceTest() throws InterruptedException {
        int first = 0;
        int last = this.parameters.threadCount;
        this.countEntries();
        this.initialTestTime = System.currentTimeMillis();
        boolean twoOperations = false;
        if (this.isAll && !this.parameters.isParallel) {
            this.say("Initializing " + this.firstOperation + PADD + this.mode + " threads...");
            this.createFirstOperationThreads();
            this.say("Starting     " + this.firstOperation + PADD + this.mode + " threads...");
            this.startThreads(0, this.parameters.threadCount);
            this.say("Running      " + this.firstOperation + PADD + this.mode + " threads...");
            this.joinThreads(0, this.parameters.threadCount);
            this.say("Initializing " + this.secondOperation + PADD + this.mode + " threads...");
            this.createSecondOperationThreads(twoOperations);
            this.say("Starting     " + this.secondOperation + PADD + this.mode + " threads...");
            this.startThreads(this.parameters.threadCount, this.parameters.threadCount * 2);
            this.say("Running      " + this.secondOperation + PADD + this.mode + " threads...");
            this.joinThreads(this.parameters.threadCount, this.parameters.threadCount * 2);
            this.say("Initializing " + this.thirdOperation + PADD + this.mode + " threads...");
            this.createThirdOperationThreads();
            this.say("Starting     " + this.thirdOperation + PADD + this.mode + " threads...");
            this.startThreads(this.parameters.threadCount * 2, this.parameters.threadCount * 3);
            this.say("Running      " + this.thirdOperation + PADD + this.mode + " threads...");
            this.joinThreads(this.parameters.threadCount * 2, this.parameters.threadCount * 3);
        } else if (!this.parameters.isParallel) {
            if (this.theOnlyOperation != 2) {
                this.say("Initializing " + this.firstOperation + PADD + this.mode + " threads...");
                this.createFirstOperationThreads();
                twoOperations = true;
                this.say("Starting     " + this.firstOperation + PADD + this.mode + " threads...");
                this.startThreads(0, this.parameters.threadCount);
                this.say("Running      " + this.firstOperation + PADD + this.mode + " threads...");
                this.joinThreads(0, this.parameters.threadCount);
            }
            if (this.theOnlyOperation != 1) {
                if (this.theOnlyOperation == 0) {
                    first = this.parameters.threadCount;
                    last = this.parameters.threadCount * 2;
                }
                this.say("Initializing " + this.secondOperation + PADD + this.mode + " threads...");
                this.createSecondOperationThreads(twoOperations);
                this.say("Starting     " + this.secondOperation + PADD + this.mode + " threads...");
                this.startThreads(first, last);
                this.say("Running      " + this.secondOperation + PADD + this.mode + " threads...");
                this.joinThreads(first, last);
            }
        } else if (!this.isAll) {
            this.say("Initializing " + this.firstOperation + PADD + this.mode + " threads...");
            this.createFirstOperationThreads();
            this.say("Initializing " + this.secondOperation + PADD + this.mode + " threads...");
            this.createSecondOperationThreads(twoOperations);
            this.say("Starting     " + this.firstOperation + " and " + this.secondOperation + PADD + this.mode + " threads...");
            this.startThreads(0, this.parameters.threadCount * 2);
            this.say("Running      " + this.firstOperation + " and " + this.secondOperation + PADD + this.mode + " threads...");
            this.joinThreads(0, this.parameters.threadCount * 2);
        } else {
            this.say("Initializing " + this.firstOperation + PADD + this.mode + " threads...");
            this.createFirstOperationThreads();
            this.say("Initializing " + this.secondOperation + PADD + this.mode + " threads...");
            this.createSecondOperationThreads(twoOperations);
            this.say("Initializing " + this.thirdOperation + PADD + this.mode + " threads...");
            this.createThirdOperationThreads();
            this.say("Starting     " + this.firstOperation + ", " + this.secondOperation + " and " + this.thirdOperation + PADD + this.mode + " threads...");
            this.startThreads(0, this.parameters.threadCount * 3);
            this.say("Running      " + this.firstOperation + ", " + this.secondOperation + " and " + this.thirdOperation + PADD + this.mode + " threads...");
            this.joinThreads(0, this.parameters.threadCount * 3);
        }
        this.finalTestTime = System.currentTimeMillis();
        this.countEntries();
        this.retrieveOperationTimeOfEachTread();
    }

    private void closeObjects() {
        for (Operation operation : this.threads.values()) {
            if (operation instanceof Notify) {
                ((Notify)operation).close();
                continue;
            }
            if (!(operation instanceof JMSNotify)) continue;
            ((JMSNotify)operation).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Map args, PrintWriter out, IJSpace theSpace, IMap theCache, BenchmarkOutput benchmarkOutput) throws BenchmarkCommandException {
        if (this.initInputConfigurationParameters(args, out, theSpace, theCache, benchmarkOutput)) {
            try {
                this.printConfigurationMessages(args);
                if (this.isParametersValid()) {
                    this.doPerformanceTest();
                    this.computeAveragePerformanceTime();
                    this.printTotalTestTime();
                    if (this.resultFileName != null) {
                        BenchmarkCommandReport report = new BenchmarkCommandReport(this);
                        report.outDebugInfo(this.resultFileName);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.benchTestResult.setException(ex);
                boolean bl = true;
                return bl;
            }
            finally {
                this.closeObjects();
            }
        }
        return this.parameters.isExit;
    }

    private boolean isParametersValid() {
        if (this.parameters.isMultiple && this.isMap) {
            this.say(JSpaceUtilities.LINE_SEPARATOR + "Multiple operation is not supported for Space Map API." + JSpaceUtilities.LINE_SEPARATOR);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(Map args, PrintWriter out) throws BenchmarkCommandException {
        return this.execute(args, out, null, null, this.benchmarkOutput);
    }

    public void cleanJavaSpace(IJSpace space) throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        while (space.take(null, null, Long.MAX_VALUE) != null) {
        }
    }

    public void printConfig(PrintStream ps) {
        try {
            ps.println("Space Config Info\t");
            ps.print("---------------------------\t");
            IJSpace space = (IJSpace)SpaceFinder.find((String)this.parameters.spaceURL);
            IRemoteJSpaceAdmin admin = (IRemoteJSpaceAdmin)space.getAdmin();
            SpaceConfig config = admin.getConfig();
            ClusterPolicy clusterPolicy = admin.getClusterPolicy();
            String configStr = "";
            configStr = configStr + "\nPersistent:\t" + config.isPersistent();
            configStr = configStr + "\nserializationType:\t" + config.getSerializationType();
            configStr = configStr + "\nMemoryUsageEnabled:\t" + config.isEngineMemoryUsageEnabled();
            configStr = configStr + "\nisClustered:\t" + config.isClustered();
            configStr = configStr + "\ncachePolicy :\t" + config.getCachePolicy();
            if (Boolean.valueOf(config.isClustered()).booleanValue()) {
                configStr = configStr + "\nReplicationChunkSize:\t" + clusterPolicy.m_ReplicationPolicy.m_ReplicationChunkSize;
                configStr = configStr + "\nReplicationIntervalMillis:\t" + clusterPolicy.m_ReplicationPolicy.m_ReplicationIntervalMillis;
                configStr = configStr + "\nReplicationIntervalOperations:\t" + clusterPolicy.m_ReplicationPolicy.m_ReplicationIntervalOperations;
                configStr = configStr + "\nSyncOnCommit:\t" + clusterPolicy.m_ReplicationPolicy.m_SyncOnCommit;
                configStr = configStr + "\nReliable:\t" + clusterPolicy.m_ReplicationPolicy.isReliableAsyncRepl();
            }
            ps.println(configStr + "\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void usage(PrintWriter out) {
        MessageAdaptor[] adaptors;
        System.out.println("\n\n-------------------------------------------------------");
        System.out.println("\t GigaSpaces Benchmark v0.2 Help");
        System.out.println("\n-------------------------------------------------------\n\n");
        System.out.println("Usage: BenchmarkTest [space url] <options>");
        System.out.println("where 'space url' is in the form of protocol://[host]:<port>/[container name]/[space name]\n");
        System.out.println("Option arguments in square brackets [] are required;\nOption arguments in triangular brackets <> are optional.\n");
        System.out.println("\nSetup:");
        System.out.println("---------");
        String adaptorsUsage = "";
        for (MessageAdaptor adaptor : adaptors = MessageAdaptors.getMessageAdaptors()) {
            adaptorsUsage = adaptorsUsage + TAB + adaptor.getName() + " - " + adaptor.getDescription() + "\n" + adaptor.getUsageInfo() + "\n\n";
        }
        this.addUsage("-objecttype", "Defines the object type that will be written to the space. \n\tUsage: -objecttype " + MessageAdaptors.getByCode((short)1).getName() + "\n\n\tOther possible values are: \n\n  " + adaptorsUsage);
        this.addUsage("-clean", "Clean space before benchmark starts");
        this.addUsage("-url [url]", "Connection url; If none provided the one defined as part of the script file will be used");
        this.addExample("-url", "-url jini://localhost/container/space", "protocol://[host]:<port>/[container name]/[space name]");
        this.addUsage("-f [FileName]", "dump results into file. Works with -showrate option. Default File name is BenchMarkResult{Date}_{Time}.");
        this.addExample("-f", "-f resultsfile.xsl -showrate", "dump results into resultsfile.xsl");
        this.addUsage("-pause", "Pauses once connection with space is established.");
        this.addUsage("-exit", "Benchmark will hang once finished. When used with embedded space, space will still be alive.");
        this.showUsage();
        System.out.println("\nOperations:");
        System.out.println("-------------");
        this.addUsage("-write", "perform first operation as write/put");
        this.addUsage("-read", "perform second operation as read/get");
        this.addUsage("-update", "perform second operation as update (with uid)");
        this.addUsage("-take", "perform second/third operation as take/remove");
        this.addUsage("-all", "perform all operations - first, second and then third");
        this.addUsage("-execute [ first/second ]", "enables execution of only first or second operation.");
        this.addExample("-execute", "-execute first", "will perform only write/put operations");
        this.addExample("-execute", "-execute second", "will perform only read operations");
        this.addExample("-execute", "-execute second -take", "will perform only take operations");
        this.addUsage("-bench", "perform first-*second-second-third operation with uid");
        this.addExample("-bench", "-bench -map", "will perform put,put(update),get,remove with uid");
        this.addExample("-bench", "-bench", "will perform write,update,read,take with uid");
        this.showUsage();
        System.out.println("\nOptions:");
        System.out.println("----------");
        this.addUsage("-i <number of iterations>", "number of iterations; default is 1000");
        this.addUsage("-lease [time in ms]", "lease timeout in milliseconds of the write/put operation");
        this.addExample("-lease", "-i 1000 -lease 20000 -execute first", "perform 1st operation with entry lease of 2 sec");
        this.addUsage("-t [time in ms]", "timeout in milliseconds of the read/take/get/remove operations");
        this.addExample("-t", "-i 1000 -t 20000 -execute second", "perform 2nd operation with timeout of 2 sec");
        this.addUsage("-s [size in bytes]", "set byte size of the entry object.");
        this.addExample("-s", "-s 1000", "define 1K size entries each");
        this.addUsage("-content", "changes the content value each iteration");
        this.addExample("-content", "-i 1000 -content -s 1000", "defines an entry with a changing content of 1K");
        this.addUsage("-tr [number of threads]", "number of threads performing each operation");
        this.addExample("-tr", "-i 1000 -tr 4", "will perform 1000 iterations by each of the 4 threads");
        this.addUsage("-rangefirst [from-to]", "will perform first operation with ids/keys between range");
        this.addExample("-rangefirst", "-rangefirst 1000-2000", "will write/put ids/keys from 1000 to 2000");
        this.addUsage("-rangesecond [from-to]", "will perform second operation with ids/keys between range");
        this.addExample("-rangesecond", "-rangesecond 1000-2000", "will read/take/get/remove ids/keys from 1000 to 2000");
        this.addUsage("-repeatfirst [repeats]", "repeat times of first operation");
        this.addExample("-repeatfirst", "-i 1000 -repeatfirst 10", "will write/put 10 times 1000 entries");
        this.addUsage("-repeatsecond [repeats]", "repeat times of second operation");
        this.addExample("-repeatsecond", "-i 1000 -repeatsecond 10", "will read/get or take/remove 10 times 1000 entries");
        this.addUsage("-m [batch size]", "specifies the batch size when performing batch operations");
        this.addExample("-m", "-m 100 -i 1000", "will use 10 batches of 100 to perform operations on 1000 entries.");
        this.addUsage("-rand <number of iterations>", "will randomize second operation ids/keys in a range; default is by -i");
        this.addExample("-rand", "-i 1000 -rand", "will randomize second operation ids/keys from 0 to 1000");
        this.addExample("-rand", "-i 10000 -rand 40000", "will randomize between ids/keys in the range of 0-40000");
        this.addExample("-rand", "-rangesecond 10000-25000 -rand", "will randomize between 10000-25000");
        this.addUsage("-tx [nth-iteration]", "tx will be committed every nth-iteration; if zero, as specified by -i");
        this.addUsage("-delaywrite [t ms]", "delays first operation every t milliseconds");
        this.addUsage("-delayreadtake [t ms]", "delays second & third operation every t milliseconds");
        this.addUsage("-writerate [Max Rate msg/sec]", "will limit the first operation rate (msg in 1 second) for all threads");
        this.addExample("-writerate", "-i 100000 -writerate 50000 -tr 4", "4 threads will write 100000 entries each with a maximum TP rate of 50000 msg/sec");
        this.addUsage("-notify", "registers for notifications on all events");
        this.addExample("-notify", "-notify -i 1000 -tr 5", "will start 5 threads that will write and notify 1000 entries");
        this.addUsage("-parallel", "parallel execution of the operations");
        this.addExample("-parallel", "-parallel -i 1000 -tr 5", "will start 5 parallel threads, each performing 1000 operations");
        this.addUsage("-usesinglespace", "This parameter indicates if operation will be performed using a single direct space proxy (and not clustered proxy) ");
        this.addExample("-usesinglespace", "-usesinglespace -i 100000", "will write 100000 objects to specific single cluster space");
        this.addUsage("-returnlease", "This parameter indicates if write operation will return a lease object");
        this.addExample("-returnlease", "-returnlease -i 100000", "will write 100000 objects with returning Lease object");
        this.showUsage();
        System.out.println("\nTransactions:");
        System.out.println("--------------");
        this.addUsage("-tx 2000 ", "Perform operation under local transaction, commit every 2000 operations.");
        this.addUsage("-dtx 1000 ", "Perform operation under distributed transaction, commit every 1000 operations.");
        this.addExample("-dtx-manager-url", "-dtx 1000 dtx-manager-url thunder1:3733", "Use distributed transaction. Commit every 1000 operations.Transaction Manager registered on LUS that is running on machine thunder1:3733");
        this.showUsage();
        System.out.println("\nTopologies:");
        System.out.println("-------------");
        this.addUsage("-cache", "Turn on local cache mode; default is false");
        this.addExample("-cache", "-cache", "will use local cache to remote space.");
        this.addUsage("-map", "Map API - first/second/third operations as: put, get, remove.");
        this.addExample("-map", "-map -all -i 1000", "will put/get/remove 1000 entries.");
        this.addUsage("-map -cache", "Map API with local cache.");
        this.addExample("-map", "-map -cache -i 1000 -repeatsecond 4", "will put 1000 entries, first get from space, successive gets from local cache.");
        this.addUsage("-target [space name]", "Space name to perform second operations on (in a cluster configuration)");
        this.addExample("-target", "-target jini://host:port/container/space_name", "will perform second operation this target space");
        this.addUsage("-hashtable", "use java.util.Hashtable API-  first/second/third operations as: put,get, remove");
        this.showUsage();
        System.out.println("\nStatistics:");
        System.out.println("-------------");
        this.addUsage("-showrate <iteration cycle>", "global throughput will be displayed every iteration cycle; default is 1000");
        this.addExample("-showrate", "-showrate 10000", "will show TP every 10000 iterations");
        this.addUsage("-showthreadrate <iteration cycle>", "thread throughput will be displayed every iteration cycle; default is 1000");
        this.addExample("-showthreadrate", "-showthreadrate 10000", "will show each thread-TP every 10000 iterations");
        this.addUsage("-stress [repeat times]", "runs the entire benchmark as many as 'repeat times' as stated");
        this.addExample("-stress", "-map -all -stress 10", "will run 10 cycles of map api put/get/remove");
        this.showUsage();
        System.out.println("\nExamples:");
        System.out.println("------------");
        this.showExamples();
    }

    private void addUsage(String key, String def) {
        this._maxKeyLength = key.length() > this._maxKeyLength ? key.length() : this._maxKeyLength;
        this.usageKey.add(key);
        this.usageDef.add(def);
    }

    private void showUsage() {
        for (int i = 0; i < this.usageKey.size(); ++i) {
            String output = this.usageKey.get(i);
            int spread = this._maxKeyLength - output.length();
            for (int p = 0; p < spread; ++p) {
                output = output + PADD;
            }
            output = output + TAB + this.usageDef.get(i) + "\n";
            System.out.println(PADD + output);
        }
        this.usageKey.clear();
        this.usageDef.clear();
        this._maxKeyLength = 0;
    }

    private void addExample(String key, String example, String explain) {
        this._maxExKeyLength = key.length() > this._maxExKeyLength ? key.length() : this._maxExKeyLength;
        this.examplesKey.add(key);
        this.examplesEg.add(example);
        this.exampleEx.add(explain);
    }

    private void showExamples() {
        for (int i = 0; i < this.examplesKey.size(); ++i) {
            int p;
            int keyLength = this.examplesKey.get(i).length();
            String output = this.examplesKey.get(i);
            int spread = this._maxExKeyLength - keyLength;
            String padd = "";
            for (p = 0; p < spread; ++p) {
                padd = padd + PADD;
            }
            output = output + padd + TAB + this.examplesEg.get(i);
            for (p = 0; p < keyLength; ++p) {
                padd = padd + PADD;
            }
            output = output + "\n" + padd + TAB + this.exampleEx.get(i) + "\n";
            System.out.println(output);
        }
    }

    public BenchmarkConfiguration getParameters() {
        return this.parameters;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public boolean isUseDCache() {
        return this.isUseDCache;
    }

    public String getFirstOperation() {
        return this.firstOperation;
    }

    public String getSecondOperation() {
        return this.secondOperation;
    }

    public String getThirdOperation() {
        return this.thirdOperation;
    }

    public boolean isFirstOperationInitialized() {
        return this._isFirstOperationInitialized;
    }

    public boolean isSecondOperationInitialized() {
        return this._isSecondOperationInitialized;
    }

    public boolean isThirdOperationInitialized() {
        return this._isThirdOperationInitialized;
    }

    private class ThroughputWrapper {
        private double _operationAverageTotalTime;
        private double _averageThroughput;
        private double _totalThroughput;

        ThroughputWrapper(double operationAverageTotalTime, double averageThroughput, double totalThroughput) {
            this._operationAverageTotalTime = operationAverageTotalTime;
            this._averageThroughput = averageThroughput;
            this._totalThroughput = totalThroughput;
        }

        public double getOperationAverageTotalTime() {
            return this._operationAverageTotalTime;
        }

        public double getAverageThroughput() {
            return this._averageThroughput;
        }

        public double getTotalThroughput() {
            return this._totalThroughput;
        }
    }
}

