/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.gigaspaces.internal.version.PlatformVersion;
import com.j_spaces.examples.benchmark.BenchmarkCommand;
import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.MessageAdaptors;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;

public class BenchmarkCommandReport {
    private final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
    private static final String[] resultFileColumnNames = new String[]{"Date", "OS Name", "VM", "Product Version", "Revision", "Operation", "Object Type", "Threads Number", "Iterations Number", "Entry Size", "Sampling Rate", "Batches", "Write/Read Timeout", "Return Lease", "Lease Time", "Clean Space", "Parallel Operation", "Number of repeats", "Transaction", "Commit every operation", "Use Local Cache", "Use SIngle Proxy", "First Operation Average Total Time (ms)", "First Operation Average Throughput (msg/sec)", "First Operation Total Throughput (msg/sec)", "Second Operation Average Total Time (m)", "Second Operation Average Throughput (msg/sec)", "Second Operation Total Throughput (msg/sec)", "Third Operation Average Total Time (ms)", "Third Operation Average Throughput (msg/sec)", "Third Operation Total Throughput (msg/sec)"};
    private final BenchmarkCommand command;

    public BenchmarkCommandReport(BenchmarkCommand command) {
        this.command = command;
    }

    public void outDebugInfo(String resultFileName) throws FileNotFoundException, IOException {
        FileOutputStream out;
        HSSFWorkbook hssfworkbook;
        File file = new File(resultFileName);
        if (file.exists()) {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(resultFileName));
            hssfworkbook = new HSSFWorkbook(fs);
            HSSFSheet sheet = hssfworkbook.getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            this.fillRowWithData(hssfworkbook, sheet, lastRowNum + 1);
            out = new FileOutputStream(resultFileName);
        } else {
            out = new FileOutputStream(resultFileName);
            hssfworkbook = new HSSFWorkbook();
            HSSFSheet sheet = hssfworkbook.createSheet();
            HSSFRow r = sheet.createRow(0);
            HSSFCellStyle cs = hssfworkbook.createCellStyle();
            HSSFFont f = hssfworkbook.createFont();
            f.setFontHeightInPoints((short)12);
            f.setColor((short)12);
            f.setBold(true);
            cs.setFont(f);
            BorderStyle borderStyle = BorderStyle.MEDIUM;
            this.setBorderStyle(cs, borderStyle);
            HSSFCellStyle cellStyle = hssfworkbook.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.FILL);
            for (int cellnum = 0; cellnum < resultFileColumnNames.length; cellnum = (int)((short)(cellnum + 1))) {
                HSSFCell c = r.createCell(cellnum);
                c.setCellStyle(cs);
                c.setCellValue((RichTextString)new HSSFRichTextString(resultFileColumnNames[cellnum]));
                sheet.setColumnWidth(cellnum, 4500);
            }
            this.fillRowWithData(hssfworkbook, sheet, 1);
        }
        hssfworkbook.write((OutputStream)out);
        out.close();
    }

    private void fillRowWithData(HSSFWorkbook wb, HSSFSheet s, int rowNumber) {
        BenchmarkConfiguration parameters = this.command.getParameters();
        HSSFRow r = s.createRow(rowNumber);
        HSSFCellStyle cs = wb.createCellStyle();
        HSSFFont f2 = wb.createFont();
        if (rowNumber % 2 == 0) {
            cs.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        BorderStyle headerBorderStyle = BorderStyle.THIN;
        this.setBorderStyle(cs, headerBorderStyle);
        f2.setFontHeightInPoints((short)10);
        f2.setBold(true);
        cs.setFont(f2);
        for (int cellnum = 0; cellnum < resultFileColumnNames.length; cellnum = (int)((short)(cellnum + 1))) {
            Object value;
            HSSFCell c = r.createCell(cellnum);
            c.setCellStyle(cs);
            switch (cellnum) {
                case 0: {
                    value = this.dateFormat.format(new Date());
                    break;
                }
                case 1: {
                    value = System.getProperty("os.name");
                    break;
                }
                case 2: {
                    value = System.getProperty("java.version");
                    break;
                }
                case 3: {
                    value = PlatformVersion.getVersion();
                    break;
                }
                case 4: {
                    value = PlatformVersion.getRevision();
                    break;
                }
                case 5: {
                    String operationName = "";
                    if (this.command.isFirstOperationInitialized()) {
                        operationName = operationName + (operationName.length() == 0 ? "" : " ") + this.command.getFirstOperation();
                    }
                    if (this.command.isSecondOperationInitialized()) {
                        operationName = operationName + (operationName.length() == 0 ? "" : " ") + this.command.getSecondOperation();
                    }
                    if (this.command.isThirdOperationInitialized()) {
                        operationName = operationName + (operationName.length() == 0 ? "" : " ") + this.command.getThirdOperation();
                    }
                    value = operationName;
                    break;
                }
                case 6: {
                    if (this.command.isMap()) {
                        value = MessageAdaptors.getByCode((short)1).getLabel();
                        break;
                    }
                    value = MessageAdaptors.getMessageName(parameters.messageType);
                    break;
                }
                case 7: {
                    value = new Integer(parameters.threadCount);
                    break;
                }
                case 8: {
                    value = new Integer(parameters.numberOfIterations);
                    break;
                }
                case 9: {
                    value = new Integer(parameters.messageLength);
                    break;
                }
                case 10: {
                    value = new Integer(parameters.globalThroughputIterations);
                    break;
                }
                case 11: {
                    value = new Integer(parameters.numOfBatches);
                    break;
                }
                case 12: {
                    value = new Long(parameters.timeout);
                    break;
                }
                case 13: {
                    value = new Boolean(parameters.isReturnLease);
                    break;
                }
                case 14: {
                    value = new Long(parameters.lease);
                    break;
                }
                case 15: {
                    value = new Boolean(parameters.isCleanSpace);
                    break;
                }
                case 16: {
                    value = new Boolean(parameters.isParallel);
                    break;
                }
                case 17: {
                    value = new Long(parameters.readRepeatTimes);
                    break;
                }
                case 18: {
                    if (!parameters.isSingleTransaction && parameters.spaceTransactionManager != null) {
                        if (parameters.transactionType == 2) {
                            value = "Distributed";
                            break;
                        }
                        if (parameters.transactionType == 1) {
                            value = "Local";
                            break;
                        }
                        value = "None";
                        break;
                    }
                    value = "None";
                    break;
                }
                case 19: {
                    if (!parameters.isSingleTransaction) {
                        value = new Long(parameters.txIterations);
                        break;
                    }
                    value = "-";
                    break;
                }
                case 20: {
                    value = new Boolean(this.command.isUseDCache());
                    break;
                }
                case 21: {
                    value = new Boolean(!parameters.isUseSingleSpaceProxy);
                    break;
                }
                case 22: {
                    value = this.command.getFirstOperationAverageTotalTime() > 0.0 ? new Double(this.command.getFirstOperationAverageTotalTime()) : null;
                    break;
                }
                case 23: {
                    value = this.command.getFirstAverageThroughput() > 0.0 ? new Double(this.command.getFirstAverageThroughput()) : null;
                    break;
                }
                case 24: {
                    value = this.command.getFirstTotalThroughput() > 0.0 ? new Double(this.command.getFirstTotalThroughput()) : null;
                    break;
                }
                case 25: {
                    value = this.command.getSecondOperationAverageTotalTime() > 0.0 ? new Double(this.command.getSecondOperationAverageTotalTime()) : null;
                    break;
                }
                case 26: {
                    value = this.command.getSecondAverageThroughput() > 0.0 ? new Double(this.command.getSecondAverageThroughput()) : null;
                    break;
                }
                case 27: {
                    value = this.command.getSecondTotalThroughput() > 0.0 ? new Double(this.command.getSecondTotalThroughput()) : null;
                    break;
                }
                case 28: {
                    value = this.command.getThirdOperationAverageTotalTime() > 0.0 ? new Double(this.command.getThirdOperationAverageTotalTime()) : null;
                    break;
                }
                case 29: {
                    value = this.command.getThirdAverageThroughput() > 0.0 ? new Double(this.command.getThirdAverageThroughput()) : null;
                    break;
                }
                case 30: {
                    value = this.command.getThirdTotalThroughput() > 0.0 ? new Double(this.command.getThirdTotalThroughput()) : null;
                    break;
                }
                default: {
                    value = "-";
                }
            }
            if (value instanceof String) {
                c.setCellValue((RichTextString)new HSSFRichTextString((String)value));
                continue;
            }
            if (value instanceof Number) {
                c.setCellValue(((Number)value).doubleValue());
                continue;
            }
            if (value instanceof Date) {
                c.setCellValue((Date)value);
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            c.setCellValue(((Boolean)value).booleanValue());
        }
    }

    private void setBorderStyle(HSSFCellStyle cs, BorderStyle borderStyle) {
        cs.setBorderBottom(borderStyle);
        cs.setBorderLeft(borderStyle);
        cs.setBorderRight(borderStyle);
        cs.setBorderTop(borderStyle);
    }
}

