/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BenchmarkTestResult {
    private Map<String, String> inputArgs;
    private List<Result> results = new LinkedList<Result>();
    private Exception exception;

    public void setInputArguments(Map<String, String> args) {
        this.inputArgs = args;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Result buildResult(String description) {
        Result newResult = new Result(description);
        this.results.add(newResult);
        return newResult;
    }

    public Map<String, Result> aggregate() {
        Result result;
        int warmups = 2;
        HashMap<String, Result> aggregatedMap = new HashMap<String, Result>();
        HashMap<String, Integer> totalResults = new HashMap<String, Integer>();
        for (Result result2 : this.results) {
            Result aggregatedResult = (Result)aggregatedMap.get(result2.key);
            if (aggregatedResult == null) {
                aggregatedResult = new Result(result2.key);
                aggregatedMap.put(result2.key, aggregatedResult);
                totalResults.put(result2.key, 0);
            }
            if ((Integer)totalResults.get(result2.key) >= 2) {
                result = aggregatedResult;
                result.avgDuration = result.avgDuration + result2.avgDuration;
                result = aggregatedResult;
                result.avgTP = result.avgTP + result2.avgTP;
                result = aggregatedResult;
                result.totalTP = result.totalTP + result2.totalTP;
            }
            totalResults.put(result2.key, (Integer)totalResults.get(result2.key) + 1);
        }
        for (Result aggregatedResult : aggregatedMap.values()) {
            Integer total = new Integer((Integer)totalResults.get(aggregatedResult.key) - 2);
            result = aggregatedResult;
            result.avgDuration = result.avgDuration / (double)total.intValue();
            result = aggregatedResult;
            result.avgTP = result.avgTP / (double)total.intValue();
            result = aggregatedResult;
            result.totalTP = result.totalTP / (double)total.intValue();
        }
        return aggregatedMap;
    }

    public Result aggregateByLast() {
        Map<String, Result> aggregatedMap = this.aggregate();
        Result lastResult = this.results.get(this.results.size() - 1);
        Result lastAggregatedResult = aggregatedMap.get(lastResult.key);
        return lastAggregatedResult;
    }

    public String toString() {
        if (this.exception != null) {
            return this.exception.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Input arguments: ");
        sb.append(this.inputArgs);
        sb.append("\n\n");
        for (Result result : this.results) {
            sb.append(result);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static final class Result {
        private String key;
        private List<ThreadResult> threadResult = new LinkedList<ThreadResult>();
        private double avgDuration;
        private double avgTP;
        private double totalTP;

        public Result(String key) {
            this.key = key;
        }

        void addThreadResult(double threadTP, long duration) {
            this.threadResult.add(new ThreadResult(threadTP, duration));
        }

        void setAverageDuration(double duration) {
            this.avgDuration = duration;
        }

        void setAverageThroughput(double throughput) {
            this.avgTP = throughput;
        }

        void setTotalThroughput(double total) {
            this.totalTP = total;
        }

        public String getKey() {
            return this.key;
        }

        public double getAvgDuration() {
            return this.avgDuration;
        }

        public double getAvgThroughput() {
            return this.avgTP;
        }

        public double getTotalThroughput() {
            return this.totalTP;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Operation: " + this.key + "\n");
            for (int i = 0; i < this.threadResult.size(); ++i) {
                sb.append("Thread [" + i + "] " + this.threadResult.get(i) + "\n");
            }
            sb.append("Average duration for all threads: " + this.avgDuration + " ms\n");
            sb.append("Average throughput for all threads: " + this.avgTP + " msg/sec\n");
            sb.append("Total throughput for all threads: " + this.totalTP + " msg/sec\n");
            return sb.toString();
        }
    }

    private static final class ThreadResult {
        final double threadTP;
        final long threadDuration;

        public ThreadResult(double threadTP, long threadDuration) {
            this.threadTP = threadTP;
            this.threadDuration = threadDuration;
        }

        public String toString() {
            return "TP: " + this.threadTP + " msg/sec Duration: " + this.threadDuration + " ms";
        }
    }
}

