/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.j_spaces.examples.benchmark.BenchmarkCommand;
import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.IMapDriver;
import com.j_spaces.examples.benchmark.MapDriver;
import com.j_spaces.examples.benchmark.ObjectLock;
import com.j_spaces.examples.benchmark.Operation;

public class GetUpdate
extends Operation {
    private Object retObject = null;
    private String key = "";
    IMapDriver map;

    GetUpdate(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);
        try {
            String mapDriver = System.getProperty("map.driver");
            if (mapDriver == null) {
                this.map = new MapDriver();
                this.map.init(parameters);
            } else {
                this.map = (IMapDriver)this.classForName(mapDriver);
                this.map.init(parameters);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (parameters.isGUI) {
                benchmarkOutput.showException("Exception", e);
            }
            System.exit(-1);
        }
    }

    private String prepareKey(int iter) {
        if (this.parameters.isRandom) {
            return String.valueOf(this.randomCounter[this.rand_iter++]);
        }
        return String.valueOf(iter);
    }

    @Override
    public void prepare() {
        this.min_iter = this.threadID * this.parameters.numberOfIterations;
        this.max_iter = this.min_iter + this.parameters.numberOfIterations - 1;
        if (this.parameters.secondOpRange) {
            this.min_iter = this.parameters.secondOpRangeFrom;
            this.max_iter = this.parameters.secondOpRangeTo - 1;
        }
        if (this.parameters.isRandom) {
            if (!this.parameters.secondOpRange) {
                this.min_iter = 0;
                this.max_iter = this.parameters.numberOfRandomIterations - 1;
            }
            this.randomCounter = this.randomGenerator();
        }
    }

    @Override
    public void doOperation() {
        try {
            for (int iter = this.min_iter; iter <= this.max_iter && BenchmarkCommand.START_STOP_FLAG; ++iter) {
                this.key = this.prepareKey(iter);
                this.retObject = this.map.get(this.key);
                this.map.put(this.key, this.retObject);
                if (this.retObject == null) {
                    throw new Exception("Thread " + Thread.currentThread().getName() + " get NULL entry by GET operation of object");
                }
                if (this.parameters.isThreadThroughput) {
                    if (iter == this.min_iter) {
                        this.initialThreadThroughputTime = System.currentTimeMillis();
                    }
                    if ((long)(iter + 1) % this.parameters.threadThroughputIterations == 0L) {
                        this.printThreadThroughput("GET", iter + 1);
                    }
                }
                if (!this.parameters.isGlobalThroughput) continue;
                int globalTpCounter = this.parameters.globalThroughputSecondOperationCounter.getAndIncrement();
                if (globalTpCounter == 0) {
                    this.parameters.globalThroughputSecondInitialTime = System.currentTimeMillis();
                }
                if ((globalTpCounter + 1) % this.parameters.globalThroughputIterations != 0) continue;
                this.printGlobalOperationThroughput("GET", globalTpCounter + 1);
            }
        }
        catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName() + " failed to complete GET operation of object");
            ex.printStackTrace();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", ex);
            }
            System.exit(-1);
        }
    }
}

