/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.j_spaces.examples.benchmark.BenchmarkCommand;
import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.ObjectLock;
import com.j_spaces.examples.benchmark.Operation;
import java.util.Hashtable;

public class HashtablePut
extends Operation {
    private Hashtable<String, Object> m_hashtable;
    private Object putEntry;

    HashtablePut(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, Hashtable<String, Object> hash, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);
        this.m_hashtable = hash;
    }

    private void prepareEntry(int iter) {
        this.parameters.getMessageAdaptor().setCounter(this.putEntry, iter);
        if (this.parameters.changeContent) {
            this.parameters.getMessageAdaptor().setPayload(this.putEntry, new byte[this.parameters.messageBuf.length]);
        }
    }

    @Override
    public void prepare() {
        this.putEntry = this.parameters.getMessageAdaptor().create(-1L, this.parameters.messageBuf);
        this.min_iter = this.threadID * this.parameters.numberOfIterations;
        this.max_iter = this.min_iter + this.parameters.numberOfIterations - 1;
    }

    @Override
    public void doOperation() {
        try {
            for (int iter = this.min_iter; iter <= this.max_iter && BenchmarkCommand.START_STOP_FLAG; ++iter) {
                this.prepareEntry(iter);
                this.m_hashtable.put(String.valueOf(iter), this.putEntry);
                if (this.parameters.isThreadThroughput) {
                    if (iter == this.min_iter) {
                        this.initialThreadThroughputTime = System.currentTimeMillis();
                    }
                    if ((long)(iter + 1) % this.parameters.threadThroughputIterations == 0L) {
                        this.printThreadThroughput("HASHTABLE_PUT", iter + 1);
                    }
                }
                if (!this.parameters.isGlobalThroughput) continue;
                int globalTpCounter = this.parameters.globalThroughputFirstOperationCounter.getAndIncrement();
                if (globalTpCounter == 0) {
                    this.parameters.globalThroughputFirstInitialTime = System.currentTimeMillis();
                }
                if ((globalTpCounter + 1) % this.parameters.globalThroughputIterations != 0) continue;
                this.printGlobalOperationThroughput("HASHTABLE_PUT", globalTpCounter + 1);
            }
        }
        catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName() + " failed to complete HASHTABLE_PUT operation of entry");
            ex.printStackTrace();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", ex);
            }
            System.exit(-1);
        }
    }
}

