/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.j_spaces.examples.benchmark.BenchmarkCommand;
import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.ObjectLock;
import com.j_spaces.examples.benchmark.Operation;
import java.util.Hashtable;

public class HashtableRemove
extends Operation {
    private Object retObject = null;
    private Hashtable<String, Object> m_hashtable;

    HashtableRemove(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, Hashtable<String, Object> hash, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);
        this.space = parameters.repSpace != null ? parameters.repSpace : parameters.space;
        this.m_hashtable = hash;
    }

    private String prepareKey(int iter) {
        if (this.parameters.isRandom) {
            return String.valueOf(this.randomCounter[this.rand_iter++]);
        }
        return String.valueOf(iter);
    }

    @Override
    public void prepare() {
        this.min_iter = this.threadID * this.parameters.numberOfIterations;
        this.max_iter = this.min_iter + this.parameters.numberOfIterations - 1;
        if (this.parameters.secondOpRange) {
            this.min_iter = this.parameters.secondOpRangeFrom;
            this.max_iter = this.parameters.secondOpRangeTo - 1;
        }
        if (this.parameters.isRandom) {
            if (!this.parameters.secondOpRange) {
                this.min_iter = 0;
                this.max_iter = this.parameters.numberOfRandomIterations - 1;
            }
            this.randomCounter = this.randomGenerator();
        }
    }

    @Override
    public void doOperation() {
        try {
            for (int iter = this.min_iter; iter <= this.max_iter && BenchmarkCommand.START_STOP_FLAG; ++iter) {
                String key = this.prepareKey(iter);
                this.retObject = this.m_hashtable.remove(key);
                if (this.retObject == null) {
                    throw new Exception("Thread " + Thread.currentThread().getName() + " get NULL entry by HASHTABLE_REMOVE operation of object");
                }
                if (this.parameters.isThreadThroughput) {
                    if (iter == this.min_iter) {
                        this.initialThreadThroughputTime = System.currentTimeMillis();
                    }
                    if ((long)(iter + 1) % this.parameters.threadThroughputIterations == 0L) {
                        this.printThreadThroughput("HASHTABLE_REMOVE", iter + 1);
                    }
                }
                if (!this.parameters.isGlobalThroughput) continue;
                int globalTpCounter = this.parameters.globalThroughputSecondOperationCounter.getAndIncrement();
                if (globalTpCounter == 0) {
                    this.parameters.globalThroughputSecondInitialTime = System.currentTimeMillis();
                }
                if ((globalTpCounter + 1) % this.parameters.globalThroughputIterations != 0) continue;
                this.printGlobalOperationThroughput("HASHTABLE_REMOVE", globalTpCounter + 1);
            }
        }
        catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName() + " failed to complete HASHTABLE_REMOVE operation of object");
            ex.printStackTrace();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", ex);
            }
            System.exit(-1);
        }
    }
}

