/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.ObjectLock;
import com.j_spaces.examples.benchmark.Operation;
import com.j_spaces.examples.benchmark.Result;
import com.j_spaces.jms.utils.GSJMSAdmin;
import java.rmi.Remote;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;

public class JMSNotify
extends Operation
implements Remote {
    private AtomicInteger eventCounter = new AtomicInteger(0);
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private boolean isTransaction = false;
    private Session session;
    private Topic dest;
    private MessageConsumer messageConsumer;

    public JMSNotify(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);
        System.out.println("=== IN JMS NOTIFY constructor ===");
        this.space = parameters.repSpace != null ? parameters.repSpace : parameters.space;
        try {
            this.connectionFactory = GSJMSAdmin.getInstance().getConnectionFactory(this.space);
            this.connection = this.connectionFactory.createConnection();
            this.session = this.connection.createSession(this.isTransaction, 1);
            this.dest = GSJMSAdmin.getInstance().getTopic("benchmark");
            this.messageConsumer = this.session.createConsumer((Destination)this.dest);
            this.connection.start();
        }
        catch (JMSException e) {
            e.printStackTrace();
            this.closeJMSResources();
            if (parameters.isGUI) {
                benchmarkOutput.showException("Exception", e);
            }
            System.exit(-1);
        }
    }

    private void closeJMSResources() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void prepare() {
        try {
            this.messageConsumer.setMessageListener(new MessageListener(){

                public void onMessage(Message m) {
                    JMSNotify.this.incrementEventCounter();
                    if (JMSNotify.this.getEventCounter() == 1) {
                        JMSNotify.this.initialTime = System.currentTimeMillis();
                    }
                    if (JMSNotify.this.parameters.isThreadThroughput) {
                        if (JMSNotify.this.getEventCounter() == 1) {
                            JMSNotify.this.initialThreadThroughputTime = JMSNotify.this.initialTime;
                        }
                        if ((long)JMSNotify.this.getEventCounter() % JMSNotify.this.parameters.threadThroughputIterations == 0L) {
                            JMSNotify.this.printThreadThroughput("NOTIFY", JMSNotify.this.getEventCounter());
                        }
                    }
                    if (JMSNotify.this.parameters.isGlobalThroughput) {
                        int globalTpCounter = JMSNotify.this.parameters.globalThroughputSecondOperationCounter.getAndIncrement();
                        if (globalTpCounter == 0) {
                            JMSNotify.this.parameters.globalThroughputSecondInitialTime = System.currentTimeMillis();
                        }
                        if ((globalTpCounter + 1) % JMSNotify.this.parameters.globalThroughputIterations == 0) {
                            JMSNotify.this.printGlobalOperationThroughput("NOTIFY", globalTpCounter + 1);
                        }
                    }
                }
            });
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void doOperation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementEventCounter() {
        if (this.eventCounter.incrementAndGet() == this.parameters.numberOfIterations) {
            try {
                if (this.transaction != null) {
                    this.transaction.commit();
                }
                JMSNotify jMSNotify = this;
                synchronized (jMSNotify) {
                    this.notify();
                }
                this.finalTime = System.currentTimeMillis();
                this.operationResultTime = new Result(this.initialTime, this.initialTimeWFCycle, this.finalTime);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.parameters.isGUI) {
                    this.benchmarkOutput.showException("Exception", ex);
                }
                System.exit(-1);
            }
        }
    }

    private int getEventCounter() {
        return this.eventCounter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getResultTime() {
        JMSNotify jMSNotify = this;
        synchronized (jMSNotify) {
            try {
                if (this.getEventCounter() < this.parameters.numberOfIterations) {
                    this.wait();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.parameters.isGUI) {
                    this.benchmarkOutput.showException("Exception", ex);
                }
                System.exit(-1);
            }
        }
        return this.operationResultTime.getResultTime();
    }

    public void close() {
        this.closeJMSResources();
    }
}

