/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.j_spaces.examples.benchmark.BenchmarkCommand;
import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.ObjectLock;
import com.j_spaces.examples.benchmark.Operation;
import com.j_spaces.jms.utils.GSJMSAdmin;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;

public class JMSTake
extends Operation {
    private Message retEntry = null;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private boolean isTransaction = false;
    private Session session;
    private Queue dest;
    private MessageConsumer messageConsumer;

    JMSTake(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);
        this.space = parameters.repSpace != null ? parameters.repSpace : parameters.space;
        try {
            this.connectionFactory = GSJMSAdmin.getInstance().getConnectionFactory(this.space);
            this.connection = this.connectionFactory.createConnection();
            this.session = this.connection.createSession(this.isTransaction, 1);
            this.dest = GSJMSAdmin.getInstance().getQueue("benchmark");
            this.messageConsumer = this.session.createConsumer((Destination)this.dest);
            this.connection.start();
        }
        catch (JMSException e) {
            e.printStackTrace();
            this.closeJMSResources();
            if (parameters.isGUI) {
                benchmarkOutput.showException("Exception", e);
            }
            System.exit(-1);
        }
    }

    private void closeJMSResources() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void prepare() {
        this.min_iter = this.threadID * this.parameters.numberOfIterations;
        this.max_iter = this.min_iter + this.parameters.numberOfIterations - 1;
        if (this.parameters.secondOpRange) {
            this.min_iter = this.parameters.secondOpRangeFrom;
            this.max_iter = this.parameters.secondOpRangeTo - 1;
        }
        if (this.parameters.isRandom) {
            if (!this.parameters.secondOpRange) {
                this.min_iter = 0;
                this.max_iter = this.parameters.numberOfRandomIterations - 1;
            }
            this.randomCounter = this.randomGenerator();
        }
    }

    @Override
    public void doOperation() {
        try {
            for (int iter = this.min_iter; iter <= this.max_iter && BenchmarkCommand.START_STOP_FLAG; ++iter) {
                int globalTpCounter;
                this.retEntry = this.messageConsumer.receive(10000L);
                if (this.parameters.isThreadThroughput) {
                    if (iter == this.min_iter) {
                        this.initialThreadThroughputTime = System.currentTimeMillis();
                    }
                    if ((long)(iter + 1) % this.parameters.threadThroughputIterations == 0L) {
                        this.printThreadThroughput("TAKE", iter + 1);
                    }
                }
                if (!this.parameters.isGlobalThroughput) continue;
                if (this.parameters.isAll) {
                    globalTpCounter = this.parameters.globalThroughputThirdOperationCounter.getAndIncrement();
                    if (globalTpCounter == 0) {
                        this.parameters.globalThroughputThirdInitialTime = System.currentTimeMillis();
                    }
                    if ((globalTpCounter + 1) % this.parameters.globalThroughputIterations != 0) continue;
                    this.printGlobalOperationThroughput("TAKE", globalTpCounter + 1);
                    continue;
                }
                globalTpCounter = this.parameters.globalThroughputSecondOperationCounter.getAndIncrement();
                if (globalTpCounter == 0) {
                    this.parameters.globalThroughputSecondInitialTime = System.currentTimeMillis();
                }
                if ((globalTpCounter + 1) % this.parameters.globalThroughputIterations != 0) continue;
                this.printGlobalOperationThroughput("TAKE", globalTpCounter + 1);
            }
        }
        catch (Exception e) {
            System.out.println("Thread " + Thread.currentThread().getName() + " failed to complete JMSTake operation");
            e.printStackTrace();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", e);
            } else {
                System.exit(-1);
            }
        }
        finally {
            this.closeJMSResources();
        }
    }
}

