/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.j_spaces.examples.benchmark.BenchmarkCommand;
import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.MessageAdaptor;
import com.j_spaces.examples.benchmark.MessageAdaptors;
import com.j_spaces.examples.benchmark.ObjectLock;
import com.j_spaces.examples.benchmark.Operation;
import com.j_spaces.jms.utils.GSJMSAdmin;
import java.rmi.RemoteException;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;

public class JMSWrite
extends Operation {
    private Message writeEntry;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private boolean isTransaction = false;
    private Session session;
    private Queue dest;
    private MessageProducer messageProducer;

    JMSWrite(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);
        this.space = parameters.isNotify && parameters.repSpace != null ? parameters.repSpace : parameters.space;
        try {
            this.connectionFactory = GSJMSAdmin.getInstance().getConnectionFactory(this.space);
            this.connection = this.connectionFactory.createConnection();
            this.session = this.connection.createSession(this.isTransaction, 1);
            this.dest = GSJMSAdmin.getInstance().getQueue("benchmark");
            this.messageProducer = this.session.createProducer((Destination)this.dest);
        }
        catch (JMSException e) {
            e.printStackTrace();
            this.closeJMSResources();
            if (parameters.isGUI) {
                benchmarkOutput.showException("Exception", e);
            }
            System.exit(-1);
        }
    }

    @Override
    public void prepare() {
        try {
            MessageAdaptor adaptor = MessageAdaptors.getByCode(this.parameters.messageType);
            this.writeEntry = (Message)adaptor.create(-1L, this.parameters.messageBuf);
            this.parameters.space.snapshot(adaptor.create());
            if (this.parameters.firstOpRange) {
                this.min_iter = this.parameters.firstOpRangeFrom;
                this.max_iter = this.parameters.firstOpRangeTo - 1;
            } else {
                this.min_iter = this.threadID * this.parameters.numberOfIterations;
                this.max_iter = this.min_iter + this.parameters.numberOfIterations - 1;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            this.closeJMSResources();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", e);
            }
            System.exit(-1);
        }
    }

    private void closeJMSResources() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doOperation() {
        try {
            for (long iter = (long)this.min_iter; iter <= (long)this.max_iter && BenchmarkCommand.START_STOP_FLAG; ++iter) {
                this.messageProducer.send(this.writeEntry);
                if (this.parameters.isWriteRate) {
                    int rateIter = this.parameters.globalRateIter.getAndIncrement();
                    if (rateIter == 0) {
                        this.parameters.globalInitialRateTime = System.currentTimeMillis();
                    }
                    if ((rateIter + 1) % this.parameters.writeRate == 0) {
                        this.waitWriteRate("WRITE", rateIter + 1);
                    }
                }
                if (this.parameters.isThreadThroughput) {
                    if (iter == (long)this.min_iter) {
                        this.initialThreadThroughputTime = System.currentTimeMillis();
                    }
                    if ((iter + 1L) % this.parameters.threadThroughputIterations == 0L) {
                        this.printThreadThroughput("WRITE", iter + 1L);
                    }
                }
                if (!this.parameters.isGlobalThroughput) continue;
                int globalTpCounter = this.parameters.globalThroughputFirstOperationCounter.getAndIncrement();
                if (globalTpCounter == 0) {
                    this.parameters.globalThroughputFirstInitialTime = System.currentTimeMillis();
                }
                if ((globalTpCounter + 1) % this.parameters.globalThroughputIterations != 0) continue;
                this.printGlobalOperationThroughput("WRITE", globalTpCounter + 1);
            }
        }
        catch (Exception e) {
            System.out.println("Thread " + Thread.currentThread().getName() + " failed to complete JMSWrite operation of entry");
            e.printStackTrace();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", e);
            } else {
                System.exit(-1);
            }
        }
        finally {
            this.closeJMSResources();
        }
    }
}

