/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.j_spaces.examples.benchmark.MessageAdaptor;
import com.j_spaces.examples.benchmark.adaptors.MessageJMSAdaptor;
import com.j_spaces.examples.benchmark.adaptors.MessagePOJOAdaptor;
import com.j_spaces.examples.benchmark.adaptors.MessagePOJOExternalizableAdaptor;
import com.j_spaces.examples.benchmark.adaptors.MessagePOJOExternalizableFifoAdaptor;
import com.j_spaces.examples.benchmark.adaptors.MessagePOJOFifoAdaptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageAdaptors {
    public static final short CODE_POJO = 1;
    public static final short CODE_POJO_FIFO = 2;
    public static final short CODE_POJO_EXTERNALIZABLE = 3;
    public static final short CODE_POJO_EXTERNALIZABLE_FIFO = 4;
    public static final short CODE_JMS = 7;
    public static final int GROUP_SERIALIZABLE = 1;
    public static final int GROUP_EXTERNALIZABLE = 2;
    public static final int GROUP_JMS = 3;
    private static final MessageAdaptor[] _adaptors = new MessageAdaptor[]{new MessagePOJOAdaptor(), new MessagePOJOFifoAdaptor(), new MessagePOJOExternalizableAdaptor(), new MessagePOJOExternalizableFifoAdaptor(), new MessageJMSAdaptor()};
    private static final Map<Short, MessageAdaptor> _codeAdaptorMap = new HashMap<Short, MessageAdaptor>();
    private static final Map<String, MessageAdaptor> _nameAdaptorMap = new HashMap<String, MessageAdaptor>();
    private static final Map<Integer, List<MessageAdaptor>> _groupAdaptorsMap = new HashMap<Integer, List<MessageAdaptor>>();

    public static MessageAdaptor[] getMessageAdaptors() {
        return _adaptors;
    }

    public static MessageAdaptor getByCode(short code) {
        return _codeAdaptorMap.get(code);
    }

    public static MessageAdaptor getByName(String name) {
        return _nameAdaptorMap.get(name);
    }

    public static String getMessageName(short type) {
        MessageAdaptor adaptor = MessageAdaptors.getByCode(type);
        return adaptor != null ? adaptor.getLabel() : String.valueOf(type);
    }

    public static short getMessageType(String type) {
        MessageAdaptor adaptor = MessageAdaptors.getByName(type);
        return adaptor != null ? adaptor.getCode() : (short)1;
    }

    public static String getComparisonString(MessageAdaptor adaptor) {
        String result = "This object's result are comparable with the following objects: ";
        List<MessageAdaptor> adaptors = _groupAdaptorsMap.get(adaptor.getGroup());
        result = result + adaptors.get(0).getLabel();
        for (int i = 1; i < adaptors.size(); ++i) {
            result = result + ", " + adaptors.get(i).getLabel();
        }
        return result + ".";
    }

    static {
        for (MessageAdaptor adaptor : _adaptors) {
            _codeAdaptorMap.put(adaptor.getCode(), adaptor);
            _nameAdaptorMap.put(adaptor.getName(), adaptor);
            List<MessageAdaptor> groupAdaptors = _groupAdaptorsMap.get(adaptor.getGroup());
            if (groupAdaptors == null) {
                groupAdaptors = new ArrayList<MessageAdaptor>();
                _groupAdaptorsMap.put(adaptor.getGroup(), groupAdaptors);
            }
            groupAdaptors.add(adaptor);
        }
    }
}

