/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.gigaspaces.events.DataEventSession;
import com.gigaspaces.events.DataEventSessionFactory;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.events.NotifyActionType;
import com.j_spaces.core.IJSpace;
import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.MessageAdaptor;
import com.j_spaces.examples.benchmark.MessageAdaptors;
import com.j_spaces.examples.benchmark.ObjectLock;
import com.j_spaces.examples.benchmark.Operation;
import com.j_spaces.examples.benchmark.Result;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicInteger;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.UnknownLeaseException;

public class Notify
extends Operation
implements RemoteEventListener,
Remote {
    private Object notifyTemplate = null;
    private AtomicInteger eventCounter = new AtomicInteger(0);
    private DataEventSession session = null;

    public Notify(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);
        System.out.println("=== IN NOTIFY constructor ===");
    }

    @Override
    public void prepare() {
        MessageAdaptor adaptor = MessageAdaptors.getByCode(this.parameters.messageType);
        this.notifyTemplate = adaptor.create();
        this.parameters.getMessageAdaptor().setCounter(this.notifyTemplate, -1L);
        try {
            EventSessionConfig config = new EventSessionConfig().setFifo(false);
            this.session = DataEventSessionFactory.create((IJSpace)this.parameters.space, (EventSessionConfig)config);
            this.session.addListener(this.notifyTemplate, (RemoteEventListener)this, this.parameters.lease, NotifyActionType.NOTIFY_ALL);
            if (this.parameters.repSpace != null) {
                this.session = DataEventSessionFactory.create((IJSpace)this.parameters.repSpace, (EventSessionConfig)config);
                this.session.addListener(this.notifyTemplate, (RemoteEventListener)this, this.parameters.lease, NotifyActionType.NOTIFY_ALL);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", e);
            }
            System.exit(-1);
        }
    }

    @Override
    public void doOperation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementEventCounter() {
        if (this.eventCounter.incrementAndGet() == this.parameters.numberOfIterations) {
            try {
                if (this.transaction != null) {
                    this.transaction.commit();
                }
                Notify notify = this;
                synchronized (notify) {
                    this.notify();
                }
                this.finalTime = System.currentTimeMillis();
                this.operationResultTime = new Result(this.initialTime, this.initialTimeWFCycle, this.finalTime);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.parameters.isGUI) {
                    this.benchmarkOutput.showException("Exception", ex);
                }
                System.exit(-1);
            }
        }
    }

    private int getEventCounter() {
        return this.eventCounter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getResultTime() {
        Notify notify = this;
        synchronized (notify) {
            try {
                if (this.getEventCounter() != this.parameters.numberOfIterations) {
                    this.wait();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.parameters.isGUI) {
                    this.benchmarkOutput.showException("Exception", ex);
                }
                System.exit(-1);
            }
        }
        return this.operationResultTime.getResultTime();
    }

    public void notify(RemoteEvent event) throws UnknownEventException, RemoteException {
        this.incrementEventCounter();
        if (this.getEventCounter() == 1) {
            this.initialTime = System.currentTimeMillis();
        }
        if (this.parameters.isThreadThroughput) {
            if (this.getEventCounter() == 1) {
                this.initialThreadThroughputTime = this.initialTime;
            }
            if ((long)this.getEventCounter() % this.parameters.threadThroughputIterations == 0L) {
                this.printThreadThroughput("NOTIFY", this.getEventCounter());
            }
        }
        if (this.parameters.isGlobalThroughput) {
            int globalTpCounter = this.parameters.globalThroughputSecondOperationCounter.getAndIncrement();
            if (globalTpCounter == 0) {
                this.parameters.globalThroughputSecondInitialTime = System.currentTimeMillis();
            }
            if ((globalTpCounter + 1) % this.parameters.globalThroughputIterations == 0) {
                this.printGlobalOperationThroughput("NOTIFY", globalTpCounter + 1);
            }
        }
    }

    public void close() {
        try {
            this.session.close();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (UnknownLeaseException e) {
            e.printStackTrace();
        }
    }
}

