/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.j_spaces.core.IJSpace;
import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.BenchmarkUtils;
import com.j_spaces.examples.benchmark.JMSNotify;
import com.j_spaces.examples.benchmark.JMSTake;
import com.j_spaces.examples.benchmark.JMSWrite;
import com.j_spaces.examples.benchmark.Notify;
import com.j_spaces.examples.benchmark.ObjectLock;
import com.j_spaces.examples.benchmark.Put;
import com.j_spaces.examples.benchmark.PutPutGetRemove;
import com.j_spaces.examples.benchmark.Remove;
import com.j_spaces.examples.benchmark.Result;
import com.j_spaces.examples.benchmark.Take;
import com.j_spaces.examples.benchmark.Write;
import com.j_spaces.examples.benchmark.WriteMultiple;
import com.j_spaces.examples.benchmark.WriteReadUpdateTake;
import java.util.LinkedList;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionFactory;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.TransactionManager;

public abstract class Operation
implements Runnable {
    protected BenchmarkConfiguration parameters;
    protected Result operationResultTime = null;
    protected TransactionManager trManager;
    protected int threadID;
    protected ObjectLock objLock;
    protected IJSpace space;
    protected Transaction transaction = null;
    protected long finalTime = 0L;
    protected long initialTime = 0L;
    protected long initialTimeWFCycle = 0L;
    protected LinkedList<Double> threadThroughputTime;
    protected long initialThreadThroughputTime;
    protected long finalThreadThroughputTime;
    private long globalFinalTime;
    private long globalInitialTime;
    protected int min_iter;
    protected int max_iter;
    int rand_iter = 0;
    protected int[] randomCounter = null;
    protected final String OPER_TAKE = "TAKE";
    protected final String OPER_REMOVE = "REMOVE";
    protected final String OPER_READ = "READ";
    protected final String OPER_GET = "GET";
    protected final String OPER_PUT = "PUT";
    protected final String OPER_WRITE = "WRITE";
    protected final String OPER_BENCH = "BENCH";
    protected final String OPER_BENCHMAP = "BENCHMAP";
    protected final String OPER_UPDATE = "UPDATE";
    protected final String OPER_UPDATEMAP = "UPDATEMAP";
    protected final String OPER_WRITE_MULTIPLE = "WRITE MULTIPLE";
    protected final String OPER_READ_MULTIPLE = "READ MULTIPLE";
    protected final String OPER_TAKE_MULTIPLE = "TAKE MULTIPLE";
    protected long elapsedTime1;
    protected long elapsedTime2;
    protected long elapsedTime3;
    private static final long MSG_PER_SECOND_RATE = 1000L;
    protected BenchmarkOutput benchmarkOutput;
    protected boolean secondOperation = false;
    protected double globalThroughput = 0.0;

    protected Operation(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        this.threadID = threadID;
        this.benchmarkOutput = benchmarkOutput;
        this.parameters = parameters;
        this.objLock = objLock;
        if (parameters.repSpace != null) {
            if (!(this instanceof Write || this instanceof Put || this instanceof WriteMultiple || this instanceof Notify)) {
                this.trManager = parameters.repSpaceTransactionManager;
            }
        } else {
            this.trManager = parameters.spaceTransactionManager;
        }
        if (parameters.txIterations != 0 || parameters.isSingleTransaction) {
            try {
                this.transaction = this.createTx();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (parameters.isThreadThroughput) {
            this.threadThroughputTime = new LinkedList();
            this.initialThreadThroughputTime = 0L;
            this.finalThreadThroughputTime = 0L;
        }
    }

    protected void say(String mes) {
        System.out.println(Thread.currentThread().getName() + "\t" + mes);
    }

    protected Transaction createTx() throws Exception {
        if (this.trManager != null) {
            Transaction.Created tCreated = TransactionFactory.create((TransactionManager)this.trManager, (long)3600000L);
            return tCreated.transaction;
        }
        return null;
    }

    public long getResultTime() {
        if (this.operationResultTime != null) {
            return this.operationResultTime.getResultTime();
        }
        return -1L;
    }

    public long getResultTimeWFCycle() {
        if (this.operationResultTime != null) {
            return this.operationResultTime.getResultTimeWithoutFirstCycle();
        }
        return -1L;
    }

    public void printThreadThroughput(String operation, long operationCounter) {
        this.printThreadThroughput(operation, operationCounter, this.parameters.threadThroughputIterations);
    }

    public void printThreadThroughput(String operation, long operationCounter, long objectsAmount) {
        this.finalThreadThroughputTime = System.currentTimeMillis();
        long timediff = this.finalThreadThroughputTime - this.initialThreadThroughputTime;
        double threadThroughput = timediff != 0L ? (double)(objectsAmount *= 1000L) / (double)timediff : 2.147483647E9;
        this.threadThroughputTime.add(threadThroughput);
        this.say(" " + operation + "\titer=" + operationCounter + "\tT_TP=" + BenchmarkUtils.format(threadThroughput) + " oper/sec\t Free mem=" + Runtime.getRuntime().freeMemory() / 0x100000L + " MB");
        this.initialThreadThroughputTime = this.finalThreadThroughputTime;
        if (this.benchmarkOutput != null) {
            this.benchmarkOutput.addThreadTPSample(String.valueOf(operationCounter), operation, Thread.currentThread().getName(), threadThroughput, BenchmarkUtils.format(this.globalThroughput), String.valueOf(Runtime.getRuntime().freeMemory() / 0x100000L), this.secondOperation);
        }
    }

    public void printGlobalOperationThroughput(String operation, long operationCounter) {
        try {
            this.printGlobalOperationThroughput(operation, operationCounter, 0, this.parameters.globalThroughputIterations);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printGlobalOperationThroughput(String operation, long operationCounter, int repeatCount, long objectsAmount) throws Exception {
        objectsAmount *= 1000L;
        if (this.parameters.isAll && (operation.equals("TAKE") || operation.equals("REMOVE") || operation.equals("TAKE MULTIPLE"))) {
            this.globalFinalTime = this.parameters.globalThroughputThirdFinalTime = System.currentTimeMillis();
            this.globalInitialTime = this.parameters.globalThroughputThirdInitialTime;
        } else if (operation.equals("WRITE") || operation.equals("PUT") || operation.equals("WRITE MULTIPLE")) {
            this.globalFinalTime = this.parameters.globalThroughputFirstFinalTime = System.currentTimeMillis();
            this.globalInitialTime = this.parameters.globalThroughputFirstInitialTime;
        } else {
            this.globalFinalTime = this.parameters.globalThroughputSecondFinalTime = System.currentTimeMillis();
            this.globalInitialTime = this.parameters.globalThroughputSecondInitialTime;
        }
        double timediff = this.globalFinalTime - this.globalInitialTime;
        if (this.parameters.isAll && (operation.equals("TAKE") || operation.equals("REMOVE") || operation.equals("TAKE MULTIPLE"))) {
            this.parameters.globalThroughputThirdInitialTime = this.parameters.globalThroughputThirdFinalTime;
        } else if (operation.equals("WRITE") || operation.equals("PUT") || operation.equals("WRITE MULTIPLE")) {
            this.parameters.globalThroughputFirstInitialTime = this.parameters.globalThroughputFirstFinalTime;
        } else {
            this.parameters.globalThroughputSecondInitialTime = this.parameters.globalThroughputSecondFinalTime;
        }
        this.globalThroughput = timediff != 0.0 ? (double)objectsAmount / timediff : 2.147483647E9;
        if (this.parameters.isAll && (operation.equals("TAKE") || operation.equals("REMOVE"))) {
            this.parameters.globalThroughputThirdList.add(this.globalThroughput);
        } else if (operation.equals("WRITE") || operation.equals("PUT") || operation.equals("WRITE MULTIPLE")) {
            this.parameters.globalThroughputFirstList.add(this.globalThroughput);
        } else {
            this.parameters.globalThroughputSecondList.add(this.globalThroughput);
        }
        if (this.benchmarkOutput != null) {
            this.benchmarkOutput.addGlobalTPSample(String.valueOf(operationCounter), this.globalThroughput, repeatCount, this.secondOperation, this.parameters.isParallel);
        }
        this.say(" " + operation + "\titer=" + operationCounter + "\tG_TP=" + BenchmarkUtils.format(this.globalThroughput) + " oper/sec\t Free mem=" + Runtime.getRuntime().freeMemory() / 0x100000L + " MB");
    }

    public void setSecondOperation(boolean b) {
        this.secondOperation = b;
    }

    public int[] randomGenerator() {
        int entriesQuantity = this.max_iter - this.min_iter + 1;
        this.randomCounter = new int[entriesQuantity];
        int tmp1 = 0;
        int tmp2 = 0;
        int tmp = 0;
        int iter = this.min_iter;
        int i = 0;
        while (iter <= this.max_iter) {
            this.randomCounter[i] = iter++;
            ++i;
        }
        for (int i2 = 0; i2 < entriesQuantity; ++i2) {
            tmp1 = (int)(Math.random() * (double)entriesQuantity);
            if (tmp1 == (tmp2 = (int)(Math.random() * (double)entriesQuantity))) continue;
            tmp = this.randomCounter[tmp1];
            this.randomCounter[tmp1] = this.randomCounter[tmp2];
            this.randomCounter[tmp2] = tmp;
        }
        return this.randomCounter;
    }

    public abstract void prepare();

    public abstract void doOperation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long endCycle;
        this.prepare();
        ObjectLock objectLock = this.objLock;
        synchronized (objectLock) {
            block18: {
                this.objLock.incrementStartedThreads();
                if (this.objLock.getStartedThreads() < this.objLock.getWorkerThreads()) {
                    try {
                        this.objLock.wait();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        if (this.parameters.isGUI) {
                            this.benchmarkOutput.showException("Exception", ex);
                            break block18;
                        }
                        System.exit(-1);
                    }
                } else {
                    this.objLock.notifyAll();
                }
            }
        }
        boolean firstOp = this instanceof Write || this instanceof WriteMultiple || this instanceof Put || this instanceof Notify || this instanceof WriteReadUpdateTake || this instanceof PutPutGetRemove || this instanceof JMSWrite || this instanceof JMSNotify;
        long startCycle = 1L;
        long l = endCycle = firstOp ? this.parameters.writeRepeatTimes : this.parameters.readRepeatTimes;
        if (this instanceof Take || this instanceof Remove || this instanceof JMSTake) {
            endCycle = 1L;
        }
        this.initialTime = System.currentTimeMillis();
        for (long cycle = startCycle; cycle <= endCycle; ++cycle) {
            if (endCycle > 1L && cycle == 2L) {
                this.initialTimeWFCycle = System.currentTimeMillis();
            }
            if (cycle > startCycle && (this.parameters.txIterations != 0 || this.parameters.isSingleTransaction)) {
                try {
                    this.transaction = this.createTx();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.doOperation();
            if (this.transaction == null || this instanceof Notify || this instanceof JMSNotify) continue;
            try {
                this.transaction.commit();
                continue;
            }
            catch (UnknownTransactionException e) {
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.parameters.isGUI) {
                    this.benchmarkOutput.showException("Exception", ex);
                    continue;
                }
                System.exit(-1);
            }
        }
        this.finalTime = System.currentTimeMillis();
        this.operationResultTime = new Result(this.initialTime, this.initialTimeWFCycle, this.finalTime);
    }

    public Object classForName(String className) throws Exception {
        Class<?> claz = Class.forName(className);
        return claz.newInstance();
    }

    protected void waitWriteRate(String operation, int iter) {
        long finalRateTime = System.currentTimeMillis();
        long elapsedRateTime = finalRateTime - this.parameters.globalInitialRateTime;
        this.parameters.globalInitialRateTime = finalRateTime;
        long sleepTime = 1000L - elapsedRateTime;
        String error = "";
        if (sleepTime > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            error = "[X]";
        }
        this.say(" " + operation + "\titer=" + iter + "\tRATE=" + this.parameters.writeRate + " oper/sec\t in=" + elapsedRateTime + " ms. " + error);
    }
}

