/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import java.util.HashMap;
import java.util.Map;

public class OptionHandler {
    private final String m_options;

    public OptionHandler(String options) {
        this.m_options = options;
    }

    public Map getOptions(String[] args) throws IllegalArgumentException {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) continue;
            String option = arg.substring(1);
            if (!this.isValidOption(option)) {
                throw new IllegalArgumentException("Invalid option : -" + option + ". use -h for help.");
            }
            argsMap.put(option, this.getArgs(args, i));
        }
        return argsMap;
    }

    private String getArgs(String[] args, int i) {
        StringBuilder entire = new StringBuilder();
        ++i;
        while (i < args.length && !args[i].startsWith("-")) {
            entire.append(args[i]);
            entire.append(' ');
            ++i;
        }
        return entire.toString().trim();
    }

    public boolean isValidOption(String option) {
        return this.m_options.indexOf(option) != -1;
    }
}

