/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.j_spaces.examples.benchmark.BenchmarkCommand;
import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.IMapDriver;
import com.j_spaces.examples.benchmark.MapDriver;
import com.j_spaces.examples.benchmark.MessageAdaptor;
import com.j_spaces.examples.benchmark.MessageAdaptors;
import com.j_spaces.examples.benchmark.ObjectLock;
import com.j_spaces.examples.benchmark.Operation;

public class Put
extends Operation {
    IMapDriver map;
    Object putEntry;
    int[] randomArray;

    Put(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);
        try {
            String mapDriver = System.getProperty("map.driver");
            if (mapDriver == null) {
                this.map = new MapDriver();
                this.map.init(parameters);
            } else {
                this.map = (IMapDriver)this.classForName(mapDriver);
                this.map.init(parameters);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (parameters.isGUI) {
                benchmarkOutput.showException("Exception", e);
            }
            System.exit(-1);
        }
    }

    private void prepareEntry(int iter) {
        MessageAdaptor adaptor = MessageAdaptors.getByCode(this.parameters.messageType);
        if (this.parameters.changeContent) {
            this.putEntry = adaptor.create(iter, new byte[this.parameters.messageBuf.length]);
        } else {
            this.parameters.getMessageAdaptor().setCounter(this.putEntry, iter);
        }
    }

    @Override
    public void prepare() {
        MessageAdaptor adaptor = MessageAdaptors.getByCode(this.parameters.messageType);
        this.putEntry = adaptor.create(-1L, this.parameters.messageBuf);
        if (this.parameters.firstOpRange) {
            this.min_iter = this.parameters.firstOpRangeFrom;
            this.max_iter = this.parameters.firstOpRangeTo - 1;
        } else {
            this.min_iter = this.threadID * this.parameters.numberOfIterations;
            this.max_iter = this.min_iter + this.parameters.numberOfIterations - 1;
        }
    }

    @Override
    public void doOperation() {
        for (int iter = this.min_iter; iter <= this.max_iter && BenchmarkCommand.START_STOP_FLAG; ++iter) {
            this.prepareEntry(iter);
            this.map.put(String.valueOf(iter), this.putEntry);
            if (this.parameters.isWriteRate) {
                int rateIter = this.parameters.globalRateIter.getAndIncrement();
                if (rateIter == 0) {
                    this.parameters.globalInitialRateTime = System.currentTimeMillis();
                }
                if ((rateIter + 1) % this.parameters.writeRate == 0) {
                    this.waitWriteRate("PUT", rateIter + 1);
                }
            }
            if (this.parameters.isThreadThroughput) {
                if (iter == this.min_iter) {
                    this.initialThreadThroughputTime = System.currentTimeMillis();
                }
                if ((long)(iter + 1) % this.parameters.threadThroughputIterations == 0L) {
                    this.printThreadThroughput("PUT", iter + 1);
                }
            }
            if (!this.parameters.isGlobalThroughput) continue;
            int globalTpCounter = this.parameters.globalThroughputFirstOperationCounter.getAndIncrement();
            if (globalTpCounter == 0) {
                this.parameters.globalThroughputFirstInitialTime = System.currentTimeMillis();
            }
            if ((globalTpCounter + 1) % this.parameters.globalThroughputIterations != 0) continue;
            this.printGlobalOperationThroughput("PUT", globalTpCounter + 1);
        }
    }
}

