/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.j_spaces.examples.benchmark.BenchmarkCommand;
import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.MessageAdaptor;
import com.j_spaces.examples.benchmark.MessageAdaptors;
import com.j_spaces.examples.benchmark.ObjectLock;
import com.j_spaces.examples.benchmark.Operation;
import java.rmi.RemoteException;

public class Read
extends Operation {
    private Object retEntry;
    private Object readTemplate = null;

    Read(BenchmarkConfiguration parameters, int threadID, ObjectLock objectLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objectLock, benchmarkOutput);
        this.space = parameters.repSpace != null ? parameters.repSpace : parameters.space;
    }

    @Override
    public void prepare() {
        try {
            MessageAdaptor adaptor = MessageAdaptors.getByCode(this.parameters.messageType);
            this.space.snapshot(adaptor.create());
            this.readTemplate = adaptor.create(-1L, null);
            this.min_iter = this.threadID * this.parameters.numberOfIterations;
            this.max_iter = this.min_iter + this.parameters.numberOfIterations - 1;
            if (this.parameters.secondOpRange) {
                this.min_iter = this.parameters.secondOpRangeFrom;
                this.max_iter = this.parameters.secondOpRangeTo - 1;
            }
            if (this.parameters.isRandom) {
                if (!this.parameters.secondOpRange) {
                    this.min_iter = 0;
                    this.max_iter = this.parameters.numberOfRandomIterations - 1;
                }
                this.randomCounter = this.randomGenerator();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", e);
            }
            System.exit(-1);
        }
    }

    private Object prepareReadTemplate(int iter) {
        int id = 0;
        id = this.parameters.isRandom ? this.randomCounter[this.rand_iter++] : iter;
        this.parameters.getMessageAdaptor().setCounter(this.readTemplate, id);
        return this.readTemplate;
    }

    @Override
    public void doOperation() {
        try {
            for (int iter = this.min_iter; iter <= this.max_iter && BenchmarkCommand.START_STOP_FLAG; ++iter) {
                Object preparedReadTemplate = this.prepareReadTemplate(iter);
                this.retEntry = this.space.read(preparedReadTemplate, this.transaction, this.parameters.timeout);
                if (this.retEntry == null) {
                    if (this.parameters.isStress && this.parameters.isParallel) {
                        if (this.parameters.isAll) continue;
                        this.space.read(preparedReadTemplate, this.transaction, Long.MAX_VALUE);
                    } else {
                        throw new Exception("Thread " + Thread.currentThread().getName() + " get NULL entry by READ operation of template");
                    }
                }
                if (this.parameters.delayReadTake != 0) {
                    Thread.sleep(this.parameters.delayReadTake);
                }
                if (this.transaction != null) {
                    if (this.parameters.isSingleTransaction && (iter + 1) % this.parameters.numberOfIterations == 0) {
                        this.transaction.commit();
                    } else if ((iter + 1) % this.parameters.txIterations == 0) {
                        this.transaction.commit();
                        if (iter < this.max_iter) {
                            this.transaction = this.createTx();
                        }
                    }
                }
                if (this.parameters.isThreadThroughput) {
                    if (iter == this.min_iter) {
                        this.initialThreadThroughputTime = System.currentTimeMillis();
                    }
                    if ((long)(iter + 1) % this.parameters.threadThroughputIterations == 0L) {
                        this.printThreadThroughput("READ", iter + 1);
                    }
                }
                if (!this.parameters.isGlobalThroughput) continue;
                int globalTpCounter = this.parameters.globalThroughputSecondOperationCounter.getAndIncrement();
                if (globalTpCounter == 0) {
                    this.parameters.globalThroughputSecondInitialTime = System.currentTimeMillis();
                }
                if ((globalTpCounter + 1) % this.parameters.globalThroughputIterations != 0) continue;
                this.printGlobalOperationThroughput("READ", globalTpCounter + 1);
            }
        }
        catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName() + " failed to complete READ operation of template");
            ex.printStackTrace();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", ex);
            }
            System.exit(-1);
        }
    }
}

