/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.j_spaces.examples.benchmark.BenchmarkCommand;
import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.MessageAdaptor;
import com.j_spaces.examples.benchmark.MessageAdaptors;
import com.j_spaces.examples.benchmark.ObjectLock;
import com.j_spaces.examples.benchmark.Operation;
import java.rmi.RemoteException;

public class TakeMultiple
extends Operation {
    Object takeTemplate;
    Object[] retEntries;

    TakeMultiple(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);
    }

    @Override
    public void prepare() {
        MessageAdaptor adaptor = MessageAdaptors.getByCode(this.parameters.messageType);
        this.takeTemplate = adaptor.create();
        this.space = this.parameters.repSpace != null ? this.parameters.repSpace : this.parameters.space;
        try {
            this.space.snapshot(adaptor.create());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", e);
            }
            System.exit(-1);
        }
    }

    @Override
    public void doOperation() {
        try {
            for (int batch = 1; batch <= this.parameters.numOfBatches && BenchmarkCommand.START_STOP_FLAG; ++batch) {
                if (batch == 1) {
                    this.parameters.globalThroughputThirdInitialTime = this.initialThreadThroughputTime = System.currentTimeMillis();
                    this.parameters.globalThroughputSecondInitialTime = this.initialThreadThroughputTime;
                }
                if (this.parameters.timeout > 0L) {
                    Thread.sleep(this.parameters.timeout);
                }
                this.retEntries = this.space.takeMultiple(this.takeTemplate, this.transaction, this.parameters.batchAmount);
                if (this.retEntries.length != this.parameters.batchAmount) {
                    throw new Exception("Thread " + Thread.currentThread().getName() + "\nTAKE MULTIPLE operation returned " + this.retEntries.length + " entries, while expecting  " + this.parameters.batchAmount + " within batch# " + batch + ".\nTry to increase timeout if performing a parallel operation.");
                }
                if (this.parameters.delayReadTake != 0) {
                    Thread.sleep(this.parameters.delayReadTake);
                }
                if (this.transaction != null) {
                    if (this.parameters.isSingleTransaction && batch * this.parameters.batchAmount % this.parameters.numberOfIterations == 0) {
                        this.transaction.commit();
                    } else if (batch * this.parameters.batchAmount % this.parameters.txIterations == 0) {
                        this.transaction.commit();
                        if (batch < this.parameters.numOfBatches) {
                            this.transaction = this.createTx();
                        }
                    }
                }
                if (this.parameters.isThreadThroughput) {
                    this.printThreadThroughput("TAKE MULTIPLE", batch, this.parameters.batchAmount);
                }
                if (!this.parameters.isGlobalThroughput) continue;
                int globalTpCounter = this.parameters.globalThroughputThirdOperationCounter.getAndIncrement();
                this.printGlobalOperationThroughput("TAKE MULTIPLE", globalTpCounter + 1, 0, this.parameters.batchAmount);
            }
        }
        catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName() + " failed to complete TAKE MULTIPLE operation of batch");
            ex.printStackTrace();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", ex);
            }
            System.exit(-1);
        }
    }
}

