/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.j_spaces.examples.benchmark.BenchmarkCommand;
import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.MessageAdaptor;
import com.j_spaces.examples.benchmark.MessageAdaptors;
import com.j_spaces.examples.benchmark.ObjectLock;
import com.j_spaces.examples.benchmark.Operation;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicLong;
import net.jini.core.entry.Entry;

public class WriteMultiple
extends Operation {
    private Object[] entries;
    private MessageAdaptor adaptor;
    private static AtomicLong globalCounter = new AtomicLong();

    WriteMultiple(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);
        this.adaptor = MessageAdaptors.getByCode(parameters.messageType);
        this.entries = this.adaptor.isEntry() ? new Entry[parameters.batchAmount] : new Object[parameters.batchAmount];
        this.space = parameters.isNotify && parameters.repSpace != null ? parameters.repSpace : parameters.space;
    }

    @Override
    public void prepare() {
        this.adaptor = MessageAdaptors.getByCode(this.parameters.messageType);
        try {
            this.space.snapshot(this.adaptor.create());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", e);
            }
            System.exit(-1);
        }
    }

    private void prepareArray() {
        for (int count = 0; count < this.parameters.batchAmount; ++count) {
            byte[] content = this.parameters.changeContent ? new byte[this.parameters.messageBuf.length + count] : this.parameters.messageBuf;
            long counter = globalCounter.incrementAndGet();
            this.entries[count] = this.adaptor.create(counter, content);
        }
    }

    @Override
    public void doOperation() {
        try {
            int batchesCount = this.parameters.numOfBatches;
            for (int batch = 1; batch <= batchesCount && BenchmarkCommand.START_STOP_FLAG; ++batch) {
                if (batch == 1) {
                    this.parameters.globalThroughputFirstInitialTime = this.initialThreadThroughputTime = System.currentTimeMillis();
                }
                this.prepareArray();
                this.space.writeMultiple(this.entries, this.transaction, this.parameters.lease);
                if (this.parameters.delayWrite != 0) {
                    Thread.sleep(this.parameters.delayWrite);
                }
                if (this.transaction != null) {
                    if (this.parameters.isSingleTransaction && batch * this.parameters.batchAmount % this.parameters.numberOfIterations == 0) {
                        this.transaction.commit();
                    } else if (batch * this.parameters.batchAmount % this.parameters.txIterations == 0) {
                        this.transaction.commit();
                        if (batch < this.parameters.numOfBatches) {
                            this.transaction = this.createTx();
                        }
                    }
                }
                if (this.parameters.isThreadThroughput) {
                    this.printThreadThroughput("WRITE MULTIPLE", batch, this.parameters.batchAmount);
                }
                if (!this.parameters.isGlobalThroughput) continue;
                int globalTpCounter = this.parameters.globalThroughputFirstOperationCounter.getAndIncrement();
                this.printGlobalOperationThroughput("WRITE MULTIPLE", globalTpCounter + 1, 0, this.parameters.batchAmount);
            }
        }
        catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName() + " failed to complete WRITE MULTIPLE operation of batch");
            ex.printStackTrace();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", ex);
            }
            System.exit(-1);
        }
    }
}

