/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.examples.benchmark;

import com.j_spaces.examples.benchmark.BenchmarkCommand;
import com.j_spaces.examples.benchmark.BenchmarkConfiguration;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.MessageAdaptor;
import com.j_spaces.examples.benchmark.ObjectLock;
import com.j_spaces.examples.benchmark.Operation;
import java.rmi.RemoteException;

public class WriteReadUpdateTake
extends Operation {
    private Object writeEntry;

    WriteReadUpdateTake(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);
        this.space = parameters.isNotify && parameters.repSpace != null ? parameters.repSpace : parameters.space;
    }

    @Override
    public void prepare() {
        try {
            MessageAdaptor adaptor = this.parameters.getMessageAdaptor();
            this.writeEntry = adaptor.create(-1L, this.parameters.messageBuf);
            this.parameters.space.snapshot(adaptor.create());
            if (this.parameters.firstOpRange) {
                this.min_iter = this.parameters.firstOpRangeFrom;
                this.max_iter = this.parameters.firstOpRangeTo - 1;
            } else {
                this.min_iter = this.threadID * this.parameters.numberOfIterations;
                this.max_iter = this.min_iter + this.parameters.numberOfIterations - 1;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", e);
            }
            System.exit(-1);
        }
    }

    private void prepareEntry(long iter) {
        long id = this.parameters.isNotify ? (long)this.threadID : iter;
        this.parameters.getMessageAdaptor().setCounter(this.writeEntry, id);
        if (this.parameters.changeContent) {
            this.parameters.getMessageAdaptor().setPayload(this.writeEntry, new byte[this.parameters.messageBuf.length]);
        }
    }

    @Override
    public void doOperation() {
        try {
            for (long iter = (long)this.min_iter; iter <= (long)this.max_iter && BenchmarkCommand.START_STOP_FLAG; ++iter) {
                this.prepareEntry(iter);
                long firstOpTime = System.currentTimeMillis();
                this.space.write(this.writeEntry, this.transaction, this.parameters.lease);
                this.space.update(this.writeEntry, this.transaction, this.parameters.lease, 60000L);
                firstOpTime = System.currentTimeMillis() - firstOpTime;
                this.elapsedTime1 += firstOpTime;
                long secondOpTime = System.currentTimeMillis();
                this.writeEntry = this.space.read(this.writeEntry, this.transaction, this.parameters.timeout);
                secondOpTime = System.currentTimeMillis() - secondOpTime;
                this.elapsedTime2 += secondOpTime;
                long thirdOpTime = System.currentTimeMillis();
                this.writeEntry = this.space.take(this.writeEntry, this.transaction, this.parameters.timeout);
                thirdOpTime = System.currentTimeMillis() - thirdOpTime;
                this.elapsedTime3 += thirdOpTime;
                if (this.parameters.delayWrite != 0) {
                    Thread.sleep(this.parameters.delayWrite);
                }
                if (this.transaction != null) {
                    if (this.parameters.isSingleTransaction && (iter + 1L) % (long)this.parameters.numberOfIterations == 0L) {
                        this.transaction.commit();
                    } else if ((iter + 1L) % (long)this.parameters.txIterations == 0L) {
                        this.transaction.commit();
                        if (iter + 1L < (long)this.max_iter) {
                            this.transaction = this.createTx();
                        }
                    }
                }
                if (this.parameters.isWriteRate) {
                    int rateIter = this.parameters.globalRateIter.getAndIncrement();
                    if (rateIter == 0) {
                        this.parameters.globalInitialRateTime = System.currentTimeMillis();
                    }
                    if ((rateIter + 1) % this.parameters.writeRate == 0) {
                        this.waitWriteRate("BENCH", rateIter + 1);
                    }
                }
                if (this.parameters.isThreadThroughput) {
                    if (iter == (long)this.min_iter) {
                        this.initialThreadThroughputTime = System.currentTimeMillis();
                    }
                    if ((iter + 1L) % this.parameters.threadThroughputIterations == 0L) {
                        this.printThreadThroughput("BENCH", iter + 1L);
                    }
                }
                if (!this.parameters.isGlobalThroughput) continue;
                int globalTpCounter = this.parameters.globalThroughputFirstOperationCounter.getAndIncrement();
                if (globalTpCounter == 0) {
                    this.parameters.globalThroughputFirstInitialTime = System.currentTimeMillis();
                }
                if ((globalTpCounter + 1) % this.parameters.globalThroughputIterations != 0) continue;
                this.printGlobalOperationThroughput("BENCH", globalTpCounter + 1);
            }
        }
        catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName() + " failed to complete WRITE operation of entry");
            ex.printStackTrace();
            if (this.parameters.isGUI) {
                this.benchmarkOutput.showException("Exception", ex);
            }
            System.exit(-1);
        }
    }
}

