/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.metrics.IntroscopeReporterFactory;
import com.gigaspaces.metrics.IntroscopeXmlMetricsBuilder;
import com.gigaspaces.metrics.MetricRegistrySnapshot;
import com.gigaspaces.metrics.MetricReporter;
import com.gigaspaces.metrics.MetricReporterFactory;
import com.gigaspaces.metrics.converter.HierarchyTopLevel;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IntroscopeReporter
extends MetricReporter {
    private static final Logger logger = Logger.getLogger(IntroscopeReporter.class.getName());
    private static final String LOOKUPGROUP_PROP = "com.gs.jini_lus.groups";
    private static final String LOOKUPLOCATOR_PROP = "com.gs.jini_lus.locators";
    private String host;
    private int port;
    private String topLevelName;

    public IntroscopeReporter(IntroscopeReporterFactory factory) {
        super((MetricReporterFactory)factory);
        this.host = factory.getHost();
        this.port = factory.getPort();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config(String.format("IntroscopeReporter created with host = %s and port = %s ", this.host, this.port));
        }
        HierarchyTopLevel hierarchyTopLevel = this.createHierarchyTopLevel(factory);
        hierarchyTopLevel.validate();
        this.topLevelName = hierarchyTopLevel.convertToString();
    }

    public void report(List<MetricRegistrySnapshot> snapshots) {
        block3: {
            String data = new IntroscopeXmlMetricsBuilder(this.topLevelName).prepareXml(snapshots);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(String.format("Sending data %s", data));
            }
            try {
                this.sendData(data);
            }
            catch (IOException exc) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.warning(String.format("Failed to send data [host=%s,port=%s]%n%s", this.host, this.port, data));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(String data) throws IOException {
        Socket socket = null;
        FilterOutputStream outputStream = null;
        try {
            socket = new Socket(this.host, this.port);
            outputStream = new DataOutputStream(socket.getOutputStream());
            ((DataOutputStream)outputStream).writeBytes(data);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
    }

    private HierarchyTopLevel createHierarchyTopLevel(IntroscopeReporterFactory factory) {
        String pattern = factory.getPattern();
        String group = System.getProperty(LOOKUPGROUP_PROP, "");
        String locator = System.getProperty(LOOKUPLOCATOR_PROP, "");
        return new HierarchyTopLevel(pattern, group, locator);
    }
}

