/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.internal.license.LicenseManager;
import com.gigaspaces.internal.license.LicenseType;
import com.gigaspaces.metrics.IntroscopeReporter;
import com.gigaspaces.metrics.MetricReporterFactory;
import com.gigaspaces.metrics.converter.HierarchyTopLevel;
import java.util.Properties;

public class IntroscopeReporterFactory
extends MetricReporterFactory<IntroscopeReporter> {
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String HIERARCHY_PATTERN = "hierarchy_pattern";
    private static final String DEFAULT_PATTERN = HierarchyTopLevel.DEFAULT_FORMAT;
    private String host;
    private int port;
    private String pattern;

    public IntroscopeReporter create() throws Exception {
        LicenseManager.getInstance().validate("Introscope Metrics Reporter", LicenseType.ENTERPRISE);
        return new IntroscopeReporter(this);
    }

    public void load(Properties properties) {
        super.load(properties);
        this.validateProperties(properties);
        this.setHost(properties.getProperty(HOST));
        this.setPort(Integer.parseInt(properties.getProperty(PORT)));
        this.setPattern(properties.getProperty(HIERARCHY_PATTERN, DEFAULT_PATTERN));
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    private void validateProperties(Properties properties) {
        if (!properties.containsKey(HOST)) {
            throw new IllegalArgumentException(String.format("Property %s missing", HOST));
        }
        if (!properties.containsKey(PORT)) {
            throw new IllegalArgumentException(String.format("Property %s missing", PORT));
        }
        try {
            Integer.parseInt(properties.getProperty(PORT));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Property %s cannot be parsed to integer", PORT));
        }
    }
}

