/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics;

import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.metrics.MetricGroupSnapshot;
import com.gigaspaces.metrics.MetricPair;
import com.gigaspaces.metrics.MetricRegistrySnapshot;
import com.gigaspaces.metrics.MetricTagsSnapshot;
import com.gigaspaces.metrics.converter.IntroscopeMetricNameConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IntroscopeXmlMetricsBuilder {
    private static final Logger logger = Logger.getLogger(IntroscopeXmlMetricsBuilder.class.getName());
    private IntroscopeMetricNameConverter converter;
    private static final String STRING_TYPE = "StringEvent";
    private static final String NUMBER_TYPE = "LongCounter";
    private static final String LINE_FORMAT = "<metric type=\"%s\" name=\"%s\" value=\"%s\" />";
    private static final String LINE_SEPARATOR = "\n";

    public IntroscopeXmlMetricsBuilder(String topLevelName) {
        this.converter = new IntroscopeMetricNameConverter(topLevelName);
    }

    public String prepareXml(List<MetricRegistrySnapshot> snapshots) {
        List<MetricPair> metricValues = this.convertToMetricValues(snapshots);
        ArrayList<String> xmlLines = new ArrayList<String>();
        for (MetricPair metricPair : metricValues) {
            xmlLines.add(this.prepareXmlLine(metricPair.getMetricName(), metricPair.getMetricValue()));
        }
        return StringUtils.join(xmlLines, (String)LINE_SEPARATOR);
    }

    public List<MetricPair> convertToMetricValues(List<MetricRegistrySnapshot> snapshots) {
        ArrayList<MetricPair> metricValues = new ArrayList<MetricPair>();
        for (MetricRegistrySnapshot snapshot : snapshots) {
            this.collectFromSnapshot(metricValues, snapshot);
        }
        return metricValues;
    }

    public String prepareXmlLine(String metricName, Object metricValue) {
        String valueType = this.guessIntroscopeType(metricValue);
        Object newMetricValue = valueType.equals(NUMBER_TYPE) ? this.roundNumericValue(metricValue) : metricValue;
        return String.format(LINE_FORMAT, valueType, metricName, newMetricValue);
    }

    private String guessIntroscopeType(Object metricValue) {
        return metricValue instanceof Number ? NUMBER_TYPE : STRING_TYPE;
    }

    private Object roundNumericValue(Object metricValue) {
        Number number = (Number)metricValue;
        return Math.round(number.doubleValue());
    }

    private void collectFromSnapshot(List<MetricPair> metricValues, MetricRegistrySnapshot snapshot) {
        for (Map.Entry groupEntry : snapshot.getGroups().entrySet()) {
            this.collectFromGroup(metricValues, (MetricTagsSnapshot)groupEntry.getKey(), (MetricGroupSnapshot)groupEntry.getValue());
        }
    }

    private void collectFromGroup(List<MetricPair> metricValues, MetricTagsSnapshot tags, MetricGroupSnapshot groups) {
        for (Map.Entry metricEntry : groups.getMetricsValues().entrySet()) {
            String metricName = (String)metricEntry.getKey();
            Object metricValue = metricEntry.getValue();
            try {
                String convertedName = this.converter.convert(metricName, tags);
                metricValues.add(new MetricPair(convertedName, metricValue));
            }
            catch (NullPointerException e) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.warning(String.format("Unable to convert metric name to Introscope format, name = %s, value = %s", metricName, metricValue));
            }
        }
    }
}

