/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.converter;

public class HierarchyTopLevel {
    private static String PATTERN_GROUP = "{lookupgroup}";
    private static String PATTERN_LOCATOR = "{lookuplocator}";
    public static String DEFAULT_FORMAT = String.format("%s-%s", PATTERN_GROUP, PATTERN_LOCATOR);
    private String pattern;
    private String lookupgroup;
    private String lookuplocator;

    public HierarchyTopLevel(String pattern, String lookupgroup, String lookuplocator) {
        this.pattern = pattern;
        this.lookupgroup = lookupgroup;
        this.lookuplocator = lookuplocator;
    }

    public String convertToString() {
        return this.pattern.replace(PATTERN_GROUP, this.lookupgroup).replace(PATTERN_LOCATOR, this.lookuplocator);
    }

    public void validate() {
        String converted = this.convertToString();
        if (converted.isEmpty()) {
            throw new IllegalArgumentException(String.format("Empty hierarchy level after conversion (pattern %s)", this.pattern));
        }
        if (converted.contains("{") || converted.contains("}")) {
            throw new IllegalArgumentException(String.format("Incorrect hierarchy level (pattern \"%s\", after conversion \"%s\")", this.pattern, converted));
        }
    }
}

