/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.converter;

import com.gigaspaces.metrics.MetricTagsSnapshot;
import com.gigaspaces.metrics.converter.LusMetricName;
import com.gigaspaces.metrics.converter.MetricName;
import com.gigaspaces.metrics.converter.NameParts;
import com.gigaspaces.metrics.converter.OsMetricName;
import com.gigaspaces.metrics.converter.OtherMetricName;
import com.gigaspaces.metrics.converter.ProcessMetricName;
import com.gigaspaces.metrics.converter.PuMetricName;
import com.gigaspaces.metrics.converter.SpaceMetricName;

public class IntroscopeMetricNameConverter {
    private static final String OS_PREFIX = "os_";
    private static final String PROCESS_PREFIX = "process_";
    private static final String JVM_PREFIX = "jvm_";
    private static final String LRMI_PREFIX = "lrmi_";
    private static final String LUS_PREFIX = "lus_";
    private static final String PU_PREFIX = "pu_";
    private static final String SPACE_PREFIX = "space_";
    private String topLevelName;

    public IntroscopeMetricNameConverter(String topLevelName) {
        this.topLevelName = topLevelName;
    }

    public String convert(String name, MetricTagsSnapshot tags) {
        MetricName typedMetricName = this.create(name);
        NameParts nameParts = typedMetricName.convert(tags, this.topLevelName);
        return nameParts.buildName();
    }

    private MetricName create(String metricName) {
        if (this.isOsMetric(metricName)) {
            return new OsMetricName(metricName);
        }
        if (this.isProcessMetric(metricName)) {
            return new ProcessMetricName(metricName);
        }
        if (this.isLusMetric(metricName)) {
            return new LusMetricName(metricName);
        }
        if (this.isPuMetric(metricName)) {
            return new PuMetricName(metricName);
        }
        if (this.isSpaceMetric(metricName)) {
            return new SpaceMetricName(metricName);
        }
        return new OtherMetricName(metricName);
    }

    private boolean isOsMetric(String metricName) {
        return metricName.startsWith(OS_PREFIX);
    }

    private boolean isProcessMetric(String metricName) {
        return metricName.startsWith(PROCESS_PREFIX) || metricName.startsWith(JVM_PREFIX) || metricName.startsWith(LRMI_PREFIX);
    }

    private boolean isLusMetric(String metricName) {
        return metricName.startsWith(LUS_PREFIX);
    }

    private boolean isPuMetric(String metricName) {
        return metricName.startsWith(PU_PREFIX);
    }

    private boolean isSpaceMetric(String metricName) {
        return metricName.startsWith(SPACE_PREFIX);
    }
}

