/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.converter;

import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.metrics.MetricTagsSnapshot;
import java.util.ArrayList;
import java.util.List;

class NameParts {
    static final String PREFIX = "xap";
    static final String RESOURCE_SEP = "|";
    static final String NAME_SEP = ":";
    private ArrayList<String> parts = new ArrayList();
    private MetricTagsSnapshot tags;

    public NameParts(MetricTagsSnapshot metricTags, String topLevelName) {
        this.tags = metricTags;
        this.addPart(PREFIX);
        this.addPart(topLevelName);
    }

    public NameParts addTag(String tagName) {
        return this.addPart(this.tags.getTags().get(tagName).toString());
    }

    public NameParts addPart(String part) {
        String filteredPart = part.replace(RESOURCE_SEP, "").replace(NAME_SEP, "");
        this.parts.add(filteredPart);
        return this;
    }

    public String buildName() {
        List<String> resourceParts = this.parts.subList(0, this.parts.size() - 1);
        String metricName = this.parts.get(this.parts.size() - 1);
        return StringUtils.join(resourceParts, (String)RESOURCE_SEP) + NAME_SEP + metricName;
    }
}

