/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.converter;

import com.gigaspaces.metrics.MetricTagsSnapshot;
import com.gigaspaces.metrics.converter.MetricName;
import com.gigaspaces.metrics.converter.NameParts;

class OsMetricName
extends MetricName {
    static final String OS_OTHERS = "others";
    static final String NIC = "nic";
    static final String OS = "os";
    static final String OS_NETWORK = "os_network_";
    static final String NETWORK = "network";

    public OsMetricName(String metricName) {
        super(metricName);
    }

    @Override
    public NameParts convert(MetricTagsSnapshot tags, String topLevelName) {
        NameParts nameParts = new NameParts(tags, topLevelName).addTag("host").addPart(OS);
        if (this.name.startsWith(OS_NETWORK)) {
            return nameParts.addPart(NETWORK).addTag(NIC).addPart(this.name.substring(OS_NETWORK.length()));
        }
        return nameParts.addPart(OS_OTHERS).addPart(this.name);
    }
}

