/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.converter;

import com.gigaspaces.metrics.MetricTagsSnapshot;
import com.gigaspaces.metrics.converter.MetricName;
import com.gigaspaces.metrics.converter.NameParts;

class ProcessMetricName
extends MetricName {
    static final String PROCESS_NAME = "process_name";

    public ProcessMetricName(String metricName) {
        super(metricName);
    }

    @Override
    public NameParts convert(MetricTagsSnapshot tags, String topLevelName) {
        NameParts nameParts = new NameParts(tags, topLevelName);
        if (tags.getTags().containsKey("pu_name")) {
            return nameParts.addPart("pu").addTag("pu_name").addTag("pu_instance_id").addPart(this.name);
        }
        String pidAndName = String.format("%s_%s", tags.getTags().get(PROCESS_NAME), tags.getTags().get("pid"));
        return nameParts.addTag("host").addPart(pidAndName).addPart(this.name);
    }
}

