/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.metrics.converter;

import com.gigaspaces.metrics.MetricTagsSnapshot;
import com.gigaspaces.metrics.converter.MetricName;
import com.gigaspaces.metrics.converter.NameParts;

class SpaceMetricName
extends MetricName {
    static final String SPACE = "space";
    static final String SPACE_PREFIX = "space_";
    static final String SPACE_NAME = "space_name";
    static final String SPACE_INSTANCE_ID = "space_instance_id";
    static final String BACKUP = "backup";
    static final String PRIMARY = "primary";

    public SpaceMetricName(String metricName) {
        super(metricName);
    }

    @Override
    public NameParts convert(MetricTagsSnapshot tags, String topLevelName) {
        return new NameParts(tags, topLevelName).addPart(SPACE).addTag(SPACE_NAME).addPart(this.getSpaceIdLevel(tags)).addPart(this.name.substring(SPACE_PREFIX.length()));
    }

    private String getSpaceIdLevel(MetricTagsSnapshot tags) {
        return this.getInstanceType(tags) + tags.getTags().get(SPACE_INSTANCE_ID);
    }

    private String getInstanceType(MetricTagsSnapshot tags) {
        boolean isPrimary = tags.getTags().get(SPACE_INSTANCE_ID).toString().matches("[0-9]+");
        return isPrimary ? PRIMARY : BACKUP;
    }
}

