/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.extension.XapExtensions;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class RuntimeInfo {
    private static boolean isFirstTime = true;

    public static void logRuntimeInfo(Logger logger, String prefix) {
        if (logger.isLoggable(Level.INFO)) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, prefix + RuntimeInfo.getEnvironmentInfoIfFirstTime(true));
            } else {
                logger.log(Level.INFO, prefix + RuntimeInfo.getEnvironmentInfoIfFirstTime(false));
            }
        }
    }

    public static String getEnvironmentInfoIfFirstTime() {
        return RuntimeInfo.getEnvironmentInfoIfFirstTime(false);
    }

    public static String getEnvironmentInfoIfFirstTime(boolean verbose) {
        return isFirstTime ? RuntimeInfo.getEnvironmentInfo(verbose) : "";
    }

    public static String getEnvironmentInfo() {
        return RuntimeInfo.getEnvironmentInfo(false);
    }

    public static String getEnvironmentInfo(boolean verbose) {
        isFirstTime = false;
        return XapExtensions.getInstance().getXapRuntimeReporter().generate(verbose, "System Report", '*', 120);
    }

    public static void main(String[] args) {
        System.out.println(RuntimeInfo.getEnvironmentInfo(true));
    }
}

